/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.physicalGroups;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.TTGUIBasePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.ide.Ide;

public class PhysicalGroupDeletePanel
extends TTGUIBasePanel {
    private static Logger _logger = Logger.getLogger(PhysicalGroupDeletePanel.class.getPackage().getName());
    private String PGName;
    private JLabel _label;

    public PhysicalGroupDeletePanel(String string) {
        this.PGName = string;
        this._label = new JLabel(MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleteConfirmation"), string));
        this._label.setName(MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleteConfirmation"), string));
        this.add((Component)this._label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.deletePG();
    }

    private void deletePG() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.physicalGroupDelete"), MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleting"), this.PGName), null);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridMouseListener.expander.saveExpansionState();
                    PhysicalGroupDeletePanel.this._progressMonitor.start();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.physicalGroupDeleting"), PhysicalGroupDeletePanel.this.PGName));
                    GridCommand gridCommand = GridCommand.PHYSICAL_DELETE;
                    gridCommand.prepareCommand(PhysicalGroupDeletePanel.this.PGName);
                    PhysicalGroupDeletePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    PhysicalGroupDeletePanel.this.grid.setGridComponents(PhysicalGroupDeletePanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                PhysicalGroupDeletePanel.this._progressMonitor.finish();
                if (!PhysicalGroupDeletePanel.this._progressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.hostDeletionCancelled"));
                    PhysicalGroupDeletePanel.this._progressMonitor.updateMessage(Messages.getString("TimesTenGrid.hostDeletionCancelled"));
                } else {
                    PhysicalGroupDeletePanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

