/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.Deletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DifferenceObject;
import oracle.dbtools.raptor.timesten.grid.object.Executable;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;

public class InstallationObject
extends TTGridObject
implements Executable,
Deletable {
    private String location;
    private String sourceAddress;
    private String sourceType;
    private String sourcePath;
    private String sourceRelease;
    private HostObject host;
    private List<InstanceObject> instancesUsing;

    public InstallationObject(HostObject hostObject, String string) {
        this.name = string;
        this.host = hostObject;
        this.instancesUsing = new ArrayList<InstanceObject>();
    }

    public HostObject getHost() {
        return this.host;
    }

    public void setHost(HostObject hostObject) {
        this.host = hostObject;
    }

    public List<InstanceObject> getInstancesUsing() {
        return this.instancesUsing;
    }

    @Override
    public String getFullName() {
        if (this.host != null) {
            return this.host.getName() + "." + this.getName();
        }
        return this.getName();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(String string) {
        this.sourceAddress = string;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String string) {
        this.sourceType = string;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String string) {
        this.sourcePath = string;
    }

    public String getSourceRelease() {
        return this.sourceRelease;
    }

    public void setSourceRelease(String string) {
        this.sourceRelease = string;
    }

    public String getSource() {
        if (this.sourceAddress != null && this.sourcePath != null) {
            if (this.sourceAddress.contains(":")) {
                return "[" + this.sourceAddress + "]:" + this.sourcePath;
            }
            return this.sourceAddress + ":" + this.sourcePath;
        }
        return "";
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.InstallationObjectName");
    }

    public void setInstallationModel(JsonObject jsonObject) {
        this.setName(jsonObject.getString("name"));
        this.setLocation(jsonObject.getString("location"));
        if (jsonObject.containsKey((Object)"sourceAddr")) {
            this.setSourceAddress(jsonObject.getString("sourceAddr"));
        }
        if (jsonObject.containsKey((Object)"sourceType")) {
            this.setSourceType(jsonObject.getString("sourceType"));
        }
        if (jsonObject.containsKey((Object)"sourcePath")) {
            this.setSourcePath(jsonObject.getString("sourcePath"));
        }
        if (jsonObject.containsKey((Object)"sourceRelease")) {
            this.setSourceRelease(jsonObject.getString("sourceRelease"));
        }
    }

    public String toString() {
        if (this.getName().trim().isEmpty() && this.getLocation().trim().isEmpty()) {
            return " -";
        }
        return this.getName() + " -" + this.getLocation();
    }

    public void diff(DifferenceObject differenceObject, InstallationObject installationObject) {
        InstallationObject installationObject2 = this;
        installationObject2.setAppliedToCurrent(true);
        installationObject.setAppliedToCurrent(true);
        if (!installationObject2.getName().equalsIgnoreCase(installationObject2.getName())) {
            differenceObject.gridObjectEdited(installationObject, installationObject2);
        }
    }

    @Override
    public String getTargetName() {
        return this.getFullName();
    }

    @Override
    public boolean isAvailableForExec() {
        return this.isAppliedToCurrent();
    }

    public void updateSuggestions() {
        TTGridRootNode.getStorage().saveSuggestion("installation", this.getName());
        TTGridRootNode.getStorage().saveSuggestion("INSTALLATION_LOCATION", this.getLocation());
    }

    public static List<String> getInstallationNameSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("installation");
    }

    public static List<String> getInstallationLocationSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("INSTALLATION_LOCATION");
    }

    @Override
    public int getDSG() {
        return this.getHost().getDataSpaceGroup();
    }

    @Override
    public void deleteObject(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.INSTALLATION_DELETE);
        basicDeletable.setCmdArgs(this.host.getName(), this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.installationDelete"));
        basicDeletable.setDeletingObjMsg(MessageFormat.format(Messages.getString("TimesTenGrid.installationDeleting"), this.getFullName()));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.installationDeleting"), this.getFullName()));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.installationDelCancelled"));
        basicDeletable.deleteObject(runnable);
    }
}

