/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.topology.Topology;
import oracle.dbtools.raptor.timesten.grid.topology.TopologyElement;

public class DistributionMap
extends Topology {
    private Map<TopologyElement, TopologyElement> toRemoveReplace;
    private Map<TopologyElement, TopologyElement> toEvictReplace;
    private Set<TopologyElement> toEvict = new HashSet<TopologyElement>();

    public DistributionMap(int n) {
        super(n);
        this.toRemoveReplace = new HashMap<TopologyElement, TopologyElement>();
        this.toEvictReplace = new HashMap<TopologyElement, TopologyElement>();
    }

    public void markToReplace(TopologyElement topologyElement, TopologyElement topologyElement2) {
        this.toRemoveReplace.put(topologyElement, topologyElement2);
    }

    @Override
    public void markToRemove(TopologyElement topologyElement) {
        if (this.isLocallyMarkedToAdd(topologyElement)) {
            this.toAdd.remove(topologyElement);
            this.toAddDSG.remove(topologyElement);
            TopologyElement topologyElement2 = null;
            for (TopologyElement topologyElement3 : this.toRemoveReplace.keySet()) {
                if (this.toRemoveReplace.get(topologyElement3) != topologyElement) continue;
                topologyElement2 = topologyElement3;
            }
            this.toRemoveReplace.remove(topologyElement2);
            topologyElement2 = null;
            for (TopologyElement topologyElement3 : this.toEvictReplace.keySet()) {
                if (this.toEvictReplace.get(topologyElement3) != topologyElement) continue;
                topologyElement2 = topologyElement3;
            }
            this.toEvictReplace.remove(topologyElement2);
        } else if (!this.toRemove.contains(topologyElement)) {
            this.toRemove.add(topologyElement);
        }
    }

    @Override
    public Set<TopologyElement> getElementsMarkedToAdd(int n) {
        HashSet<TopologyElement> hashSet = new HashSet();
        hashSet = super.getElementsMarkedToAdd(n);
        for (TopologyElement topologyElement : this.toRemoveReplace.values()) {
            if (topologyElement.getDataSpaceGroup() != n) continue;
            hashSet.add(topologyElement);
        }
        for (TopologyElement topologyElement : this.toEvictReplace.values()) {
            if (topologyElement.getDataSpaceGroup() != n) continue;
            hashSet.add(topologyElement);
        }
        return hashSet;
    }

    public void markToEvict(TopologyElement topologyElement) {
        if (!this.toRemove.contains(topologyElement)) {
            this.toEvict.add(topologyElement);
        }
    }

    public void markToEvictReplace(TopologyElement topologyElement, TopologyElement topologyElement2) {
        this.toEvictReplace.put(topologyElement, topologyElement2);
    }

    @Override
    public boolean isMarkedToAdd(TopologyElement topologyElement) {
        return super.isMarkedToAdd(topologyElement) || this.toRemoveReplace.containsValue(topologyElement) || this.toEvictReplace.containsValue(topologyElement);
    }

    @Override
    public boolean isLocallyMarkedToAdd(TopologyElement topologyElement) {
        return super.isLocallyMarkedToAdd(topologyElement) || this.toRemoveReplace.containsValue(topologyElement) || this.toEvictReplace.containsValue(topologyElement);
    }

    @Override
    public boolean isMarkedToRemove(TopologyElement topologyElement) {
        return super.isMarkedToRemove(topologyElement) || this.toRemoveReplace.containsKey(topologyElement) || this.toEvictReplace.containsKey(topologyElement) || this.toEvict.contains(topologyElement);
    }

    public Map<TopologyElement, TopologyElement> getToRemoveReplace() {
        return this.toRemoveReplace;
    }

    public Set<TopologyElement> getToEvict() {
        return this.toEvict;
    }

    public Map<TopologyElement, TopologyElement> getToEvictReplace() {
        return this.toEvictReplace;
    }

    @Override
    public void clear() {
        super.clear();
        this.toRemoveReplace.clear();
        this.toEvict.clear();
        this.toEvictReplace.clear();
    }

    public String[] getReplicaSets() {
        String[] stringArray = new String[((Set)this.topology.get(1)).size()];
        for (int i = 0; i < ((Set)this.topology.get(1)).size(); ++i) {
            stringArray[i] = "Replica Set " + (i + 1);
        }
        return stringArray;
    }

    public TopologyElement getElement(int n, int n2) {
        for (TopologyElement topologyElement : (Set)this.topology.get(n)) {
            if (topologyElement.getReplicaSet() != n2) continue;
            return topologyElement;
        }
        return null;
    }

    @Override
    public void clearChanges() {
        super.clearChanges();
        this.clear();
    }

    @Override
    public boolean changesPending() {
        return super.changesPending() || !this.toEvict.isEmpty() || !this.toRemoveReplace.isEmpty() || !this.toEvictReplace.isEmpty();
    }

    public Set<Element> getElementsInDistMap() {
        HashSet<Element> hashSet = new HashSet<Element>();
        for (TopologyElement topologyElement : this.inTopology) {
            hashSet.add((Element)topologyElement);
        }
        return hashSet;
    }
}

