/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.loginspector.LogFilter;
import oracle.dbtools.raptor.timesten.grid.navigator.AbstractNode;
import oracle.dbtools.raptor.timesten.grid.navigator.NodeFilterPanel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstallationObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.grid.object.PhysicalGroupObject;
import oracle.dbtools.raptor.timesten.grid.object.RepositoryObject;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;
import oracle.dbtools.raptor.timesten.utils.FilterData;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.explorer.CustomTree;
import oracle.javatools.icons.OracleIcons;

public class GridNodeManager {
    private String label;
    private AbstractNode gridRootNode;
    private AbstractNode gridModelFolderNode;
    private AbstractNode databasesFolderNode;
    private AbstractNode mgmtInstancesFolderNode;
    private AbstractNode dataHostFolderNode;
    private AbstractNode dbDefinitionsFolderNode;
    private AbstractNode PGFolderNode;
    private AbstractNode sitesFolderNode;
    private AbstractNode repositoriesFolderNode;
    private AbstractNode shellNode;
    private AbstractNode instStatusNode;
    private AbstractNode memConfigNode;
    private AbstractNode instanceConfigNode;
    private AbstractNode sqlNetNode;
    private AbstractNode tnsNamesNode;
    private FilterData hostFilter;
    private Icon gridIcon;
    private CustomTree customTree;
    public static final String DATABASES_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.databases");
    public static final String MODEL_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.gridModel");
    public static final String MGMTHOST_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.MgmtInstances");
    public static final String DATAHOST_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.DataHosts");
    public static final String FILTERED_DATAHOST_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.DataHostsFiltered");
    public static final String DBDEF_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.dbDefs");
    public static final String SITES_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.sites");
    public static final String REPOSITORIES_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.Repositories");
    public static final String PG_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.physicalGroups");
    public static final String INSTANCES_LABEL = Messages.getString("TimesTenGrid.instances");
    public static final String HOST_INSTANCES_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.DataInstances");
    public static final String HOST_INSTALLATIONS_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.installations");
    public static final String CS_CONN_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.CSConnFolder");
    public static final String DIR_CONN_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.DConnFolder");
    public static final String INST_STATUS_NODE_LABEL = Messages.getString("TimesTenGrid.instStatus");
    public static final String REPOSITORY_BACKUP_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.BackupFolder");
    public static final String REPOSITORY_EXPORT_FOLDER_NODE_LABEL = Messages.getString("TimesTenGrid.ExportFolder");

    public GridNodeManager(String string) {
        this.label = string;
        this.init();
    }

    private void init() {
        if (this.gridRootNode == null) {
            this.gridRootNode = new AbstractNode(this.label, true, OracleIcons.getIcon((String)"accessors.png"), AbstractNode.NodeType.GRID_NODE);
        }
        this.databasesFolderNode = new AbstractNode(DATABASES_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.DB_FOLDER_NODE, this.gridRootNode);
        this.gridModelFolderNode = new AbstractNode(MODEL_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.MODEL_FOLDER_NODE, this.gridRootNode);
        this.mgmtInstancesFolderNode = new AbstractNode(MGMTHOST_FOLDER_NODE_LABEL, MGMTHOST_FOLDER_NODE_LABEL, true, Common.GEAR_FOLDER_ICON, false, AbstractNode.NodeType.MGMT_HOST_FOLDER_NODE, this.gridRootNode);
        this.dataHostFolderNode = new AbstractNode(DATAHOST_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.DATA_HOST_FOLDER_NODE, this.gridModelFolderNode);
        this.PGFolderNode = new AbstractNode(PG_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.PG_FOLDER_NODE, this.gridModelFolderNode);
        this.dbDefinitionsFolderNode = new AbstractNode(DBDEF_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.DBDEF_FOLDER_NODE, this.gridModelFolderNode);
        this.sitesFolderNode = new AbstractNode(SITES_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, null, this.gridModelFolderNode);
        this.repositoriesFolderNode = new AbstractNode(REPOSITORIES_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.REPOSITORY_FOLDER_NODE, this.gridModelFolderNode);
        this.gridRootNode.addChild(this.mgmtInstancesFolderNode);
        this.gridRootNode.addChild(this.databasesFolderNode);
        this.gridRootNode.addChild(this.gridModelFolderNode);
        this.gridModelFolderNode.addChild(this.dataHostFolderNode);
        this.gridModelFolderNode.addChild(this.PGFolderNode);
        this.gridModelFolderNode.addChild(this.dbDefinitionsFolderNode);
        this.gridModelFolderNode.addChild(this.sitesFolderNode);
        this.gridModelFolderNode.addChild(this.repositoriesFolderNode);
        this.shellNode = new AbstractNode();
        this.shellNode.setShortLabel(this.label);
        this.shellNode.setLongLabel(this.label);
        this.shellNode.setType(AbstractNode.NodeType.SHELL_NODE);
        this.instStatusNode = new AbstractNode();
        this.instStatusNode.setShortLabel(INST_STATUS_NODE_LABEL);
        this.instStatusNode.setLongLabel(INST_STATUS_NODE_LABEL);
        this.instStatusNode.setType(AbstractNode.NodeType.INST_STATUS_NODE);
        this.hostFilter = new FilterData();
    }

    public void setGridName(String string) {
        this.gridRootNode.setShortLabel(string);
        this.gridRootNode.setLongLabel(string);
    }

    public void setCustomTree(CustomTree customTree) {
        if (customTree != null) {
            this.customTree = customTree;
        }
    }

    public CustomTree getCustomTree() {
        return this.customTree;
    }

    public void updateIcon(boolean bl) {
        this.gridRootNode.setShowOverlayIcon(!bl);
        this.refresh();
    }

    private void refresh() {
        if (this.customTree != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.customTree.updateUI();
                this.customTree.repaint();
            } else {
                SwingUtilities.invokeLater(() -> {
                    this.customTree.updateUI();
                    this.customTree.repaint();
                });
            }
        }
    }

    public void clear() {
        if (this.gridRootNode != null) {
            this.gridRootNode.removeChild(this.databasesFolderNode);
            this.gridRootNode.removeChild(this.gridModelFolderNode);
            this.gridRootNode.removeChild(this.mgmtInstancesFolderNode);
        }
        this.init();
    }

    public void addHostNode(HostObject hostObject) {
        this.addHostNode(hostObject, null, null);
    }

    private boolean matches(String string, String string2, LogFilter.FilterMode filterMode) {
        String string3 = null;
        boolean bl = false;
        switch (filterMode) {
            case EQUAL: 
            case REGEX: {
                string3 = string2;
                break;
            }
            case NOT_LIKE: {
                string3 = string2.replace("%", ".*").replace("_", ".{1}");
                bl = true;
                break;
            }
            case LIKE: {
                string3 = string2.replace("%", ".*").replace("_", ".{1}");
                break;
            }
            case NOT_EQUAL: {
                string3 = string2;
                bl = true;
            }
        }
        Pattern pattern = Pattern.compile(string3);
        if (!bl) {
            return pattern.matcher(string).matches();
        }
        return !pattern.matcher(string).matches();
    }

    private AbstractNode getNewRepositoryNode(RepositoryObject repositoryObject) {
        AbstractNode abstractNode;
        AbstractNode abstractNode2 = new AbstractNode(repositoryObject.getName(), true, Common.REPOSITORY_ICON, AbstractNode.NodeType.REPOSITORY_NODE, this.gridRootNode);
        AbstractNode abstractNode3 = new AbstractNode(REPOSITORY_BACKUP_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.BACKUP_FOLDER_NODE, abstractNode2);
        AbstractNode abstractNode4 = new AbstractNode(REPOSITORY_EXPORT_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.EXPORT_FOLDER_NODE, abstractNode2);
        abstractNode2.addChild(abstractNode3);
        abstractNode2.addChild(abstractNode4);
        for (RepositoryObject.Backup backup : repositoryObject.getRecentBackups()) {
            abstractNode = new AbstractNode(backup.getName(), false, Common.BACKUP_ICON, AbstractNode.NodeType.BACKUP_NODE, abstractNode2);
            abstractNode3.addChild(abstractNode);
        }
        for (RepositoryObject.Backup backup : repositoryObject.getRecentExports()) {
            abstractNode = new AbstractNode(backup.getName(), false, Common.EXPORT_ICON, AbstractNode.NodeType.EXPORT_NODE, abstractNode2);
            abstractNode4.addChild(abstractNode);
        }
        return abstractNode2;
    }

    public void addRepositoryNode(RepositoryObject repositoryObject) {
        if (!this.repositoriesFolderNode.hasNode(repositoryObject.getName())) {
            AbstractNode abstractNode = this.getNewRepositoryNode(repositoryObject);
            this.repositoriesFolderNode.addChild(abstractNode);
        }
    }

    public void addHostNode(HostObject hostObject, String string, LogFilter.FilterMode filterMode) {
        if (!this.dataHostFolderNode.hasNode(hostObject.getName())) {
            boolean bl;
            boolean bl2 = bl = filterMode != null ? this.matches(hostObject.getName(), string, filterMode) : true;
            if (bl) {
                AbstractNode object = this.getNewHostNode(hostObject, false);
                this.dataHostFolderNode.addChild(object);
            }
        }
        if (hostObject.isMgmtHost()) {
            for (InstanceObject instanceObject : hostObject.getInstances()) {
                if (!instanceObject.isMgmtInstance() || this.mgmtInstancesFolderNode.hasNode(instanceObject.getName())) continue;
                AbstractNode abstractNode = this.getMgmtInstance(instanceObject);
                this.mgmtInstancesFolderNode.addChild(abstractNode);
            }
        }
        AbstractNode abstractNode = this.getNewHostNode(hostObject, false);
        abstractNode.setMayHaveChildren(false);
        for (PhysicalGroupObject physicalGroupObject : hostObject.getPhysicalGroups()) {
            if (!this.PGFolderNode.hasNode(physicalGroupObject.getName())) continue;
            this.PGFolderNode.getNode(physicalGroupObject.getName()).addChild(abstractNode);
        }
        this.refresh();
    }

    public void refreshHostNode(HostObject hostObject) {
        this.removeHostNode(hostObject);
        this.addHostNode(hostObject, null, null);
        this.dataHostFolderNode.setShortLabel(DATAHOST_FOLDER_NODE_LABEL);
    }

    public void refreshHostNode(HostObject hostObject, String string, LogFilter.FilterMode filterMode) {
        this.removeHostNode(hostObject);
        this.addHostNode(hostObject, string, filterMode);
        this.dataHostFolderNode.setShortLabel(FILTERED_DATAHOST_FOLDER_NODE_LABEL);
    }

    public void removeHostNode(HostObject hostObject) {
        if (this.dataHostFolderNode.hasNode(hostObject.getName())) {
            this.dataHostFolderNode.removeChild(hostObject.getName());
        }
        for (InstanceObject tTGridObject : hostObject.getInstances()) {
            if (!this.mgmtInstancesFolderNode.hasNode(tTGridObject.getFullName())) continue;
            this.mgmtInstancesFolderNode.removeChild(tTGridObject.getFullName());
        }
        for (PhysicalGroupObject physicalGroupObject : hostObject.getPhysicalGroups()) {
            if (!this.PGFolderNode.hasNode(physicalGroupObject.getName())) continue;
            this.PGFolderNode.removeChild(hostObject.getName());
        }
        this.refresh();
    }

    public void addDatabaseNode(DBDefObject dBDefObject) {
        AbstractNode abstractNode = new AbstractNode(dBDefObject.getName(), true, OracleIcons.getIcon((String)"file.png"), AbstractNode.NodeType.DB_DEF_NODE, this.gridRootNode);
        AbstractNode abstractNode2 = new AbstractNode(CS_CONN_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.CS_CONN_FOLDER_NODE, abstractNode);
        AbstractNode abstractNode3 = new AbstractNode(DIR_CONN_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.DIR_CONN_FOLDER_NODE, abstractNode);
        abstractNode.setShowOverlayIcon(this.showWarningIcon(dBDefObject));
        abstractNode.addChild(abstractNode2);
        abstractNode.addChild(abstractNode3);
        for (ConnectableObject connectableObject : dBDefObject.getConnectables()) {
            AbstractNode abstractNode4 = new AbstractNode(connectableObject.getName(), false, OracleIcons.getIcon((String)"dbconn.png"), AbstractNode.NodeType.CONN_NODE, abstractNode);
            abstractNode4.setShowOverlayIcon(this.showWarningIcon(connectableObject));
            if (connectableObject.isCS()) {
                abstractNode2.addChild(abstractNode4);
                continue;
            }
            abstractNode3.addChild(abstractNode4);
        }
        this.dbDefinitionsFolderNode.addChild(abstractNode);
        if (dBDefObject.isAppliedToCurrent()) {
            AbstractNode abstractNode5 = new AbstractNode(dBDefObject.getName(), true, OracleIcons.getIcon((String)"database.png"), AbstractNode.NodeType.DB_NODE, this.gridRootNode);
            abstractNode5.addChild(abstractNode2);
            abstractNode5.addChild(abstractNode3);
            this.databasesFolderNode.addChild(abstractNode5);
        }
        this.refresh();
    }

    public void removeDatabaseNode(DBDefObject dBDefObject) {
        if (this.dbDefinitionsFolderNode.hasNode(dBDefObject.getName())) {
            this.dbDefinitionsFolderNode.removeChild(dBDefObject.getName());
        }
        if (this.databasesFolderNode.hasNode(dBDefObject.getName())) {
            this.databasesFolderNode.removeChild(dBDefObject.getName());
        }
        this.refresh();
    }

    public void addConfigNodes(GridObject gridObject) {
        Icon icon = null;
        if (!gridObject.getMembershipConfiguration().getContent().isEmpty()) {
            icon = Common.FILE_ICON;
        }
        this.memConfigNode = new AbstractNode(Messages.getString("TimesTenGrid.membershipConf"), false, icon, AbstractNode.NodeType.MEMBERSHIP_CONFIG_NODE, this.gridModelFolderNode);
        icon = null;
        if (!gridObject.getInstanceConfiguration().getContent().isEmpty()) {
            icon = Common.FILE_ICON;
        }
        this.instanceConfigNode = new AbstractNode(Messages.getString("TimesTenGrid.instanceConf"), false, icon, AbstractNode.NodeType.INSTANCE_CONFIG_NODE, this.gridModelFolderNode);
        icon = null;
        if (!gridObject.getSQLNet().getContent().isEmpty()) {
            icon = Common.FILE_ICON;
        }
        this.sqlNetNode = new AbstractNode(Messages.getString("TimesTenGrid.sqlNet"), false, icon, AbstractNode.NodeType.SQLNET_NODE, this.gridModelFolderNode);
        icon = null;
        if (!gridObject.getTNSNames().getContent().isEmpty()) {
            icon = Common.FILE_ICON;
        }
        this.tnsNamesNode = new AbstractNode(Messages.getString("TimesTenGrid.tnsNames"), false, icon, AbstractNode.NodeType.TNSNAMES_NODE, this.gridModelFolderNode);
        this.gridModelFolderNode.addChild(this.memConfigNode);
        this.gridModelFolderNode.addChild(this.instanceConfigNode);
        this.gridModelFolderNode.addChild(this.sqlNetNode);
        this.gridModelFolderNode.addChild(this.tnsNamesNode);
    }

    public void addPhysicalGroupNode(PhysicalGroupObject physicalGroupObject) {
        AbstractNode abstractNode = new AbstractNode(physicalGroupObject.getName(), true, OracleIcons.getIcon((String)"group.png"), AbstractNode.NodeType.PG_NODE, this.gridRootNode);
        abstractNode.setShowOverlayIcon(this.showWarningIcon(physicalGroupObject));
        if (!this.PGFolderNode.hasNode(physicalGroupObject.getName())) {
            this.PGFolderNode.addChild(abstractNode);
        }
    }

    public void addPhysicalGroupNode(PhysicalGroupObject physicalGroupObject, List<HostObject> list) {
        AbstractNode abstractNode = new AbstractNode(physicalGroupObject.getName(), true, OracleIcons.getIcon((String)"group.png"), AbstractNode.NodeType.PG_NODE, this.gridRootNode);
        if (!this.PGFolderNode.hasNode(physicalGroupObject.getName())) {
            this.PGFolderNode.addChild(abstractNode);
            abstractNode.setShowOverlayIcon(this.showWarningIcon(physicalGroupObject));
            for (HostObject hostObject : list) {
                if (!hostObject.belongsToPG(physicalGroupObject)) continue;
                AbstractNode abstractNode2 = this.getNewHostNode(hostObject, false);
                abstractNode2.setMayHaveChildren(false);
                abstractNode.addChild(abstractNode2);
            }
        }
    }

    public void removePhysicalGroupNode(PhysicalGroupObject physicalGroupObject) {
        if (this.PGFolderNode.hasNode(physicalGroupObject.getName())) {
            this.PGFolderNode.removeChild(physicalGroupObject.getName());
        }
    }

    public void refreshPhysicalGroupNode(PhysicalGroupObject physicalGroupObject) {
        this.removePhysicalGroupNode(physicalGroupObject);
        this.addPhysicalGroupNode(physicalGroupObject);
    }

    public void refreshPhysicalGroupNode(PhysicalGroupObject physicalGroupObject, List<HostObject> list) {
        this.removePhysicalGroupNode(physicalGroupObject);
        this.addPhysicalGroupNode(physicalGroupObject, list);
    }

    public void refreshDBDefNode(DBDefObject dBDefObject) {
        this.removeDatabaseNode(dBDefObject);
        this.addDatabaseNode(dBDefObject);
    }

    public void refreshConfigNodes(GridObject gridObject) {
        this.memConfigNode.setShowOverlayIcon(this.showWarningIcon(gridObject.getMembershipConfiguration()));
        this.instanceConfigNode.setShowOverlayIcon(this.showWarningIcon(gridObject.getInstanceConfiguration()));
        this.sqlNetNode.setShowOverlayIcon(this.showWarningIcon(gridObject.getSQLNet()));
        this.tnsNamesNode.setShowOverlayIcon(this.showWarningIcon(gridObject.getTNSNames()));
        this.refresh();
    }

    private AbstractNode getNewHostNode(HostObject hostObject, boolean bl) {
        AbstractNode abstractNode;
        AbstractNode abstractNode2 = new AbstractNode(hostObject.getName(), true, Common.HOST_ICON, AbstractNode.NodeType.HOST_NODE, this.gridRootNode);
        AbstractNode abstractNode3 = new AbstractNode(HOST_INSTALLATIONS_FOLDER_NODE_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.INSTALL_FOLDER_NODE, abstractNode2);
        AbstractNode abstractNode4 = new AbstractNode(INSTANCES_LABEL, true, Common.FOLDER_ICON, AbstractNode.NodeType.INSTANCE_FOLDER_NODE, abstractNode2);
        abstractNode2.setShowOverlayIcon(this.showWarningIcon(hostObject));
        abstractNode2.addChild(abstractNode3);
        abstractNode2.addChild(abstractNode4);
        for (InstallationObject tTGridObject : hostObject.getInstallations()) {
            abstractNode = new AbstractNode(tTGridObject.getName(), false, Common.INSTALLATION_ICON, AbstractNode.NodeType.INSTALL_NODE, abstractNode2);
            abstractNode.setShowOverlayIcon(this.showWarningIcon(tTGridObject));
            abstractNode3.addChild(abstractNode);
        }
        for (InstanceObject instanceObject : hostObject.getInstances()) {
            if (bl && !instanceObject.isMgmtInstance()) continue;
            abstractNode = new AbstractNode(instanceObject.getName(), false, Common.INSTANCE_ICON, instanceObject.isMgmtInstance() ? AbstractNode.NodeType.MGMT_INSTANCE_NODE : AbstractNode.NodeType.INSTANCE_NODE, abstractNode2);
            abstractNode.setShowOverlayIcon(this.showWarningIcon(instanceObject));
            abstractNode4.addChild(abstractNode);
        }
        return abstractNode2;
    }

    private AbstractNode getMgmtInstance(InstanceObject instanceObject) {
        AbstractNode abstractNode = new AbstractNode(instanceObject.getFullName(), false, Common.INSTANCE_ICON, instanceObject.isMgmtInstance() ? AbstractNode.NodeType.MGMT_INSTANCE_NODE : AbstractNode.NodeType.INSTANCE_NODE, this.mgmtInstancesFolderNode);
        abstractNode.setShowOverlayIcon(this.showWarningIcon(instanceObject));
        return abstractNode;
    }

    public AbstractNode getGridRootNode() {
        return this.gridRootNode;
    }

    public AbstractNode getShellNode() {
        return this.shellNode;
    }

    public AbstractNode getInstStatusNode() {
        return this.instStatusNode;
    }

    public void launchNodeFilter(GridObject gridObject) {
        NodeFilterPanel nodeFilterPanel = new NodeFilterPanel(gridObject);
        nodeFilterPanel.setFilterInfo(this.hostFilter.getText(), this.hostFilter.getType());
        Dimension dimension = new Dimension(350, 130);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)nodeFilterPanel, (String)Messages.getString("TimesTenGrid.LogFilter"), null);
        nodeFilterPanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(3);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setPreferredSize(dimension);
        jEWTDialog.setMaximumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isOked()) {
            this.hostFilter.setText(nodeFilterPanel.getFilterTxt());
            this.hostFilter.setType(nodeFilterPanel.getFilterType());
            TTGridRootNode.getStorage().saveHostFilterData(gridObject.getGUID(), this.hostFilter);
            this.reloadAllHostsFiltered(gridObject, this.hostFilter.getText(), this.hostFilter.getType());
        }
    }

    public void loadStoredHostFilter(GridObject gridObject) {
        this.hostFilter = TTGridRootNode.getStorage().getHostFilter(gridObject.getGUID());
    }

    public void reApplyHostFilter(GridObject gridObject) {
        if (this.hostFilter.isValid()) {
            this.reloadAllHostsFiltered(gridObject, this.hostFilter.getText(), this.hostFilter.getType());
        }
    }

    public void clearHostFilter(GridObject gridObject) {
        this.hostFilter.clear();
        TTGridRootNode.getStorage().clearHostFilterData(gridObject.getGUID());
        this.reloadAllHosts(gridObject);
    }

    public void reloadAllHosts(GridObject gridObject) {
        for (HostObject hostObject : gridObject.getHosts()) {
            this.refreshHostNode(hostObject);
        }
    }

    public void reloadAllHostsFiltered(GridObject gridObject, String string, LogFilter.FilterMode filterMode) {
        for (HostObject hostObject : gridObject.getHosts()) {
            this.refreshHostNode(hostObject, string, filterMode);
        }
    }

    private boolean showWarningIcon(TTGridObject tTGridObject) {
        return this.latestVersionDisplayed() && (!tTGridObject.isAppliedToCurrent() || tTGridObject.isEditedInLatest());
    }

    private boolean latestVersionDisplayed() {
        GridObject gridObject = TTGridRootNode.getInstance().getGrid(this.gridRootNode.getShortLabel());
        if (gridObject != null) {
            return gridObject.getShowingVersion() == GridObject.ModelVersion.LATEST;
        }
        return true;
    }
}

