/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntry;

public class TTLogEntryViewer
extends JPanel
implements ActionListener {
    private JLabel dateLbl;
    private JLabel severityLbl;
    private JLabel programNameLbl;
    private JLabel PIDLbl;
    private JLabel messageLbl;
    private JTextArea msgContents;

    public TTLogEntryViewer(TTLogEntry tTLogEntry) {
        this.init(tTLogEntry);
    }

    public void setEntry(TTLogEntry tTLogEntry) {
        if (tTLogEntry == null) {
            return;
        }
        this.dateLbl.setText(MessageFormat.format(Messages.getString("TimesTenGrid.LogDateP"), tTLogEntry.getStringTimeStamp()));
        this.severityLbl.setText(MessageFormat.format(Messages.getString("TimesTenGrid.LogSeverityP"), new Object[]{tTLogEntry.getLevel()}));
        this.programNameLbl.setText(MessageFormat.format(Messages.getString("TimesTenGrid.LogProgNameP"), tTLogEntry.getShortProgramName()));
        this.PIDLbl.setText(MessageFormat.format(Messages.getString("TimesTenGrid.LogPIDP"), tTLogEntry.getPID()));
        this.messageLbl.setText(Messages.getString("TimesTenGrid.LogMsgP"));
        this.msgContents.setVisible(true);
        this.msgContents.setText(tTLogEntry.getMessage());
    }

    public void init(TTLogEntry tTLogEntry) {
        this.setLayout(new GridBagLayout());
        this.dateLbl = new JLabel();
        this.severityLbl = new JLabel();
        this.programNameLbl = new JLabel();
        this.PIDLbl = new JLabel();
        this.messageLbl = new JLabel();
        this.msgContents = new JTextArea(0, 25);
        this.setEntry(tTLogEntry);
        this.msgContents.setLineWrap(true);
        this.msgContents.setOpaque(false);
        this.msgContents.setEditable(false);
        this.msgContents.setFocusable(false);
        this.msgContents.setBackground(UIManager.getColor("Label.background"));
        this.msgContents.setFont(UIManager.getFont("Label.font"));
        this.msgContents.setBorder(UIManager.getBorder("Label.border"));
        this.msgContents.setVisible(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.dateLbl, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.severityLbl, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.programNameLbl, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.PIDLbl, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.messageLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.msgContents, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTenGrid.LogEntryInfo")));
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void clearEntry() {
        this.dateLbl.setText("");
        this.severityLbl.setText("");
        this.programNameLbl.setText("");
        this.PIDLbl.setText("");
        this.messageLbl.setText("");
        this.msgContents.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

