/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.JButton;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.editors.GridStatusPanel;
import oracle.dbtools.raptor.timesten.grid.editors.SummaryPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.shell.swing.TimesTenShellPanel;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class GridEditor
extends TTBaseEditor
implements ActionListener {
    private SummaryPanel _summaryPanel;
    private GridStatusPanel _statusPanel;
    private JButton _lessMoreButton;
    private TimesTenShellPanel _shellPanel;
    static List<String> GRID_SUMMARY = new ArrayList<String>();
    static List<String> MORE_SUMMARY;

    public GridEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._lessMoreButton = new JButton(Messages.getString("TimesTenGrid.more"));
            this._lessMoreButton.addActionListener(this);
            this._summaryPanel = new SummaryPanel(this._lessMoreButton);
            this._statusPanel = new GridStatusPanel();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.summary"), this._summaryPanel);
            this._tabbedPane.addTab(Messages.getString("TimesTen.common.status"), this._statusPanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.GRID_EDITOR.toString());
            this.initialized = true;
        }
    }

    public void showShellTab(String string, String string2, char[] cArray, String string3, String string4, String string5) {
        int n;
        if (this._shellPanel == null) {
            this._shellPanel = new TimesTenShellPanel(string, string2, cArray, string3, string4, false, string5);
            this._tabbedPane.addTab("Shell:" + string, this._shellPanel);
            this._shellPanel.requestComponentFocus();
            this._shellPanel.runOnClose(new Runnable(){

                @Override
                public void run() {
                    GridEditor.this._tabbedPane.remove(GridEditor.this._shellPanel);
                    GridEditor.this._shellPanel = null;
                }
            });
        }
        if ((n = this._tabbedPane.indexOfTab(string)) >= 0) {
            this._tabbedPane.setSelectedIndex(n);
            if (this._tabbedPane.getTabComponentAt(n) != null && this._tabbedPane.getTabComponentAt(n) instanceof TimesTenShellPanel) {
                ((TimesTenShellPanel)this._tabbedPane.getTabComponentAt(n)).requestComponentFocus();
            }
        }
    }

    @Override
    public void updateContent() {
        ArrayList<String> arrayList = new ArrayList<String>(GRID_SUMMARY);
        boolean bl = false;
        if (this._lessMoreButton.getText().equals(Messages.getString("TimesTenGrid.less"))) {
            bl = true;
            arrayList.addAll(MORE_SUMMARY);
        }
        List<String> list = this.getValues(bl);
        this.context.setProperty("SummaryAttr", arrayList);
        this.context.setProperty("SummaryVals", list);
        this._summaryPanel.loadContent(this.context);
        this._statusPanel.loadContent(this.currentGrid.getCreatedDatabases());
    }

    public List<String> getValues(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = GRID_SUMMARY.size();
        int n2 = 0;
        if (bl) {
            n += MORE_SUMMARY.size();
        }
        for (int i = 0; i < n; ++i) {
            arrayList.add("");
        }
        arrayList.set(n2++, this.currentGrid.getShortName());
        GridObject.GridProperties gridProperties = this.currentGrid.getProperties();
        arrayList.set(n2++, String.valueOf(gridProperties.getVersion()));
        arrayList.set(n2++, this.currentGrid.getProperties().getLastModifiedStr());
        arrayList.set(n2++, String.valueOf(gridProperties.getK()));
        arrayList.set(n2++, String.valueOf(this.currentGrid.getCreatedDatabases().size()));
        arrayList.set(n2++, String.valueOf(this.currentGrid.getNumberOfMgmtInstances()));
        arrayList.set(n2++, String.valueOf(this.currentGrid.getNumberOfDataInstances()));
        arrayList.set(n2++, String.valueOf(this.currentGrid.getHosts().size()));
        arrayList.set(n2++, String.valueOf(this.currentGrid.getPhysicalGroups().size()));
        arrayList.set(n2++, String.valueOf(this.currentGrid.getSites().size()));
        arrayList.set(n2++, gridProperties.getMembership());
        arrayList.set(n2++, this.currentGrid.getExecutor().getWorkingHost().getInstanceAdmin());
        if (bl) {
            arrayList.set(n2++, gridProperties.getCreatedStr());
            arrayList.set(n2++, String.valueOf(gridProperties.getAdminUID()));
            arrayList.set(n2++, gridProperties.getAdminGroup());
            arrayList.set(n2++, String.valueOf(gridProperties.getAdminGID()));
            arrayList.set(n2++, String.valueOf(gridProperties.getRetainDays()));
            arrayList.set(n2++, String.valueOf(gridProperties.getRetainVersions()));
            arrayList.set(n2++, gridProperties.getGuid());
            arrayList.set(n2++, gridProperties.getMajorRelease());
            arrayList.set(n2++, gridProperties.getCreatedRelease());
        }
        return arrayList;
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_ID) {
            this.refreshGridInfo();
            return true;
        }
        return false;
    }

    private void refreshGridInfo() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Void doWork() throws TaskException {
                GridMouseListener.expander.setTree(GridEditor.this.currentGrid.getGridNode().getCustomTree());
                GridMouseListener.expander.saveExpansionState();
                try {
                    GridEditor.this.currentGrid.refreshGridModels();
                    GridEditor.this.currentGrid.getGridCurrentModel().diff(GridEditor.this.currentGrid);
                    JsonObject jsonObject = GridEditor.this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.GRID_DISPLAY, true);
                    GridEditor.this.currentGrid.getProperties().setOtherProperties(jsonObject);
                    GridEditor.this.currentGrid.updateDatabasesStatus();
                    GridEditor.this.currentGrid.updateDatabasesConnections(true);
                    GridMouseListener.expander.restoreExpansionState();
                    GridEditor.this.updateContent();
                }
                catch (Exception exception) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), exception.getMessage());
                    GridEditor.this.currentGrid.setPopulating(false);
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setMessage(Messages.getString("TimesTenGrid.fetchingGrindInfo"));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._lessMoreButton) {
            if (this._lessMoreButton.getText().equals(Messages.getString("TimesTenGrid.more"))) {
                this._lessMoreButton.setText(Messages.getString("TimesTenGrid.less"));
                if (!this.currentGrid.getProperties().hasOtherProperties()) {
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){

                        protected Void doWork() throws TaskException {
                            try {
                                JsonObject jsonObject = GridEditor.this.currentGrid.getExecutor().executeCommandGetJson(GridCommand.GRID_DISPLAY, true);
                                GridEditor.this.currentGrid.getProperties().setOtherProperties(jsonObject);
                            }
                            catch (JsonException | GridCommandException throwable) {
                                Common.displayErrorMsg((Component)Ide.getMainWindow(), throwable.getMessage());
                                return null;
                            }
                            GridEditor.this.updateContent();
                            return null;
                        }
                    };
                    raptorTask.setCancellable(false);
                    raptorTask.setMessage(Messages.getString("TimesTenGrid.fetchingGrindInfo"));
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                } else {
                    this.updateContent();
                }
            } else {
                this._lessMoreButton.setText(Messages.getString("TimesTenGrid.more"));
                this.updateContent();
            }
        }
    }

    static {
        GRID_SUMMARY.add(Messages.getString("TimesTen.common.name"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.version"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.lastModified"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.kSafety"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.databases"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.MgmtInstances"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.DataInstances"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.hosts"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.physicalGroups"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.sites"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.membership"));
        GRID_SUMMARY.add(Messages.getString("TimesTenGrid.administrator"));
        MORE_SUMMARY = new ArrayList<String>();
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.created"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.adminUID"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.adminGroup"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.adminGID"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.retainDays"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.retainVersions"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.gridGUID"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.majorRelease"));
        MORE_SUMMARY.add(Messages.getString("TimesTenGrid.createdRelease"));
    }
}

