/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.LatestModelChangesPanel;
import oracle.dbtools.raptor.timesten.grid.database.NewDBDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.Element;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.dbtools.raptor.timesten.grid.object.HostObject;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;

public class WizardAttributesDefinition
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private GridObject currentGrid = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
    private TraversableContext dataContext;
    private NewDBDefinitionPanel newDBDefPanel = null;
    private DatabaseObject db;

    public WizardAttributesDefinition() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.newDBDefPanel = new NewDBDefinitionPanel(this.currentGrid);
        this.db = new DatabaseObject(this.currentGrid, this.newDBDefPanel.getNewDBDef(), null);
        this.db.getDistributionMap().clear();
        for (HostObject hostObject : this.currentGrid.getHosts()) {
            if (!hostObject.hasDSG()) continue;
            for (InstanceObject instanceObject : hostObject.getDataInstances()) {
                Element element = new Element();
                element.setInstance(instanceObject);
                this.db.getDistributionMap().save(element);
            }
        }
        this.add(this.newDBDefPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.remove("Ready");
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this.dataContext = traversableContext;
        if (traversableContext.get("ShowDiff") == null) {
            LatestModelChangesPanel latestModelChangesPanel = new LatestModelChangesPanel(this.currentGrid, true, true, true);
            JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)latestModelChangesPanel, (String)Messages.getString("TimesTenGrid.MCWarningTitle"), (ActionListener)latestModelChangesPanel);
            latestModelChangesPanel.setDialog(jEWTDialog);
            jEWTDialog.setButtonMask(7);
            jEWTDialog.setDefaultCloseOperation(2);
            jEWTDialog.setSize(400, 300);
            HelpSystem.getHelpSystem().registerTopic((JComponent)latestModelChangesPanel, TimesTenHelpID.GRID_APPLY_CHANGES.toString());
            jEWTDialog.getComponent(jEWTDialog.getCancelButtonMnemonic()).setFocusable(true);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        }
    }

    public void onExit(final TraversableContext traversableContext) throws TraversalException {
        final WizardAttributesDefinition wizardAttributesDefinition = this;
        if (traversableContext.get("Ready") == null) {
            this.newDBDefPanel.areValuesValid(new Runnable(){

                @Override
                public void run() {
                    traversableContext.put("Ready", (Object)true);
                    try {
                        wizardAttributesDefinition.onExit(traversableContext);
                        traversableContext.getWizardCallbacks().nextPage();
                    }
                    catch (TraversalException traversalException) {
                        // empty catch block
                    }
                }
            });
            throw new TraversalException(null);
        }
    }

    public Object getExitTransition() {
        this.db.setDBDef(this.newDBDefPanel.getNewDBDef());
        this.db.setName(this.newDBDefPanel.getNewDBDef().getName());
        this.dataContext.put("DF_DEF_ATTRIBUTES", (Object)this.db);
        this.dataContext.put("ShowDiff", (Object)false);
        return "Distribute";
    }
}

