/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;

public class DirectoryAttribute
extends DBDefAttribute<String> {
    private static final String TTHOME = "!!TIMESTEN_HOME!!";
    private static final String INST_NAME = "!!INSTANCE_NAME!!";
    private static final String HOST_NAME = "!!HOST_NAME!!";
    private static final String PATH_REGEX = "((/|!!TIMESTEN_HOME!!/|!!INSTANCE_NAME!!/|!!HOST_NAME!!/)(.+/)*(.+))|!!TIMESTEN_HOME!!|!!INSTANCE_NAME!!|!!HOST_NAME!!";
    private Pattern p;
    private String tempValue;

    public Pattern getP() {
        return this.p;
    }

    public DirectoryAttribute(String string, String string2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, String string3, boolean bl) {
        super(string, string2, dBDefAttributeType, bl);
        this.value = string3;
        this.defaultValue = this.value;
        this.p = Pattern.compile(PATH_REGEX);
    }

    public DirectoryAttribute(DirectoryAttribute directoryAttribute) {
        super(directoryAttribute);
        this.defaultValue = directoryAttribute.getDefaultValue();
        this.value = directoryAttribute.getValue();
        this.p = directoryAttribute.getP();
    }

    @Override
    public boolean isValid() {
        this.tempValue = this.attributeName.equalsIgnoreCase("DataStore") ? ((String)this.value).substring(0, ((String)this.value).lastIndexOf(47)) : (String)this.value;
        return this.p.matcher(this.tempValue).matches();
    }

    @Override
    public String getValue() {
        return (String)this.value;
    }

    @Override
    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public void setValueFromString(String string) {
        this.setValue(string);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public String getErrorMessage() {
        return MessageFormat.format(Messages.getString("TimesTenGrid.attributePathError"), this.attributeName);
    }

    @Override
    public String getDBDefValue() {
        return (String)this.value;
    }

    public void setDefaultDirectory(String string) {
        this.defaultValue = string;
    }
}

