/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.database.AttributesDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.database.NewConnectablePanel;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.ConnectableObject;
import oracle.dbtools.raptor.timesten.grid.object.DatabaseObject;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class DatabaseConnectablesPanel
extends JPanel
implements TreeSelectionListener,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JTree connectablesTree;
    private DatabaseObject currentDB;
    private AttributesDefinitionPanel connectableAttributesPanel;
    private DefaultMutableTreeNode root = null;
    private DefaultMutableTreeNode clientServerConnNode = null;
    private DefaultMutableTreeNode directConnNode = null;
    private ConnectablesTreeModel model = null;
    private ConnectableMenu connectableMenu = null;
    private NewConnectableMenu newConnectableMenu = null;
    private JButton newDirectConnButton;
    private JButton newCSConnButton;
    private JButton deleteConnButton;
    private JButton exportConnButton;
    private ConnectableObject emptyConn = new ConnectableObject(null, null);
    private JEWTDialog _dialog;
    private static final Logger logger = Logger.getLogger(DatabaseConnectablesPanel.class.getName());
    private GridObject currentGrid;

    public DatabaseConnectablesPanel(GridObject gridObject) {
        this.currentGrid = gridObject;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.createNodes();
        this.model = new ConnectablesTreeModel(this.root);
        this.connectablesTree = new JTree(this.model){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                    return null;
                }
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                return ((DefaultMutableTreeNode)treePath.getLastPathComponent()).toString();
            }
        };
        this.connectablesTree.setToolTipText("");
        this.connectablesTree.getSelectionModel().setSelectionMode(1);
        this.connectablesTree.addTreeSelectionListener(this);
        this.connectablesTree.addMouseListener(this);
        this.connectableAttributesPanel = new AttributesDefinitionPanel(true, false, null, this.currentGrid);
        this.connectableMenu = new ConnectableMenu();
        this.newConnectableMenu = new NewConnectableMenu();
        JScrollPane jScrollPane = new JScrollPane(this.connectablesTree);
        this.newDirectConnButton = new JButton(Messages.getString("TimesTenGrid.newDirConnectable"));
        this.newCSConnButton = new JButton(Messages.getString("TimesTenGrid.newCSConnectable"));
        this.deleteConnButton = new JButton(Messages.getString("TimesTenGrid.connDelete"));
        this.exportConnButton = new JButton(Messages.getString("TimesTenGrid.connExport"));
        this.newDirectConnButton.addActionListener(this);
        this.newCSConnButton.addActionListener(this);
        this.deleteConnButton.addActionListener(this);
        this.exportConnButton.addActionListener(this);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(20, 20, 20, 20), 0, 0));
        this.add((Component)this.connectableAttributesPanel, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 24, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.newDirectConnButton, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 23, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.newCSConnButton, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 23, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.deleteConnButton, new GridBagConstraints(2, 1, 1, 1, 0.2, 0.0, 24, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.exportConnButton, new GridBagConstraints(3, 1, 1, 1, 0.2, 0.0, 24, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.deleteConnButton.setEnabled(false);
        this.exportConnButton.setEnabled(false);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.connectablesTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ConnectableObject) {
            ConnectableObject connectableObject = (ConnectableObject)object;
            if (connectableObject.getAttributes().isEmpty()) {
                Common.displayInfoMsg(this, Messages.getString("TimesTenGrid.emptyConnectable"), Messages.getString("TimesTenGrid.emptyConnectable"));
            }
            this.connectableAttributesPanel.update(connectableObject.getAttributes());
            this.deleteConnButton.setEnabled(true);
            this.exportConnButton.setEnabled(true);
        } else {
            this.deleteConnButton.setEnabled(false);
            this.exportConnButton.setEnabled(false);
            this.connectableAttributesPanel.update(this.emptyConn.getAttributes());
        }
    }

    private void createNodes() {
        this.root = new DefaultMutableTreeNode(Messages.getString("TimesTenGrid.connectableRoot"));
        this.clientServerConnNode = new DefaultMutableTreeNode(Messages.getString("TimesTenGrid.clientServer"));
        this.root.add(this.clientServerConnNode);
        this.directConnNode = new DefaultMutableTreeNode(Messages.getString("TimesTenGrid.direct"));
        this.root.add(this.directConnNode);
    }

    public void update(DatabaseObject databaseObject) {
        this.currentDB = databaseObject;
        if (SwingUtilities.isEventDispatchThread()) {
            this.clientServerConnNode.removeAllChildren();
            this.directConnNode.removeAllChildren();
            for (ConnectableObject connectableObject : this.currentDB.getDBDef().getConnectables()) {
                if (connectableObject.isCS()) {
                    this.clientServerConnNode.add(new DefaultMutableTreeNode(connectableObject));
                    continue;
                }
                this.directConnNode.add(new DefaultMutableTreeNode(connectableObject));
            }
            this.connectableAttributesPanel.clearTable();
            this.model.reload();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DatabaseConnectablesPanel.this.clientServerConnNode.removeAllChildren();
                        DatabaseConnectablesPanel.this.directConnNode.removeAllChildren();
                        for (ConnectableObject connectableObject : DatabaseConnectablesPanel.this.currentDB.getDBDef().getConnectables()) {
                            if (connectableObject.isCS()) {
                                DatabaseConnectablesPanel.this.clientServerConnNode.add(new DefaultMutableTreeNode(connectableObject));
                                continue;
                            }
                            DatabaseConnectablesPanel.this.directConnNode.add(new DefaultMutableTreeNode(connectableObject));
                        }
                        DatabaseConnectablesPanel.this.connectableAttributesPanel.clearTable();
                        DatabaseConnectablesPanel.this.model.reload();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, "Wrapper");
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n = this.connectablesTree.getClosestRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            this.connectablesTree.setSelectionRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.connectablesTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof ConnectableObject) {
                this.connectableMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (defaultMutableTreeNode != this.root) {
                this.newConnectableMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private void deleteMenuActionPerformed(final ConnectableObject connectableObject) {
        GridCommand gridCommand = GridCommand.DELETE_CONNECTABLE;
        gridCommand.prepareCommand(connectableObject.getName());
        this.currentGrid.executeCommandOnRaptorTask(MessageFormat.format(Messages.getString("TimesTenGrid.deletingConnDBCommand"), connectableObject.getName()), gridCommand, new Runnable(){

            @Override
            public void run() {
                DatabaseConnectablesPanel.this.currentDB.getDBDef().getConnectables().remove(connectableObject);
                DatabaseConnectablesPanel.this.update(DatabaseConnectablesPanel.this.currentDB);
            }
        }, true);
    }

    public static void exportMenuActionPerformed(ConnectableObject connectableObject) {
        String string = connectableObject.getName();
        JFileChooser jFileChooser = new JFileChooser(TTGridRootNode.getInstance().getCurrentDirectory());
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setDialogTitle(Messages.getString("TimesTenGrid.saveConnectableDef"));
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Connectable File (.connect)", "connect"));
        jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[1]);
        int n = 0;
        n = jFileChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            TTGridRootNode.getInstance().setCurrentDirectory(jFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = jFileChooser.getSelectedFile();
            try {
                if (!file.getAbsolutePath().toLowerCase().endsWith(".connectable")) {
                    file = new File(jFileChooser.getSelectedFile().getAbsolutePath() + "." + ((FileNameExtensionFilter)jFileChooser.getFileFilter()).getExtensions()[0]);
                }
                PrintWriter printWriter = new PrintWriter(file);
                StringBuilder stringBuilder = new StringBuilder();
                for (DBDefAttribute dBDefAttribute : connectableObject.getAttributes()) {
                    stringBuilder.append(dBDefAttribute.getAttribute().toLowerCase());
                    stringBuilder.append("=");
                    stringBuilder.append(dBDefAttribute.getDBDefValue());
                    stringBuilder.append("\n");
                }
                printWriter.println(stringBuilder.toString());
                printWriter.close();
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, iOException.getMessage());
            }
        }
    }

    private void launchNewConnectable(boolean bl) {
        NewConnectablePanel newConnectablePanel = new NewConnectablePanel(bl, this.currentDB.getDBDef(), this.currentGrid);
        JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)newConnectablePanel, (String)Messages.getString("TimesTenGrid.newConnectable"), (ActionListener)newConnectablePanel);
        newConnectablePanel.setDialog(jEWTDialog);
        jEWTDialog.setButtonMask(2);
        Dimension dimension = new Dimension(650, 450);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setMinimumSize(dimension);
        jEWTDialog.setDefaultCloseOperation(2);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.addCustomButton((Component)newConnectablePanel.getOkButton());
        jEWTDialog.addActionListener((ActionListener)newConnectablePanel);
        jEWTDialog.setVisible(true);
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newDirectConnButton) {
            this.launchNewConnectable(false);
        } else if (actionEvent.getSource() == this.newCSConnButton) {
            this.launchNewConnectable(true);
        } else if (actionEvent.getSource() == this.exportConnButton) {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.connectablesTree.getLastSelectedPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                DatabaseConnectablesPanel.exportMenuActionPerformed((ConnectableObject)object);
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource() == this.deleteConnButton) {
            try {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.connectablesTree.getLastSelectedPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                ConnectableObject connectableObject = (ConnectableObject)object;
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("TimesTenGrid.deleteConnectable"), connectableObject.getName()), (String)Messages.getString("TimesTenGrid.deleteConnTitle"), null, (boolean)true)) {
                    this.deleteMenuActionPerformed(connectableObject);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ConnectablesTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;

        public ConnectablesTreeModel(TreeNode treeNode) {
            super(treeNode);
        }
    }

    private class ConnectableMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem deleteItem;
        private JMenuItem exportItem;
        private final Component thisPanel = this;

        public ConnectableMenu() {
            this.deleteItem = new JMenuItem(Messages.getString("TimesTenGrid.connDelete"));
            this.exportItem = new JMenuItem(Messages.getString("TimesTenGrid.connExport"));
            this.deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DatabaseConnectablesPanel.this.connectablesTree.getLastSelectedPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    ConnectableObject connectableObject = (ConnectableObject)object;
                    if (MessageDialog.confirm((Component)ConnectableMenu.this.thisPanel, (Object)MessageFormat.format(Messages.getString("TimesTenGrid.deleteConnectable"), connectableObject.getName()), (String)Messages.getString("TimesTenGrid.deleteConnTitle"), null, (boolean)true)) {
                        DatabaseConnectablesPanel.this.deleteMenuActionPerformed(connectableObject);
                    }
                }
            });
            this.exportItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DatabaseConnectablesPanel.this.connectablesTree.getLastSelectedPathComponent();
                    Object object = defaultMutableTreeNode.getUserObject();
                    DatabaseConnectablesPanel.exportMenuActionPerformed((ConnectableObject)object);
                }
            });
            this.add(this.exportItem);
            this.add(this.deleteItem);
        }
    }

    private class NewConnectableMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem newItem = new JMenuItem(Messages.getString("TimesTenGrid.newConnectableDots"));

        public NewConnectableMenu() {
            this.newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)DatabaseConnectablesPanel.this.connectablesTree.getLastSelectedPathComponent();
                    DatabaseConnectablesPanel.this.launchNewConnectable(defaultMutableTreeNode == DatabaseConnectablesPanel.this.clientServerConnNode);
                }
            });
            this.add(this.newItem);
        }
    }
}

