/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.timesten.grid.database.AttributesDefinitionPanel;
import oracle.dbtools.raptor.timesten.grid.editors.TTBaseEditor;
import oracle.dbtools.raptor.timesten.grid.object.DBDefObject;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.dbtools.raptor.timesten.utils.TimesTenHelpID;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;

public class DBDefEditor
extends TTBaseEditor {
    private AttributesDefinitionPanel _attributePanel;
    private DBDefObject currentDBDef = null;
    private static final Logger logger = Logger.getLogger(DBDefEditor.class.getName());

    public DBDefEditor() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        if (!this.initialized) {
            this._attributePanel = new AttributesDefinitionPanel(true, false, null, this.currentGrid);
            this._attributePanel.setAutoresizeTableOff();
            this._tabbedPane.addTab(Messages.getString("TimesTenGrid.dbDef"), this._attributePanel);
            this.helpInfo = new HelpInfo(TimesTenHelpID.DB_DEF_EDITOR.toString());
            this.initialized = true;
        }
    }

    @Override
    public void updateContent() {
        this.currentDBDef = this.currentGrid.getDBDef(this.context.getNode().getShortLabel());
        this.viewTabs();
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == REFRESH_ID) {
            this.refreshInfo(() -> this.viewTabs());
            return true;
        }
        return false;
    }

    public void refreshInfo(final Runnable runnable) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("TimesTenGrid.timesTenGrid"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
            StringBuilder errorMessage;
            {
                super(string, bl, iRaptorTaskRunMode);
                this.errorMessage = new StringBuilder("");
            }

            protected Void doWork() throws TaskException {
                JsonObject jsonObject = null;
                try {
                    jsonObject = DBDefEditor.this.currentGrid.getSynchronizedWithModel(true);
                    JsonArray jsonArray = jsonObject.getJsonArray("dbdefs");
                    boolean bl = false;
                    for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
                        String string = jsonObject2.getString("name");
                        if (string == null || string.equalsIgnoreCase("TTGRIDADMIN") || !string.equalsIgnoreCase(DBDefEditor.this.currentDBDef.getName())) continue;
                        DBDefEditor.this.currentDBDef.setDBDefModel(jsonObject2);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        logger.severe("Cannot find dbdef " + DBDefEditor.this.currentDBDef.getName());
                    }
                }
                catch (JsonException | GridCommandException throwable) {
                    logger.log(Level.SEVERE, this.errorMessage.toString());
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), this.errorMessage.toString());
                    return null;
                }
                runnable.run();
                return null;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(MessageFormat.format(Messages.getString("TimesTenGrid.updateDBInfoTask"), this.currentDBDef.getName()));
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void viewTabs() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._attributePanel.update(this.currentDBDef.getAttributes());
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> this._attributePanel.update(this.currentDBDef.getAttributes()));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
    }
}

