/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.BooleanAttribute;
import oracle.dbtools.raptor.timesten.grid.database.CustomAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;
import oracle.dbtools.raptor.timesten.grid.database.DirectoryAttribute;
import oracle.dbtools.raptor.timesten.grid.database.EnumAttribute;
import oracle.dbtools.raptor.timesten.grid.database.NumberAttribute;

public class DBDefAttributesUtil {
    private ArrayList<DBDefAttribute> allAttributes = null;
    static final String JSON_FILE = "DBDefMetaData.json";
    static final String JSON_ATTR = "attributes";
    static final String JSON_NAME = "name";
    static final String JSON_MANDATORY = "mandatory";
    static final String JSON_ATTR_TYPE = "attributeType";
    static final String JSON_DEF = "definition";
    static final String JSON_INPUT = "inputType";
    static final String JSON_DEFAULT = "default";
    static final String JSON_ENUM_VALS = "enumVals";
    static final String JSON_VAL = "value";
    static final String JSON_DIR = "directory";
    static final String JSON_ENUM = "enum";
    static final String JSON_BOOL = "boolean";
    static final String JSON_CONS = "constraint";
    static final String JSON_NUMB = "number";
    static final String JSON_STR = "custom";
    static final String JSON_MIN = "min";
    static final String JSON_MAX = "max";
    static final String JSON_SHOWDEF = "showEnumName";
    static final String JSON_UNITS = "units";
    static final Logger log = Logger.getLogger(DBDefAttributesUtil.class.getName());

    public ArrayList<DBDefAttribute> loadAttributes(int n) {
        log.log(Level.INFO, "Loading database attributes from DBDefMetaData.json");
        try {
            this.allAttributes = new ArrayList();
            InputStream inputStream = DBDefAttributesUtil.class.getResourceAsStream(JSON_FILE);
            JsonReader jsonReader = Json.createReader((InputStream)inputStream);
            JsonObject jsonObject = jsonReader.readObject();
            JsonArray jsonArray = jsonObject.getJsonArray(JSON_ATTR);
            for (JsonObject jsonObject2 : jsonArray.getValuesAs(JsonObject.class)) {
                String string;
                String string2 = jsonObject2.getString(JSON_NAME);
                boolean bl = jsonObject2.getBoolean(JSON_MANDATORY);
                DBDefAttribute.DBDefAttributeType dBDefAttributeType = DBDefAttribute.DBDefAttributeType.fromString(jsonObject2.getString(JSON_ATTR_TYPE));
                String string3 = Messages.getString(jsonObject2.getString(JSON_DEF));
                switch (string = jsonObject2.getString(JSON_INPUT)) {
                    case "directory": {
                        String string4 = jsonObject2.getString(JSON_DEFAULT);
                        JsonObject jsonObject3 = jsonObject2.getJsonObject(JSON_CONS);
                        this.allAttributes.add(new DirectoryAttribute(string2, string3, dBDefAttributeType, string4, bl));
                        break;
                    }
                    case "enum": {
                        JsonArray jsonArray2 = jsonObject2.getJsonArray(JSON_ENUM_VALS);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        String string5 = null;
                        boolean bl2 = jsonObject2.getBoolean(JSON_SHOWDEF);
                        if (string2.equalsIgnoreCase("topology")) {
                            for (JsonObject jsonObject4 : jsonArray2.getValuesAs(JsonObject.class)) {
                                if (jsonObject4.getInt("k") != n) continue;
                                if (string5 == null) {
                                    string5 = jsonObject4.getString(JSON_NAME);
                                }
                                arrayList.add(jsonObject4.getString(JSON_NAME));
                                arrayList2.add(jsonObject4.getString(JSON_VAL));
                            }
                        } else {
                            string5 = jsonObject2.getString(JSON_DEFAULT);
                            for (JsonObject jsonObject5 : jsonArray2.getValuesAs(JsonObject.class)) {
                                if (string2.equalsIgnoreCase("DatabaseCharacterSet")) {
                                    arrayList2.add(jsonObject5.getString(JSON_NAME));
                                } else {
                                    arrayList2.add(Messages.getString(jsonObject5.getString(JSON_NAME)));
                                }
                                arrayList.add(jsonObject5.getString(JSON_VAL));
                            }
                        }
                        if (string2.equalsIgnoreCase("durability") && n < 2) {
                            arrayList2.clear();
                            arrayList.clear();
                            arrayList2.add("1");
                            arrayList.add("1");
                        }
                        this.allAttributes.add(new EnumAttribute(string2, string3, dBDefAttributeType, arrayList, arrayList2, string5, bl, bl2));
                        break;
                    }
                    case "boolean": {
                        boolean bl3 = jsonObject2.getBoolean(JSON_DEFAULT);
                        this.allAttributes.add(new BooleanAttribute(string2, string3, dBDefAttributeType, bl3, bl));
                        break;
                    }
                    case "number": {
                        int n2 = jsonObject2.getInt(JSON_DEFAULT);
                        String string6 = jsonObject2.getString(JSON_UNITS);
                        JsonObject jsonObject3 = jsonObject2.getJsonObject(JSON_CONS);
                        int n3 = 0;
                        int n4 = 0;
                        boolean bl4 = true;
                        try {
                            n3 = jsonObject3.getInt(JSON_MIN);
                            n4 = jsonObject3.getInt(JSON_MAX);
                        }
                        catch (Exception exception) {
                            bl4 = false;
                        }
                        if (bl4) {
                            this.allAttributes.add(new NumberAttribute(string2, string3, dBDefAttributeType, n2, n4, n3, bl, string6));
                            break;
                        }
                        this.allAttributes.add(new NumberAttribute(string2, string3, dBDefAttributeType, n2, n3, bl, string6));
                        break;
                    }
                    case "custom": {
                        this.allAttributes.add(new CustomAttribute(string2, string3, dBDefAttributeType, bl));
                    }
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "While reading attributes:" + exception.getMessage());
            return null;
        }
        return this.allAttributes;
    }

    public ArrayList<DBDefAttribute> getAttributes(DBDefAttribute.DBDefAttributeType dBDefAttributeType) {
        ArrayList<DBDefAttribute> arrayList = new ArrayList<DBDefAttribute>();
        for (DBDefAttribute dBDefAttribute : this.allAttributes) {
            if (dBDefAttributeType != null && dBDefAttribute.getAttributeType() != dBDefAttributeType) continue;
            arrayList.add(this.getCopy(dBDefAttribute));
        }
        return arrayList;
    }

    public DBDefAttribute getAttribute(String string) {
        for (DBDefAttribute dBDefAttribute : this.allAttributes) {
            if (!dBDefAttribute.getAttribute().equalsIgnoreCase(string)) continue;
            return this.getCopy(dBDefAttribute);
        }
        return new CustomAttribute(string, "");
    }

    private DBDefAttribute getCopy(DBDefAttribute dBDefAttribute) {
        if (dBDefAttribute instanceof BooleanAttribute) {
            return new BooleanAttribute((BooleanAttribute)dBDefAttribute);
        }
        if (dBDefAttribute instanceof DirectoryAttribute) {
            return new DirectoryAttribute((DirectoryAttribute)dBDefAttribute);
        }
        if (dBDefAttribute instanceof EnumAttribute) {
            return new EnumAttribute((EnumAttribute)dBDefAttribute);
        }
        if (dBDefAttribute instanceof NumberAttribute) {
            return new NumberAttribute((NumberAttribute)dBDefAttribute);
        }
        if (dBDefAttribute instanceof CustomAttribute) {
            return new CustomAttribute((CustomAttribute)dBDefAttribute);
        }
        return null;
    }
}

