/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;

public class CustomAttribute
extends DBDefAttribute<String> {
    private String errorMessage;

    public CustomAttribute(String string, String string2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, boolean bl) {
        super(string, string2, dBDefAttributeType, bl);
        this.value = "";
        this.defaultValue = "";
    }

    public CustomAttribute(String string, String string2) {
        super(string, string2, DBDefAttribute.DBDefAttributeType.CUSTOM, false);
        this.value = "";
        this.defaultValue = "";
    }

    public CustomAttribute(CustomAttribute customAttribute) {
        super(customAttribute);
        this.defaultValue = customAttribute.getDefaultValue();
        this.value = customAttribute.getValue();
    }

    @Override
    public String getValue() {
        return (String)this.value;
    }

    @Override
    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public boolean isValid() {
        if (((String)this.value).trim().isEmpty()) {
            this.errorMessage = Messages.getString("TimesTenGrid.valueNotSpecified");
            return false;
        }
        if (this.attributeName.trim().isEmpty()) {
            this.errorMessage = Messages.getString("TimesTenGrid.nameNotSpecified");
            return false;
        }
        return true;
    }

    @Override
    public void setValueFromString(String string) {
        this.setValue(string);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getDBDefValue() {
        return (String)this.value;
    }
}

