/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonException;
import javax.swing.SwingWorker;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.CustomProgressMonitor;
import oracle.dbtools.raptor.timesten.grid.DeleteBasePanel;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.object.GridCommandException;
import oracle.ide.Ide;

public class DeleteInstancePanel
extends DeleteBasePanel {
    private static Logger _logger = Logger.getLogger(DeleteInstancePanel.class.getPackage().getName());
    private String instanceName;

    public DeleteInstancePanel(String string, String string2) {
        super(string);
        this.instanceName = string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.deleteInstance();
    }

    private void deleteInstance() {
        this._progressMonitor = new CustomProgressMonitor((Component)Ide.getMainWindow(), Messages.getString("TimesTenGrid.deleteInstance"), MessageFormat.format(Messages.getString("TimesTenGrid.deletingInstancePW"), this.instanceName, this.hostName), null);
        this._progressMonitor.setCancellable(false);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    GridMouseListener.expander.saveExpansionState();
                    DeleteInstancePanel.this._progressMonitor.start();
                    this.firePropertyChange("message", null, MessageFormat.format(Messages.getString("TimesTenGrid.deletingInstance"), DeleteInstancePanel.this.instanceName, DeleteInstancePanel.this.hostName));
                    GridCommand gridCommand = GridCommand.INSTANCE_DELETE;
                    gridCommand.prepareCommand(DeleteInstancePanel.this.hostName, DeleteInstancePanel.this.instanceName);
                    DeleteInstancePanel.this.grid.getExecutor().executeCommandGetString(gridCommand, true);
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.refreshingGrid"));
                    DeleteInstancePanel.this.grid.setGridComponents(DeleteInstancePanel.this.grid.getExecutor().executeCommandGetJson(GridCommand.EXPORT_MODEL, true), false);
                    this.firePropertyChange("progress", null, 100);
                }
                catch (JsonException | GridCommandException throwable) {
                    _logger.log(Level.SEVERE, throwable.getMessage());
                    this.firePropertyChange("error", null, throwable.getMessage());
                    this.cancel(true);
                }
                return null;
            }

            @Override
            protected void done() {
                DeleteInstancePanel.this._progressMonitor.finish();
                if (!DeleteInstancePanel.this._progressMonitor.successfulExecution() || this.isCancelled()) {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.instDeletionCancelled"));
                } else {
                    this.firePropertyChange("message", null, Messages.getString("TimesTenGrid.taskComplete"));
                    DeleteInstancePanel.this.showModelNeedsApplyWarning();
                    GridMouseListener.expander.restoreExpansionState();
                }
            }
        };
        swingWorker.addPropertyChangeListener(this._progressMonitor);
        this._progressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }
}

