/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;
import oracle.dbtools.raptor.utils.DBObject;

public class ViewMetaDataViewer
extends TTTableViewer {
    private static final Logger _logger = Logger.getLogger(ViewMetaDataViewer.class.getPackage().getName());
    private MyTableModel _model;

    @Override
    protected final String GetPurposeTxt() {
        return "view details";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel(this._dbObject);
            this._table.setModel(this._model);
        } else {
            this._model.init(this._dbObject);
        }
        this._model.fireTableDataChanged();
    }

    public static MyTableModel getViewMetaData(Connection connection, String string, String string2) throws Exception {
        return new MyTableModel(connection, string, string2);
    }

    public static class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theViewInfoColumnNames = new String[]{Messages.getString("ViewMetaDataViewer.columnName"), Messages.getString("ViewMetaDataViewer.dataType"), Messages.getString("ViewMetaDataViewer.nullable"), Messages.getString("ViewMetaDataViewer.columnID")};
        private int theNoColumnsInViewInfo = this.theViewInfoColumnNames.length;

        private MyTableModel(DBObject dBObject) throws Exception {
            try {
                this.init(dBObject);
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process view information " + sQLException.toString());
                throw sQLException;
            }
        }

        private MyTableModel(Connection connection, String string, String string2) throws Exception {
            try {
                this.init(connection, string, string2);
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process view information " + sQLException.toString());
                throw sQLException;
            }
        }

        public final List<Object[]> getMetaData() {
            return this.theRows;
        }

        public final int getNoColumns() {
            return this.theRows.size();
        }

        private void init(Connection connection, String string, String string2) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                this.theRows.clear();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT * FROM \"" + string + "\".\"" + string2 + "\"");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    Object[] objectArray = new Object[this.theNoColumnsInViewInfo];
                    objectArray[0] = resultSetMetaData.getColumnName(i);
                    objectArray[1] = this.getDataType(resultSetMetaData, i);
                    objectArray[2] = resultSetMetaData.isNullable(i) == 1 ? "Yes" : (resultSetMetaData.isNullable(i) == 0 ? "No" : "Unknown");
                    objectArray[3] = i;
                    this.theRows.add(objectArray);
                }
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, "Cannot process index information " + sQLException.toString());
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        private void init(DBObject dBObject) throws SQLException {
            String string = dBObject.getSchemaName();
            String string2 = dBObject.getObjectName();
            Connection connection = dBObject.getConnection();
            this.init(connection, string, string2);
        }

        private String getDataType(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
            Object object = "UNKNOWN";
            int n2 = resultSetMetaData.getPrecision(n);
            int n3 = resultSetMetaData.getScale(n);
            object = "CHAR(" + n2 + ")";
            switch (resultSetMetaData.getColumnType(n)) {
                case 2003: {
                    break;
                }
                case -5: {
                    object = "BIGINT";
                    break;
                }
                case -2: {
                    object = "BINARY(" + n2 + ")";
                    break;
                }
                case -7: 
                case 16: 
                case 2004: {
                    break;
                }
                case 1: {
                    object = "CHAR(" + n2 + ")";
                    break;
                }
                case 70: 
                case 2005: {
                    break;
                }
                case 91: {
                    object = "DATE";
                    break;
                }
                case 2: 
                case 3: {
                    if (n2 != 0 && n3 != -127) {
                        object = "NUMBER(" + n2 + "," + n3 + ")";
                        break;
                    }
                    if (n2 != 0) {
                        object = "NUMBER(" + n2 + ")";
                        break;
                    }
                    object = "NUMBER";
                    break;
                }
                case 2001: {
                    break;
                }
                case 8: {
                    object = "DOUBLE";
                    break;
                }
                case 6: {
                    object = "FLOAT";
                    break;
                }
                case 4: {
                    object = "INTEGER";
                    break;
                }
                case 2000: {
                    break;
                }
                case -4: {
                    object = "VARBINARY(" + n2 + ")";
                    break;
                }
                case -1: {
                    object = "VARCHAR(" + n2 + ")";
                    break;
                }
                case 0: 
                case 1111: {
                    break;
                }
                case 7: {
                    object = "REAL";
                    break;
                }
                case 2006: {
                    break;
                }
                case 5: {
                    object = "SMALLINT";
                    break;
                }
                case 2002: {
                    break;
                }
                case 92: {
                    object = "TIME";
                    break;
                }
                case 93: {
                    if (n3 != 0) {
                        object = "TIMESTAMP(" + n3 + ")";
                        break;
                    }
                    object = "TIMESTAMP";
                    break;
                }
                case 12: {
                    object = "VARCHAR(" + n2 + ")";
                    break;
                }
                case -8: {
                    object = "ROWID";
                    break;
                }
                case -6: {
                    object = "TINYINT";
                }
            }
            return object;
        }

        @Override
        public final int getColumnCount() {
            return this.theViewInfoColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theNoColumnsInViewInfo) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theViewInfoColumnNames[n];
        }
    }
}

