/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.user;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.user.TTUserObject;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class TTUserPanel
extends JPanel {
    JPasswordField userPass2;
    JPasswordField userPass1;
    JTextField userName;
    JCheckBox externalUser;
    JCheckBox passwordExpired;
    JCheckBox accountLocked;
    JComboBox<String> profile;
    private boolean edit;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(TTUserPanel.class.getName());

    public TTUserPanel(boolean bl, boolean bl2) {
        this.edit = bl;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_userdialoguser_html");
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        int n = 0;
        jLabel.setText(oracle.dbtools.db.Messages.getString((String)"UserPanel.1"));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.userName = new JTextField();
        this.userName.getAccessibleContext().setAccessibleName(oracle.dbtools.db.Messages.getString((String)"UserPanel.1"));
        jPanel.add((Component)this.userName, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.externalUser = new JCheckBox(Messages.getString("TTCreateUser.externalUser"));
        this.externalUser.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.externalUser"));
        this.externalUser.setEnabled(false);
        this.externalUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTUserPanel.this.passwordExpired.setEnabled(!TTUserPanel.this.externalUser.isSelected());
            }
        });
        if (bl) {
            jPanel.add((Component)this.externalUser, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        }
        jPanel.add((Component)new JSeparator(0), new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        jLabel2.setText(oracle.dbtools.db.Messages.getString((String)"UserPanel.2"));
        this.userPass1 = new JPasswordField();
        this.userPass1.getAccessibleContext().setAccessibleName(oracle.dbtools.db.Messages.getString((String)"UserPanel.2"));
        jPanel.add((Component)this.userPass1, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(oracle.dbtools.db.Messages.getString((String)"UserPanel.3"));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.userPass2 = new JPasswordField();
        this.userPass2.getAccessibleContext().setAccessibleName(oracle.dbtools.db.Messages.getString((String)"UserPanel.3"));
        jPanel.add((Component)this.userPass2, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.passwordExpired = new JCheckBox(Messages.getString("TTCreateUser.passwordExpired"));
        this.passwordExpired.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.passwordExpired"));
        this.accountLocked = new JCheckBox(Messages.getString("TTCreateUser.accountLocked"));
        this.accountLocked.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.accountLocked"));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(Messages.getString("TTCreateUser.userProfile"));
        this.profile = new JComboBox();
        this.profile.getAccessibleContext().setAccessibleName(Messages.getString("TTCreateUser.userProfile"));
        if (bl2) {
            jPanel.add((Component)jLabel4, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
            jPanel.add(this.profile, new GridBagConstraints(1, n++, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 0, 10), 0, 0));
            jPanel.add((Component)this.accountLocked, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
            jPanel.add((Component)this.passwordExpired, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(10, 10, 0, 0), 0, 0));
        }
        this.add((Component)jPanel, "North");
    }

    void fillComponents(TTUserObject tTUserObject) {
        this.userName.setText(tTUserObject.getUserName());
        this.userName.setEnabled(!tTUserObject.isAlter());
        this.userPass1.setText(tTUserObject.getPassword());
        this.userPass2.setText(tTUserObject.getPassword());
        this.passwordExpired.setSelected(tTUserObject.isPasswordExpired());
        this.accountLocked.setSelected(tTUserObject.isAccountLocked());
        try {
            List<String> list = tTUserObject.getProfiles();
            for (String string : list) {
                this.profile.addItem(string);
            }
            this.profile.setSelectedItem(tTUserObject.getProfile());
        }
        catch (SQLException sQLException) {
            String string = MessageFormat.format(Messages.getString("TTCreateUser.errorGettingProfiles"), sQLException.getMessage());
            logger.severe(string);
            Common.displayErrorMsg((Component)Ide.getMainWindow(), string);
        }
    }

    boolean isEditUserPanel() {
        return this.edit;
    }
}

