/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.lfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTableRow;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.LoadTablesTable;
import oracle.dbtools.raptor.timesten.dialogs.table.lfo.StatusPanel;

public class LoadPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JPanel _tablePanel = new JPanel(new BorderLayout());
    private StatusPanel _statusPanel;
    private LoadTablesTable _loadsTable;
    private int currentSelectedRowIndex = -1;
    static String[] indexOpt = new String[]{Messages.getString("LoadTablesFromOracle.indexCreationOption1"), Messages.getString("LoadTablesFromOracle.indexCreationOption2"), Messages.getString("LoadTablesFromOracle.indexCreationOption3")};

    public LoadPanel(LoadTablesTable loadTablesTable, boolean bl) {
        this._tablePanel.add((Component)new JScrollPane(loadTablesTable), "Center");
        this._loadsTable = loadTablesTable;
        if (bl) {
            this.addSummaryComponents();
        } else {
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this._tablePanel, "Center");
        }
    }

    public StatusPanel getStatusPanel() {
        return this._statusPanel;
    }

    private void addSummaryComponents() {
        this.setLayout(new GridBagLayout());
        this._tablePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTen.common.tables")));
        this._statusPanel = new StatusPanel(new LoadTableRow("", "", "", ""), this._loadsTable);
        this._statusPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimesTen.common.status")));
        int n = 0;
        this.add((Component)this._tablePanel, new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._statusPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._loadsTable.setSelectionMode(1);
        this._loadsTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._loadsTable.getSelectedRow() != this.currentSelectedRowIndex && this._loadsTable.getSelectedRow() != -1) {
            LoadTableRow loadTableRow = this._loadsTable.getData().get(this._loadsTable.getSelectedRow());
            this._statusPanel.changeLoadTableRow(loadTableRow);
            this.currentSelectedRowIndex = this._loadsTable.getSelectedRow();
        }
    }

    public void clearCurrentSelectedRowIndex() {
        this.currentSelectedRowIndex = -1;
    }
}

