/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.countrows;

import java.util.LinkedHashMap;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dss.dataView.LocalDataSource;
import oracle.dss.graph.Graph;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataSource;
import oracle.dss.util.RowOutOfRangeException;

public class CountTableRowsGraph
extends Graph {
    private LinkedHashMap<String, Long[]> linkedMap;
    private ChartDataSource _dataSource = new ChartDataSource();
    private String[] _keys;
    private static final String[] ROW_TITLE = new String[]{"Row count"};

    public CountTableRowsGraph() {
        this.setDataSource((DataSource)this._dataSource);
        this.setGraphType(17);
        this.set3DEffect(false);
        this.setBackgroundTransparent(true);
        this.getX1Title().setText(Messages.getString("CountTableRows.elemenId"));
        this.getX1Title().setVisible(true);
        this.getY1Title().setText(Messages.getString("CountTableRows.rowCount"));
        this.getY1Title().setVisible(true);
        this.getY2Title().setText(Messages.getString("CountTableRows.rowCount"));
        this.getY2Title().setVisible(true);
    }

    public void setData(LinkedHashMap<String, Long[]> linkedHashMap, String[] stringArray) {
        this.linkedMap = linkedHashMap;
        this._keys = stringArray;
        this._dataSource.refreshColumnCount();
        this._dataSource.refreshColumnLabels();
        this.setDataSource((DataSource)this._dataSource);
    }

    public void changeGraphFormatBars() {
        this.setGraphType(17);
    }

    public void changeGraphFormatPie() {
        this.setGraphType(55);
    }

    public void changeGraphFormatRing() {
        this.setGraphType(56);
    }

    private class ChartDataSource
    extends LocalDataSource {
        public ChartDataSource() {
            this.columnCount = CountTableRowsGraph.this.linkedMap != null ? CountTableRowsGraph.this.linkedMap.size() : 0;
        }

        public void refreshColumnCount() {
            this.columnCount = 1;
        }

        public void refreshColumnLabels() {
            this.columnLabels = CountTableRowsGraph.this._keys;
            this.rowLabels = CountTableRowsGraph.this._keys;
            this.rowCount = CountTableRowsGraph.this._keys.length;
        }

        public Object getValue(int n, int n2, String string) throws RowOutOfRangeException, ColumnOutOfRangeException {
            if (CountTableRowsGraph.this.linkedMap.get(CountTableRowsGraph.this._keys[n]) != null) {
                return CountTableRowsGraph.this.linkedMap.get(CountTableRowsGraph.this._keys[n])[0];
            }
            return null;
        }
    }
}

