/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.computesize;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.table.computesize.ComputeSizeSQLPanel;
import oracle.dbtools.raptor.utils.DBObject;

public class ComputeTableSizePanel
extends JPanel {
    private JCheckBox _count_lines;
    private JLabel _owner;
    private JLabel _table;
    private JLabel _countText;
    private JTextField _ownerField;
    private JTextField _tableField;
    private final String COMPUTE_SIZE_ENABLE_LINES = "call ttComputeTabSizes('#owner#.#table#',1);";
    private final String COMPUTE_SIZE_NO_LINES = "call ttComputeTabSizes('#owner#.#table#',0);";
    private ComputeSizeSQLPanel _sqlPanel;

    public ComputeTableSizePanel(DBObject dBObject, ComputeSizeSQLPanel computeSizeSQLPanel) {
        this._sqlPanel = computeSizeSQLPanel;
        this._owner = new JLabel(Messages.getString("TimesTen.common.owner"));
        this._table = new JLabel(Messages.getString("TimesTen.common.name"));
        this._countText = new JLabel(Messages.getString("ComputeTableSize.alsoCountOfLineSizes"));
        this._ownerField = new JTextField(dBObject.getSchemaName(), 30);
        this._tableField = new JTextField(dBObject.getObjectName(), 30);
        this._ownerField.setEditable(false);
        this._tableField.setEditable(false);
        this._count_lines = new JCheckBox();
        this._count_lines.setSelected(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)this._owner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._ownerField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._table, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._tableField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._countText, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._count_lines, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this._sqlPanel.setSQLText(this.getSql());
        this._count_lines.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ComputeTableSizePanel.this._sqlPanel.setSQLText(ComputeTableSizePanel.this.getSql());
            }
        });
    }

    private String getSql() {
        if (this._count_lines.isSelected()) {
            return "call ttComputeTabSizes('#owner#.#table#',1);".replace("#owner#", this._ownerField.getText()).replace("#table#", this._tableField.getText());
        }
        return "call ttComputeTabSizes('#owner#.#table#',0);".replace("#owner#", this._ownerField.getText()).replace("#table#", this._tableField.getText());
    }
}

