/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.utils.DBObject;

public class UpdateTableStatisticsPanel
extends DialogBase {
    private int theRow;
    private JCheckBox theInvCmdCheckBox;
    private boolean theInvCmdFlag;
    private boolean forALLTables = false;
    private JComboBox theIntvlTypeComboBox;
    private IntervalType theIntervalType = IntervalType.COMPLETE_INTERVAL;

    public UpdateTableStatisticsPanel(DBObject dBObject, boolean bl) {
        super(dBObject, null, "UpdateTableStatisticsPanel");
        this.forALLTables = bl;
    }

    @Override
    protected void initGUI() {
        this.setLayout(this.gridbag);
        this.addOwnerAndName(this._dict);
        this.theInvCmdCheckBox = new JCheckBox();
        this.theInvCmdCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("UpdateTableStatisticsPanel.invalidateRefCommands")));
        this.theInvCmdCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() != UpdateTableStatisticsPanel.this.theInvCmdCheckBox) {
                    return;
                }
                int n = itemEvent.getStateChange();
                if (n != 1 && n != 2) {
                    return;
                }
                UpdateTableStatisticsPanel.this.theInvCmdFlag = n == 1;
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("UpdateTableStatisticsPanel.invalidateRefCommands")) + " ");
        jPanel.add(jLabel);
        jPanel.add(this.theInvCmdCheckBox);
        this.addRow(jPanel);
        this.theIntvlTypeComboBox = new JComboBox<String>(IntervalType.getTheTags());
        this.theIntvlTypeComboBox.setSelectedIndex(0);
        this.theIntvlTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == UpdateTableStatisticsPanel.this.theIntvlTypeComboBox) {
                    String string;
                    String string2 = (String)UpdateTableStatisticsPanel.this.theIntvlTypeComboBox.getSelectedItem();
                    UpdateTableStatisticsPanel.this.theIntervalType = string2.equals(string = IntervalType.SINGLE_INTERVAL.getTheTag()) ? IntervalType.SINGLE_INTERVAL : IntervalType.COMPLETE_INTERVAL;
                }
            }
        });
        this.addRow(Messages.getString("UpdateTableStatisticsPanel.intervalTypeForTableStat"));
        this.addRow((Component)null, (Component)this.theIntvlTypeComboBox);
        this._textValues.add(new JTextField());
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(new String(" "));
        return arrayList;
    }

    @Override
    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = "                      ";
        if (this.forALLTables) {
            stringBuffer.append("CALL TTOPTUPDATESTATS('', \n");
        } else {
            stringBuffer.append("CALL TTOPTUPDATESTATS('#OBJECT_OWNER#.#OBJECT_NAME#', \n");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.theInvCmdFlag ? "1" : "0");
        stringBuffer.append(",\n");
        stringBuffer.append(string);
        stringBuffer.append(this.theIntervalType.ordinal());
        stringBuffer.append(")#0#");
        return stringBuffer.toString();
    }

    private static enum IntervalType {
        COMPLETE_INTERVAL("Complete interval"),
        SINGLE_INTERVAL("Single interval");

        private final String theTag;

        private IntervalType(String string2) {
            this.theTag = string2;
        }

        private String getTheTag() {
            return this.theTag;
        }

        private static String[] getTheTags() {
            IntervalType[] intervalTypeArray = IntervalType.values();
            String[] stringArray = new String[intervalTypeArray.length];
            int n = 0;
            for (IntervalType intervalType : intervalTypeArray) {
                stringArray[n] = intervalType.getTheTag();
                ++n;
            }
            return stringArray;
        }
    }
}

