/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class ChangeLTCyclePanel
extends DialogBase {
    private JFormattedTextField gui_lt;
    private JComboBox gui_lt_unit;
    private JComboBox gui_cy_unit;

    @Override
    public boolean applicable(DBObject dBObject) {
        if (this._model != null && this._model.get("LIFETIME") == null) {
            TTDialog.showError(MessageFormat.format(Messages.getString("ChangeLTCyclePanel.thisCommandOnlyApplies"), this.THING));
            return false;
        }
        return true;
    }

    public ChangeLTCyclePanel(DBObject dBObject, String string) {
        super(dBObject, string, "ChangeLTCyclePanel", "aging");
    }

    @Override
    protected void initGUI() {
        this.setLayout(this.gridbag);
        this.addOwnerAndName(this._dict);
        DecimalFormat decimalFormat = new DecimalFormat("#0");
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 1, 0));
        this.gui_lt = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this.gui_lt.setValue(new Integer((String)this._model.get("LIFETIME")));
        jPanel.add(this.gui_lt);
        this._textValues.add(this.gui_lt);
        Object object = (String)this._model.get("LIFETIME UNIT");
        this.gui_lt_unit = !CGCPanel.allowSecondsLevelTBAging(this._dbObject) ? TTDialog.createMenu(new String[]{Messages.getString("TimesTen.common.minutes"), Messages.getString("TimesTen.common.hours"), Messages.getString("TimesTen.common.days")}, (String)object) : TTDialog.createMenu(new String[]{Messages.getString("TimesTen.common.seconds"), Messages.getString("TimesTen.common.minutes"), Messages.getString("TimesTen.common.hours"), Messages.getString("TimesTen.common.days")}, (String)object);
        jPanel.add(this.gui_lt_unit);
        this._textValues.add(this.gui_lt_unit);
        this.addRow(Messages.getString("AgingInfo.lifeTime"), (Component)jPanel);
        jPanel = new JPanel(new GridLayout(1, 2, 1, 0));
        object = new JFormattedTextField(new NumberFormatter(decimalFormat));
        ((JFormattedTextField)object).setValue(new Integer((String)this._model.get("CYCLE")));
        jPanel.add((Component)object);
        this._textValues.add(object);
        String string = (String)this._model.get("CYCLE UNIT");
        this.gui_cy_unit = !CGCPanel.allowSecondsLevelTBAging(this._dbObject) ? TTDialog.createMenu(new String[]{Messages.getString("TimesTen.common.minutes"), Messages.getString("TimesTen.common.hours"), Messages.getString("TimesTen.common.days")}, string) : TTDialog.createMenu(new String[]{Messages.getString("TimesTen.common.seconds"), Messages.getString("TimesTen.common.minutes"), Messages.getString("TimesTen.common.hours"), Messages.getString("TimesTen.common.days")}, string);
        jPanel.add(this.gui_cy_unit);
        this._textValues.add(this.gui_cy_unit);
        this.addRow(Messages.getString("AgingInfo.cycle"), (Component)jPanel);
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public String getSql() {
        boolean bl = CGCPanel.allowSecondsLevelTBAging(this._dbObject);
        String[] stringArray = new String[]{"seconds", "minutes", "hours", "days"};
        String string = "";
        int n = this.gui_lt_unit.getSelectedIndex();
        if (!bl) {
            ++n;
        }
        string = stringArray[n];
        String string2 = "";
        int n2 = this.gui_cy_unit.getSelectedIndex();
        if (!bl) {
            ++n2;
        }
        string2 = stringArray[n2];
        return "alter table " + this._rootTableFullname + "\n    set aging lifetime #1# " + string + ";\nalter table " + this._rootTableFullname + "\n    set aging cycle #3# " + string2;
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.gui_lt.getText().trim().length() == 0) {
            stringBuffer.append(Messages.getString("ChangeLTCyclePanel.lifeTimeCannotBeBlank"));
        }
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }
}

