/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.replication;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.dbtools.raptor.timesten.CacheInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public final class RepAgentPanel
extends TTJPanel
implements ItemListener,
ISqlPromptPanel {
    private JTextField confMsg;
    private int _mode;
    private int _sqlIdx;
    private Hashtable<String, String> _model = null;
    private static final int START_STOP = 0;
    private int _agentStatus = -1;
    private Map<String, Object> _dict = new HashMap<String, Object>();
    private DBObject _dbObject;
    private Database _database;
    private String _conn;
    private List<JComponent> _textValues = new ArrayList<JComponent>();
    private int _repAgentIsRunning = -1;
    private static Logger _logger = Logger.getLogger("RepAgentPanel");
    private Hashtable<String, String> _hash = null;
    private static final String[] actionSql = new String[]{"", "call ttRepStart()", "call ttRepStop()"};

    private void initModel(DBObject dBObject) {
        this._model = new Hashtable();
        if (this._mode == 0) {
            this._agentStatus = CacheInfo.repAgentIsRunning(dBObject);
        }
    }

    @Override
    public boolean applicable(DBObject dBObject) {
        if (this._agentStatus == -1) {
            MessageDialog.error(null, (Object)Messages.getString("RepAgent.unknownRepAgentStatus"), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    public RepAgentPanel(DBObject dBObject, String string) {
        this._dbObject = dBObject;
        this._dict = dBObject.getDictionary();
        this._conn = dBObject.getConnectionName();
        this._database = dBObject.getDatabase();
        this._mode = 0;
        this.initModel(dBObject);
        this._applicable = this.applicable(dBObject);
        if (this._applicable) {
            this.initGUI();
        }
    }

    private void initGUI() {
        this.setLayout(this.gridbag);
        this.confMsg = new JTextField();
        this._textValues.add(this.confMsg);
        if (this._mode == 0) {
            JCheckBox jCheckBox;
            if (this._agentStatus == 1) {
                this.addRow(Messages.getString("RepAgentPanel.theReplicationAgentIsCurrentlyRunning"));
                jCheckBox = new JCheckBox(Messages.getString("RepAgentPanel.stopAgent"));
                this.addRow(jCheckBox);
            } else {
                this.addRow(Messages.getString("RepAgentPanel.theReplicationAgentIsCurrentlyNotRunning"));
                jCheckBox = new JCheckBox(Messages.getString("RepAgentPanel.startAgent"));
                this.addRow(jCheckBox);
            }
            jCheckBox.addItemListener(this);
            this.resetMsgs();
        }
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    private void resetMsgs() {
        this.confMsg.setText(Messages.getString("RepAgentPanel.noActionWasPerformedSinceNoneWasSpecified"));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.resetMsgs();
        if (itemEvent.getStateChange() == 2) {
            this._sqlIdx = 0;
            return;
        }
        if (this._mode == 0) {
            if (this._agentStatus == 0) {
                this._sqlIdx = 1;
                this.confMsg.setText(Messages.getString("RepAgentPanel.RepAgentHasBeenStarted"));
            } else {
                this._sqlIdx = 2;
                this.confMsg.setText(Messages.getString("RepAgentPanel.RepAgentHasBeenStopped"));
            }
        }
    }

    @Override
    public String getSql() {
        return actionSql[this._sqlIdx];
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    @Override
    public List<JComponent> getTextValues() {
        return this._textValues;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("x");
        arrayList.add("x");
        return arrayList;
    }

    @Override
    public DBObject getDbObject() {
        return this._dbObject;
    }
}

