/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.profile;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.profile.TTProfilePanel;
import oracle.dbtools.raptor.timesten.dialogs.profile.TTSqlProfilePanel;
import oracle.dbtools.raptor.timesten.dialogs.user.TTResultPanel;

public class TTProfileDialog {
    private TTProfilePanel profilePanel;
    private TTSqlProfilePanel sqlPanel;
    private TTResultPanel resPanel;

    public void showDialog(final Connection connection, String string, final ObjectActionController.ObjectActionPostProcess objectActionPostProcess) {
        this.profilePanel = new TTProfilePanel(connection, string);
        this.sqlPanel = new TTSqlProfilePanel();
        this.resPanel = new TTResultPanel();
        JPanel[] jPanelArray = new JPanel[3];
        String[] stringArray = new String[3];
        stringArray[0] = Messages.getString("TTCreateProfile.general");
        jPanelArray[0] = this.profilePanel;
        Dimension dimension = new Dimension(400, 400);
        this.profilePanel.setPreferredSize(dimension);
        this.profilePanel.setMinimumSize(dimension);
        stringArray[1] = Messages.getString("TTCreateProfile.sql");
        jPanelArray[1] = this.sqlPanel;
        this.sqlPanel.setPreferredSize(dimension);
        this.sqlPanel.setMinimumSize(dimension);
        stringArray[2] = Messages.getString("TTCreateProfile.results");
        jPanelArray[2] = this.resPanel;
        this.resPanel.setPreferredSize(dimension);
        this.resPanel.setMinimumSize(dimension);
        this.sqlPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TTProfileDialog.this.updateSQL();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TTProfileDialog.this.updateSQL();
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!TTProfileDialog.this.profilePanel.validInput()) {
                    return;
                }
                PipedInputStream pipedInputStream = new PipedInputStream();
                TTProfileDialog.this.resPanel.getSqlPane().setEditable(true);
                TTProfileDialog.this.resPanel.getSqlPane().setText("");
                TTProfileDialog.this.resPanel.getSqlPane().setEditable(false);
                JTabbedPane jTabbedPane = (JTabbedPane)TTProfileDialog.this.resPanel.getParent();
                jTabbedPane.setSelectedIndex(2);
                ScriptExecutor scriptExecutor = new ScriptExecutor(TTProfileDialog.this.profilePanel.getSQL(), connection);
                ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, TTProfileDialog.this.resPanel.getSqlPane().getDocument(), TTProfileDialog.this.resPanel.getSqlPane());
                outputRedirector.setName(Messages.getString("TTCreateProfile.general"));
                outputRedirector.start();
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                    scriptExecutor.setOut(bufferedOutputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                scriptExecutor.start();
                if (!Boolean.TRUE.equals(scriptRunnerContext.getProperty("sqldev.error"))) {
                    objectActionPostProcess.run();
                }
            }
        };
        UIUtils.showPanelAsTabbedDialog2((JPanel[])jPanelArray, (String[])stringArray, (String)(string == null ? Messages.getString("TTProfile.newProfile") : Messages.getString("TTProfile.editProfile")), (ActionListener)actionListener, null, (ChangeListener)changeListener);
    }

    private void updateSQL() {
        this.sqlPanel.updateSQL(this.profilePanel.getSQL());
    }
}

