/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.connection.TTStatsConfigurationPanel;
import oracle.dbtools.raptor.timesten.dialogs.connection.TTStatsDropSnapshotsPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class TTStatsReportPanel
extends JPanel {
    private static final String GET_SNAPSHOTS_SQL = "SELECT * FROM SYS.SNAPSHOT_INFO order by snapshot_id desc";
    private static final String HOME_DIR = System.getProperty("user.home");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TTSTATS_SAVE_FILE = "ttstats-";
    private static final String CAPTURE_LEVEL_NONE = "NONE";
    private final DBObject _dbObject;
    private final Connections _connections = Connections.getInstance();
    private JButton _generateReportButton;
    private JButton _saveButton;
    private int[] _defaultSnapshotId;
    private Connection _conn;
    private File _tmpFile;
    private static final String _htmlReportSQL = "DECLARE htmlOutput TT_STATS.REPORT_TABLE; BEGIN DBMS_OUTPUT.ENABLE(1000000); TT_STATS.GENERATE_REPORT_HTML(:1,:2,:htmlOutput); END;";
    private Method _registerIndexTableOutParameterMethod;
    private Method _getPlsqlIndexTableMethod;
    private JTable _snapshotTable;
    private MyTableModel _tableModel;
    private JSplitPane _splitPane;
    private JTextPane _htmlReport;
    private static Logger _logger = Logger.getLogger(TTStatsConfigurationPanel.class.getPackage().getName());
    private DateFormat _formatter;
    private String _currentReportPrefixName;

    protected TTStatsReportPanel(DBObject dBObject, JButton jButton) {
        this._dbObject = dBObject;
        this._formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        this._saveButton = jButton;
        this.initModel(dBObject);
        this.initGUI();
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        this._snapshotTable = new JTable();
        this._snapshotTable.setModel(this._tableModel);
        this._snapshotTable.setDefaultRenderer(Timestamp.class, new TTStatsDropSnapshotsPanel.DateRenderer());
        this._snapshotTable.setAutoResizeMode(4);
        this._snapshotTable.setAutoCreateRowSorter(true);
        this._snapshotTable.setFillsViewportHeight(true);
        JScrollPane jScrollPane = new JScrollPane(this._snapshotTable, 22, 32);
        this._htmlReport = new JTextPane();
        this._htmlReport.putClientProperty("JEditorPane.w3cLengthUnits", true);
        this._htmlReport.setContentType("text/html");
        this._htmlReport.setPreferredSize(new Dimension(700, 400));
        this._htmlReport.setEditable(false);
        this._htmlReport.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL uRL = hyperlinkEvent.getURL();
                    try {
                        TTStatsReportPanel.this._htmlReport.setPage(uRL);
                    }
                    catch (IOException iOException) {
                        _logger.log(Level.SEVERE, "Invalid URL or can't be getted", hyperlinkEvent);
                    }
                }
            }
        });
        Box box = Box.createVerticalBox();
        JScrollPane jScrollPane2 = new JScrollPane(this._htmlReport);
        jScrollPane2.setMinimumSize(new Dimension(0, 0));
        this._generateReportButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("TimesTenStatistics.generateReport")));
        this._generateReportButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTenStatistics.generateReport")));
        this._generateReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TTStatsReportPanel.this._tableModel.getSelectedCount();
                if (n == 0) {
                    MessageDialog.error((Component)TTStatsReportPanel.this, (Object)Messages.getString("TimesTenStatistics.noSelection"), (String)Messages.getString("TimesTenStatistics.incorrectSelection"), null);
                    return;
                }
                if (n == 1) {
                    MessageDialog.error((Component)TTStatsReportPanel.this, (Object)Messages.getString("TimesTenStatistics.singleSelection"), (String)Messages.getString("TimesTenStatistics.incorrectSelection"), null);
                    return;
                }
                if (n > 2) {
                    MessageDialog.error((Component)TTStatsReportPanel.this, (Object)Messages.getString("TimesTenStatistics.moreThanTwo"), (String)Messages.getString("TimesTenStatistics.incorrectSelection"), null);
                    return;
                }
                if (!TTStatsReportPanel.this.validateSelection()) {
                    MessageDialog.error((Component)TTStatsReportPanel.this, (Object)Messages.getString("TimesTenStatistics.captureLevelsMustMatch"), (String)Messages.getString("TimesTenStatistics.mixedCaptureLevels"), null);
                    return;
                }
                TTStatsReportPanel.this.generateReport();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this._generateReportButton);
        box.add(jPanel);
        box.add(Box.createHorizontalStrut(600));
        box.add(jScrollPane2);
        box.setMinimumSize(new Dimension(0, 0));
        this._splitPane = new JSplitPane(0, jScrollPane, box);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setContinuousLayout(true);
        this._splitPane.setPreferredSize(new Dimension(775, 575));
        this._splitPane.setResizeWeight(0.2);
        this._splitPane.setDividerLocation(0.4);
        this.add((Component)this._splitPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave() {
        block17: {
            try {
                File file = new File(HOME_DIR);
                File file2 = new File(file.getCanonicalPath() + File.separatorChar + this._currentReportPrefixName + ".html");
                JFileChooser jFileChooser = new JFileChooser(){

                    @Override
                    public void approveSelection() {
                        File file = this.getSelectedFile();
                        if (file.exists() && !MessageDialog.confirm((Component)this, (Object)Messages.getString("TimesTenStatistics.overwriteFileQuestion"), (String)Messages.getString(Messages.getString("TimesTen.common.error")), null)) {
                            return;
                        }
                        super.approveSelection();
                    }
                };
                jFileChooser.setSelectedFile(file2);
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Web Page(*htm,*html)";
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        if (file.getName().endsWith("*.html")) {
                            return true;
                        }
                        return file.getName().endsWith("*.htm");
                    }
                });
                if (0 != jFileChooser.showSaveDialog(this)) break block17;
                File file3 = jFileChooser.getSelectedFile();
                AbstractInterruptibleChannel abstractInterruptibleChannel = null;
                AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
                try {
                    abstractInterruptibleChannel = new FileInputStream(this._tmpFile).getChannel();
                    abstractInterruptibleChannel2 = new FileOutputStream(file3).getChannel();
                    ((FileChannel)abstractInterruptibleChannel2).transferFrom((ReadableByteChannel)((Object)abstractInterruptibleChannel), 0L, ((FileChannel)abstractInterruptibleChannel).size());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    _logger.log(Level.SEVERE, "Can't find file", fileNotFoundException);
                    MessageDialog.error(null, (Object)Messages.getString("TimesTenStatistics.fileNotFound"), (String)Messages.getString("TimesTen.common.error"), null);
                }
                catch (IOException iOException) {
                    _logger.log(Level.SEVERE, "Error while saving the report", iOException);
                    MessageDialog.error(null, (Object)Messages.getString("TimesTenStatistics.errorDuringReportSave"), (String)Messages.getString("TimesTen.common.error"), null);
                }
                finally {
                    try {
                        abstractInterruptibleChannel.close();
                        abstractInterruptibleChannel2.close();
                    }
                    catch (IOException iOException) {
                        _logger.log(Level.SEVERE, "Exception while closing streams", iOException);
                    }
                }
            }
            catch (IOException iOException) {
                _logger.log(Level.SEVERE, "Exception while writting to file", iOException);
            }
        }
    }

    protected void initModel(DBObject dBObject) {
        this._conn = dBObject.getConnection();
        String string = this._connections.getConnectionName(this._conn);
        Connections.getDisplayName((String)string);
        this._tableModel = new MyTableModel(this._conn);
    }

    private void discoverCustomMethods(Object object) {
        try {
            if (this._registerIndexTableOutParameterMethod == null) {
                this._registerIndexTableOutParameterMethod = object.getClass().getMethod("registerIndexTableOutParameter", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            if (this._getPlsqlIndexTableMethod == null) {
                this._getPlsqlIndexTableMethod = object.getClass().getMethod("getPlsqlIndexTable", Integer.TYPE);
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "Exception during method discovery", exception);
        }
    }

    public boolean validateSelection() {
        return this._tableModel.validateAndSetSelection();
    }

    public void generateReport() {
        if (this._defaultSnapshotId == null) {
            return;
        }
        final IndeterminateProgressMonitor indeterminateProgressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("TimesTen.common.pleaseWait"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            private URL _url;

            @Override
            protected Void doInBackground() throws Exception {
                indeterminateProgressMonitor.display();
                this._url = TTStatsReportPanel.this.generateReport(TTStatsReportPanel.this._defaultSnapshotId);
                return null;
            }

            @Override
            protected void done() {
                if (this._url != null) {
                    try {
                        TTStatsReportPanel.this._htmlReport.setPage(this._url);
                        indeterminateProgressMonitor.close();
                        if (TTStatsReportPanel.this._htmlReport != null && TTStatsReportPanel.this._htmlReport.getText().length() > 0) {
                            TTStatsReportPanel.this._saveButton.setEnabled(true);
                        } else {
                            TTStatsReportPanel.this._saveButton.setEnabled(false);
                        }
                    }
                    catch (IOException iOException) {
                        _logger.log(Level.SEVERE, "Invalid URL or can't be getted", iOException);
                        indeterminateProgressMonitor.close();
                    }
                }
            }
        };
        swingWorker.execute();
    }

    private String createTmpFilePrefix() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(TTSTATS_SAVE_FILE);
        stringBuilder.append(this._defaultSnapshotId[0]);
        stringBuilder.append('-');
        stringBuilder.append(this._defaultSnapshotId[1]);
        stringBuilder.append('-');
        stringBuilder.append(this._formatter.format(new Date()));
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL generateReport(int[] nArray) {
        Statement statement = null;
        File file = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            this._conn = this._dbObject.getConnection();
            this._connections.lock(this._conn);
            statement = this._conn.prepareCall(_htmlReportSQL);
            this.discoverCustomMethods(statement);
            statement.setInt(1, nArray[0]);
            statement.setInt(2, nArray[1]);
            this._registerIndexTableOutParameterMethod.invoke((Object)statement, 3, 1024, 12, Short.MAX_VALUE);
            statement.execute();
            SQLWarning sQLWarning = statement.getWarnings();
            if (sQLWarning == null) {
                Object object = this._getPlsqlIndexTableMethod.invoke((Object)statement, 3);
                String[] stringArray = (String[])object;
                file = new File(HOME_DIR);
                this._currentReportPrefixName = this.createTmpFilePrefix();
                this._tmpFile = File.createTempFile(this._currentReportPrefixName, ".html", file);
                this._tmpFile.deleteOnExit();
                outputStreamWriter = new FileWriter(this._tmpFile);
                for (String string : stringArray) {
                    outputStreamWriter.write(string);
                    outputStreamWriter.write(LINE_SEPARATOR);
                }
                outputStreamWriter.flush();
                URL uRL = this._tmpFile.toURI().toURL();
                return uRL;
            }
            _logger.log(Level.SEVERE, "Warnings in prepared statement", sQLWarning);
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Couldn't get configuration", sQLException);
            MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(this._conn, statement.toString(), sQLException), (String)Messages.getString("TimesTen.common.error"), null);
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.log(Level.SEVERE, "Couldn't access to discovered method", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.log(Level.SEVERE, "Bad arguments passed to discovered method", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            _logger.log(Level.SEVERE, "Couldn't invoke to discovered method", invocationTargetException);
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "Couldn't write report to device", iOException);
        }
        finally {
            this._connections.unlock(this._conn);
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Statement couldn't be closed ", sQLException);
                }
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    _logger.log(Level.SEVERE, "Stream couldn't be closed ", iOException);
                }
            }
        }
        return null;
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final Class<?>[] _columnClasses = new Class[]{Boolean.class, Integer.class, Timestamp.class, String.class};
        private final String[] _columnNames = new String[]{Messages.getString("TimesTenStatistics.selector"), Messages.getString("TimesTenStatistics.snapshot"), Messages.getString("TimesTenStatistics.timestamp"), Messages.getString("TimesTenStatistics.captureLevel")};
        private List<Object> _dataModel = new ArrayList<Object>(32);

        private MyTableModel(Connection connection) {
            this.initModel(connection);
        }

        private boolean validateAndSetSelection() {
            Object[] objectArray;
            int n;
            int n2 = 0;
            int[] nArray = new int[2];
            String[] stringArray = new String[2];
            for (n = 0; n < this._dataModel.size(); ++n) {
                objectArray = (Object[])this._dataModel.get(n);
                if (!((Boolean)objectArray[0]).booleanValue()) continue;
                if (++n2 > 2) {
                    return false;
                }
                nArray[n2 - 1] = n;
            }
            if (n2 != 2) {
                return false;
            }
            TTStatsReportPanel.this._defaultSnapshotId = new int[2];
            for (n = 0; n < stringArray.length; ++n) {
                objectArray = (Object[])this._dataModel.get(nArray[n]);
                stringArray[n] = (String)objectArray[3];
                TTStatsReportPanel.this._defaultSnapshotId[n] = (Integer)objectArray[1];
            }
            return stringArray[0].equals(stringArray[1]);
        }

        private void setDefaultSnapId() {
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            boolean bl = false;
            if (this._dataModel.size() < 2) {
                return;
            }
            Object[] objectArray = null;
            String string = null;
            for (int i = 0; i < this._dataModel.size() && !bl; ++i) {
                objectArray = (Object[])this._dataModel.get(i);
                if (i == 0) {
                    nArray[0] = (Integer)objectArray[1];
                    nArray2[0] = i;
                    string = (String)objectArray[3];
                    continue;
                }
                if (((String)objectArray[3]).equals(string)) {
                    nArray2[1] = i;
                    nArray[1] = (Integer)objectArray[1];
                    bl = true;
                    continue;
                }
                nArray2[0] = i;
                nArray[0] = (Integer)objectArray[1];
                string = (String)objectArray[3];
            }
            if (bl) {
                TTStatsReportPanel.this._defaultSnapshotId = new int[2];
                TTStatsReportPanel.this._defaultSnapshotId[0] = nArray[0];
                TTStatsReportPanel.this._defaultSnapshotId[1] = nArray[1];
                this.setValueAt(Boolean.TRUE, nArray2[0], 0);
                this.setValueAt(Boolean.TRUE, nArray2[1], 0);
            }
        }

        private void initModel(Connection connection) {
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void doInBackground() throws Exception {
                    Statement statement = null;
                    try {
                        TTStatsReportPanel.this._connections.lock(TTStatsReportPanel.this._conn);
                        statement = TTStatsReportPanel.this._conn.createStatement();
                        ResultSet resultSet = statement.executeQuery(TTStatsReportPanel.GET_SNAPSHOTS_SQL);
                        while (resultSet.next()) {
                            Object[] objectArray = new Object[]{Boolean.FALSE, resultSet.getInt(1), resultSet.getTimestamp(2), resultSet.getString(3)};
                            MyTableModel.this._dataModel.add(objectArray);
                        }
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Couldn't get snapshots", sQLException);
                    }
                    finally {
                        TTStatsReportPanel.this._connections.unlock(TTStatsReportPanel.this._conn);
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {
                                _logger.log(Level.SEVERE, "Statement couldn't be closed ", sQLException);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected void done() {
                    MyTableModel.this.fireTableDataChanged();
                }
            };
            swingWorker.execute();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this._dataModel.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object[] objectArray = (Object[])this._dataModel.get(n);
            return objectArray[n2];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this._columnClasses[n];
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object[] objectArray = (Object[])this._dataModel.get(n);
            objectArray[n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public int getSelectedCount() {
            int n = 0;
            for (int i = 0; i < this._dataModel.size(); ++i) {
                Object[] objectArray = (Object[])this._dataModel.get(i);
                if (!((Boolean)objectArray[0]).booleanValue()) continue;
                ++n;
            }
            return n;
        }
    }
}

