/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;

public class MessageIndeterminateProgressMonitor
extends IndeterminateProgressMonitor {
    protected static Logger LOGGER = Logger.getLogger(MessageIndeterminateProgressMonitor.class.getPackage().getName());
    private ProgressPanel _progressPanel = this.getPanel();
    protected JTextPane _textPane;
    private JScrollPane _scrollPane;

    public MessageIndeterminateProgressMonitor(Component component, String string, String string2, String string3) {
        super(component, string, (Object)string2, string3);
        this.setCancellable(true);
        this.setMillisToPopup(0);
        this.setCloseOnFinish(false);
        this.setModal(true);
        this.setBarVisible(true);
        this.setDetailsTextAreaActivated(true);
    }

    public void updateTextArea(String string) {
        if (this._textPane != null) {
            StyledDocument styledDocument = this._textPane.getStyledDocument();
            try {
                styledDocument.insertString(styledDocument.getLength(), string, null);
                this._textPane.invalidate();
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, "Error on updating detail text area", badLocationException);
            }
        }
    }

    public void setDetailsTextAreaActivated(boolean bl) {
        if (bl) {
            if (this.getDetailContent() == null) {
                this._textPane = new JTextPane();
                this._scrollPane = new JScrollPane(this._textPane);
                this._scrollPane.setPreferredSize(new Dimension(300, 100));
                if (SwingUtilities.isEventDispatchThread()) {
                    this.setDetailContent(this._scrollPane);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MessageIndeterminateProgressMonitor.this.setDetailContent(MessageIndeterminateProgressMonitor.this._scrollPane);
                        }
                    });
                }
            }
        } else {
            this.setDetailContent(null);
            this._textPane = null;
            this._scrollPane = null;
        }
    }

    public void updateMessage(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._progressPanel.setMessage(string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageIndeterminateProgressMonitor.this._progressPanel.setMessage(string);
                }
            });
        }
    }

    public void setEditableTextArea(boolean bl) {
        this._textPane.setEditable(bl);
    }

    protected void setTextAreaPreferredSize(int n, int n2) {
        this._scrollPane.setPreferredSize(new Dimension(n, n2));
    }
}

