/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.AgingInfo;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class LRUConfigPanel
extends DialogBase {
    Double _lo;
    Double _hi;
    int _freq;
    JFormattedTextField _guiLo;
    JFormattedTextField _guiHi;
    JFormattedTextField _guiFreq;

    @Override
    protected void initModel(DBObject dBObject) {
        String[] stringArray = AgingInfo.getLRUThreshold(dBObject);
        this._hi = new Double(stringArray[0]) / 100.0;
        this._lo = new Double(stringArray[1]) / 100.0;
        this._freq = new Integer(stringArray[2]);
    }

    public LRUConfigPanel(DBObject dBObject, String string) {
        super(dBObject, string, "LRUConfigPanel");
    }

    @Override
    protected void initGUI() {
        this.setLayout(this.gridbag);
        DecimalFormat decimalFormat = new DecimalFormat("0.00%");
        this._guiHi = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this._guiHi.setValue(this._hi);
        this._guiLo = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this._guiLo.setValue(this._lo);
        decimalFormat = new DecimalFormat("#0");
        this._guiFreq = new JFormattedTextField(new NumberFormatter(decimalFormat));
        this._guiFreq.setValue(this._freq);
        this.addRow(Messages.getString("LRUConfigPanel.lowUsageThreshold") + ": ", (Component)this._guiLo);
        this.addRow(Messages.getString("LRUConfigPanel.highUsageThreshold") + ": ", (Component)this._guiHi);
        this.addRow(Messages.getString("LRUConfigPanel.updateFrequency") + ": ", (Component)this._guiFreq);
        this._textValues.add(this._guiLo);
        this._textValues.add(this._guiHi);
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public String getSql() {
        this.fixUpValues();
        StringBuffer stringBuffer = new StringBuffer("call ttAgingLRUConfig(");
        stringBuffer.append(this._lo);
        stringBuffer.append(",");
        stringBuffer.append(this._hi);
        stringBuffer.append(",");
        stringBuffer.append(this._freq);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        this.fixUpValues();
        if (this._lo < 0.0 || this._hi < 0.0) {
            stringBuffer.append(Messages.getString("LRUConfigPanel.thresholdValuesCannotBelessThan0"));
        } else if (this._lo >= this._hi) {
            stringBuffer.append(Messages.getString("LRUConfigPanel.lowThresholdMustBeGreaterThanHighThreshold"));
        } else if (this._freq < 1) {
            stringBuffer.append(Messages.getString("LRUConfigPanel.threasholdHasToBeAtLeast1Min"));
        }
        if (stringBuffer.length() == 0) {
            return true;
        }
        MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
        return false;
    }

    private void fixUpValues() {
        this._lo = ((Number)this._guiLo.getValue()).doubleValue();
        this._hi = ((Number)this._guiHi.getValue()).doubleValue();
        this._freq = ((Number)this._guiFreq.getValue()).intValue();
    }
}

