/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.cache.AllFKCols;
import oracle.dbtools.raptor.timesten.dialogs.cache.AllPKCols;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfo;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCFKCol;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCIndexCol;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CheckBoxCellEditor;
import oracle.dbtools.raptor.timesten.dialogs.cache.CheckBoxCellRenderer;
import oracle.dbtools.raptor.timesten.dialogs.cache.CheckBoxHeaderRenderer;
import oracle.dbtools.raptor.timesten.dialogs.cache.TTComboBoxRenderer;
import oracle.dbtools.raptor.timesten.dialogs.cache.TTTypeEditor;
import oracle.dbtools.raptor.timesten.dialogs.cache.TTTypeRenderer;

public class CGCTableColsTableModel
extends AbstractTableModel {
    public static final int COL_NAME = 0;
    public static final int COL_TYPE_ORA = 1;
    public static final int COL_TYPE_TT = 2;
    public static final int COL_INLINE = 3;
    public static final int COL_NULLABLE = 4;
    public static final int COL_CACHED = 5;
    public static final int COL_DEF_VAL = 6;
    public static final int TYPE_RO = 0;
    public static final int TYPE_PA = 1;
    public static final int TYPE_NEITHER = 2;
    public static final int MAXCOLS = 1000;
    private String[] _colNames = new String[]{Messages.getString("CGCTableColsTableModel.columnName"), Messages.getString("CGCTableColsTableModel.dataTypeInOracle"), Messages.getString("CGCTableColsTableModel.dataTypeInTimesTen"), Messages.getString("TimesTen.common.inline"), Messages.getString("CGCTableColsTableModel.allowNullValues"), Messages.getString("CGCTableColsTableModel.cached"), Messages.getString("CGCTableColsTableModel.defaltValue")};
    CGCTableTreeNode _node;
    private CGCColInfo[] _data = null;
    private CGCColInfo[] _rawdata = null;
    private String _oraTblName;
    HashMap _map = null;
    String[] _FKCandidates = null;
    String[] _PKCandidates = null;
    String _errorMsgs = null;
    CGCFKCol[] _FKCols = null;
    String _FKString = null;
    String[] _FKStrings = null;
    AllFKCols _allFKCols = null;
    CGCIndexCol[] _PKCols = null;
    String _PKString = null;
    String[] _PKStrings = null;
    AllPKCols _allPKCols = null;
    CGCIndexCol[] _IndicesNoFloat = null;
    CGCIndexCol[] _Indices = null;
    boolean _PKHash = false;
    boolean _PKHashRows = true;
    int _PKHashN = 4;
    String _where;
    boolean _cascadeDelete;
    int _ropa;
    int _nColCached;
    CGCTableColsTableModel _parentTable = null;
    boolean _keyIdxUseHash = false;
    boolean _keyIdxPage = false;
    int _keyIdxN = -1;
    JTable _table;
    boolean[] headerChecked;
    TTTypeEditor _ttTypeEditor = null;
    TTComboBoxRenderer _ttTypeRenderer;
    CheckBoxCellRenderer _checkBoxRenderer;
    CheckBoxCellEditor _checkBoxEditor;
    CheckBoxHeaderRenderer[] _headerRenderer;

    String getTableName() {
        return this._oraTblName;
    }

    CGCTableTreeNode getNode() {
        return this._node;
    }

    public CGCColInfo getCol(String string) {
        return (CGCColInfo)this._map.get(string);
    }

    private String[] genKeyCandidates() {
        int n = this._data.length;
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (int i = 0; i < n; ++i) {
            CGCColInfo cGCColInfo = this._data[i];
            String string = cGCColInfo.getOraJustTypeName();
            String string2 = cGCColInfo.getOraTypeName();
            if (cGCColInfo.getWarningType() == 2 || string.equals("LONG") || string.equals("LONG RAW") || string.equals("FLOAT")) continue;
            arrayList.add((CallSite)((Object)(cGCColInfo.getColName() + "(" + string2 + ")")));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getFKCandidates() {
        if (this._FKCandidates == null) {
            this._FKCandidates = this.genKeyCandidates();
        }
        return this._FKCandidates;
    }

    public String[] getPKCandidates() {
        if (this._PKCandidates == null) {
            int n;
            CGCIndexCol[] cGCIndexColArray = CGCPanel.theDialog.isVanillaCG() ? this.getIndices() : this.getIndicesNoFloat();
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            for (n = 0; n < cGCIndexColArray.length; ++n) {
                String string = cGCIndexColArray[n].getColName();
                CGCColInfo cGCColInfo = this.getCol(string);
                arrayList.add((CallSite)((Object)(cGCColInfo.getColName() + "(" + cGCColInfo.getOraTypeName() + ")")));
            }
            n = arrayList.size();
            this._PKCandidates = n <= 0 ? null : arrayList.toArray(new String[n]);
        }
        return this._PKCandidates;
    }

    public String getErrorMsgs() {
        if (this._errorMsgs == null) {
            int n = this._rawdata.length;
            if (n == 0) {
                return "";
            }
            int n2 = 3;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (int i = 0; i < n; ++i) {
                CGCColInfo cGCColInfo = this._rawdata[i];
                int n3 = cGCColInfo.getWarningType();
                if (n3 <= 0) continue;
                if (n3 == 1) {
                    arrayList.add(cGCColInfo.getColName());
                }
                if (n3 == 2) {
                    arrayList2.add(cGCColInfo.getColName());
                }
                if (n3 != 3) continue;
                arrayList3.add(cGCColInfo.getColName());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.getString("CGCTableColsTableModel.greyCheckboxesWarning"));
            int n4 = 1;
            if (arrayList.size() > 0) {
                CGCPanel cGCPanel = CGCPanel.theDialog;
                boolean bl = cGCPanel.isAWT();
                int n5 = bl ? 256000 : 0x400000;
                ++n4;
                Object object = String.format(Messages.getString("CGCTableColsTableModel.notCachedColTooLarge"), n5);
                if (bl) {
                    object = (String)object + String.format(Messages.getString("CGCTableColsTableModel.notCachedRepColSizeLimit"), n5);
                }
                this.genTypeMappingMsg(arrayList, (String)object, stringBuffer);
            }
            if (arrayList2.size() > 0) {
                String string = Messages.getString("CGCTableColsTableModel.notCachedUnsupportColTypes");
                this.genTypeMappingMsg(arrayList2, string, stringBuffer);
            }
            if (arrayList3.size() > 0) {
                ++n4;
                String string = Messages.getString("CGCTableColsTableModel.precisionWarning");
                this.genTypeMappingMsg(arrayList3, string, stringBuffer);
            }
            stringBuffer.append("</ul></html>");
            String string = String.format(n4 == 1 ? "<html>%s:<br><br>" : "<html>%s:<ol><li>", Messages.getString("CGCTableColsTableModel.pleaseNote"));
            this._errorMsgs = string + stringBuffer.toString();
        }
        return this._errorMsgs;
    }

    void genTypeMappingMsg(ArrayList<String> arrayList, String string, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append("<br>");
        stringBuffer.append("   ");
        int n = 80;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2;
            int n3;
            if (i != 0) {
                stringBuffer.append(", ");
                n2 += 2;
            }
            if ((n3 = (string2 = arrayList.get(i)).length()) + n2 > n) {
                stringBuffer.append("<br>   ");
                n2 = 3;
            }
            stringBuffer.append("<b>");
            stringBuffer.append(string2);
            stringBuffer.append("</b>");
            n2 += n3;
        }
        stringBuffer.append("\n\n");
    }

    public String getWhere() {
        return this._where;
    }

    public void setWhere(String string) {
        this._where = string;
    }

    public void setCascadeDelete(boolean bl) {
        this._cascadeDelete = bl;
    }

    public boolean getCascadeDelete() {
        return this._cascadeDelete;
    }

    public void setROPA(int n) {
        this._ropa = n;
        CGCPanel.theDialog.cgTypeChanged();
        CGCPanel.theDialog.nudgeTheDialog();
    }

    public int getROPA() {
        return this._ropa;
    }

    void setParentTable(CGCTableColsTableModel cGCTableColsTableModel) {
        this._parentTable = cGCTableColsTableModel;
    }

    void setParentTable(CGCTableTreeNode cGCTableTreeNode) {
        this.setParentTable(cGCTableTreeNode.getTableModel());
    }

    CGCTableColsTableModel getParentTable() {
        return this._parentTable;
    }

    public String[] getFKStrings() {
        if (this._FKStrings == null) {
            Collection collection = this._allFKCols.values();
            this._FKStrings = new String[collection.size()];
            int n = 0;
            for (CGCFKCol[] cGCFKColArray : collection) {
                this._FKStrings[n] = CGCTableColsTableModel.genFKString(cGCFKColArray);
                ++n;
            }
        }
        return this._FKStrings;
    }

    public String getFKString() {
        return this._FKString;
    }

    public void updateFKString(CGCFKCol[] cGCFKColArray) {
        this._FKString = CGCTableColsTableModel.genFKString(cGCFKColArray);
        this._FKStrings = null;
    }

    static String genFKString(CGCFKCol[] cGCFKColArray) {
        CGCFKCol cGCFKCol = cGCFKColArray[0];
        String string = " --->";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = cGCFKCol.getPOwnerName();
        if (!string2.equals(CGCPanel.theDialog.getUserName())) {
            stringBuffer.append(cGCFKCol.getPOwnerName());
            stringBuffer.append(".");
        }
        stringBuffer.append(cGCFKCol.getPTableName());
        stringBuffer.append("(");
        stringBuffer2.append(cGCFKCol.getTableName());
        stringBuffer2.append("(");
        for (int i = 0; i < cGCFKColArray.length; ++i) {
            CGCFKCol cGCFKCol2 = cGCFKColArray[i];
            if (i > 0) {
                stringBuffer.append(",");
                stringBuffer2.append(",");
            }
            stringBuffer.append(cGCFKCol2.getPColName());
            stringBuffer2.append(cGCFKCol2.getColName());
        }
        stringBuffer.append(")");
        stringBuffer2.append(")");
        stringBuffer2.append(string);
        stringBuffer2.append(stringBuffer.toString());
        return stringBuffer2.toString();
    }

    void handleMenuChangeFK(String string) {
        this._FKString = string;
        this._FKCols = this._allFKCols.get(string);
    }

    public CGCFKCol[] getFKCols() {
        return this._FKCols;
    }

    public void setFKCols(CGCFKCol[] cGCFKColArray) {
        if (cGCFKColArray == null) {
            return;
        }
        this._FKCols = cGCFKColArray;
        this._allFKCols.clear();
        this._allFKCols.add(cGCFKColArray);
        this.updateFKString(cGCFKColArray);
    }

    public void addFK(String[] stringArray) {
        int n = stringArray.length;
        CGCIndexCol[] cGCIndexColArray = this._parentTable.getPKCols();
        int n2 = cGCIndexColArray.length;
        if (n <= 0 || n != n2) {
            return;
        }
        CGCFKCol[] cGCFKColArray = new CGCFKCol[n];
        String string = this._parentTable.getTableName();
        int n3 = string.indexOf(".");
        if (n3 > 0) {
            string = string.substring(n3 + 1, string.length());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            n3 = stringArray[i].indexOf("(");
            String string2 = stringArray[i].substring(0, n3);
            cGCFKColArray[i] = new CGCFKCol(cGCIndexColArray[i], string, this._node.getRealOwnerName(), this._node.getRealTableName(), string2);
        }
        this._allFKCols.add(cGCFKColArray);
        this._FKCols = cGCFKColArray;
        this.updateFKString(cGCFKColArray);
    }

    public String[] getPKStrings() {
        if (this._PKStrings == null) {
            Collection collection = this._allPKCols.values();
            this._PKStrings = new String[collection.size()];
            int n = 0;
            for (CGCIndexCol[] cGCIndexColArray : collection) {
                this._PKStrings[n] = CGCTableColsTableModel.genPKString(cGCIndexColArray);
                ++n;
            }
        }
        return this._PKStrings;
    }

    public String getPKString() {
        return this._PKString;
    }

    public void updatePKString(CGCIndexCol[] cGCIndexColArray) {
        this._PKString = CGCTableColsTableModel.genPKString(cGCIndexColArray);
        this._PKStrings = null;
    }

    public static String genPKString(CGCIndexCol[] cGCIndexColArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cGCIndexColArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(cGCIndexColArray[i].getColName());
        }
        return stringBuffer.toString();
    }

    void handleMenuChangePK(String string) {
        System.out.println("handleMenuChangePK(" + string + ")");
        this._PKString = string;
        this._PKCols = this._allPKCols.get(string);
    }

    public CGCIndexCol[] getPKCols() {
        return this._PKCols;
    }

    public void setPKCols(CGCIndexCol[] cGCIndexColArray) {
        if (cGCIndexColArray == null) {
            return;
        }
        this._PKCols = cGCIndexColArray;
        this._allPKCols.clear();
        this._allPKCols.add(cGCIndexColArray);
        this.updatePKString(cGCIndexColArray);
    }

    public void addPK(String[] stringArray) {
        int n = stringArray.length;
        CGCIndexCol[] cGCIndexColArray = new CGCIndexCol[n];
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = stringArray[i].indexOf("(");
            String string = stringArray[i].substring(0, n2);
            cGCIndexColArray[i] = new CGCIndexCol(i, this._node.getRealOwnerName(), string);
        }
        this._allPKCols.add(cGCIndexColArray);
        this._PKCols = cGCIndexColArray;
        this.updatePKString(cGCIndexColArray);
    }

    public CGCIndexCol[] getIndices() {
        if (this._Indices == null) {
            this._Indices = this._node.getIndexWithFloat();
        }
        return this._Indices;
    }

    public CGCIndexCol[] getIndicesNoFloat() {
        if (this._IndicesNoFloat == null) {
            this._IndicesNoFloat = this._node.getIndexWithoutFloat();
        }
        return this._IndicesNoFloat;
    }

    public boolean getKeyIdxUseHash() {
        return this._keyIdxUseHash;
    }

    public void setKeyIdxUseHash(boolean bl) {
        this._keyIdxUseHash = bl;
    }

    public boolean getKeyIdxPage() {
        return this._keyIdxPage;
    }

    public void setKeyIdxPage(boolean bl) {
        this._keyIdxPage = bl;
    }

    public int getKeyIdxN() {
        return this._keyIdxN;
    }

    public void setKeyIdxN(int n) {
        this._keyIdxN = n;
    }

    boolean showDefValuesCol() {
        if (CGCPanel.theDialog.isRO()) {
            return false;
        }
        return CGCPanel.theDialog.getCGType() != 6 || this._ropa != 0;
    }

    public CGCTableColsTableModel(CGCTableTreeNode cGCTableTreeNode) {
        this._node = cGCTableTreeNode;
        cGCTableTreeNode.setTableModel(this);
        this._oraTblName = cGCTableTreeNode.getRealName();
        this.startOver();
        this._where = "";
        this._ropa = 2;
        this._allFKCols = new AllFKCols();
        CGCFKCol[] cGCFKColArray = cGCTableTreeNode.getFKCols();
        if (cGCFKColArray != null) {
            this._cascadeDelete = cGCFKColArray[0].getCascadeDelete();
            for (int i = 0; i < cGCFKColArray.length; ++i) {
                String string = cGCFKColArray[i].getColName();
                cGCTableTreeNode.getCol(string).setIsFK();
            }
            this._allFKCols.add(cGCFKColArray);
        }
        this._allPKCols = new AllPKCols();
        CGCIndexCol[] cGCIndexColArray = cGCTableTreeNode.getPKCols();
        if (cGCIndexColArray != null) {
            for (int i = 0; i < cGCIndexColArray.length; ++i) {
                String string = cGCIndexColArray[i].getColName();
                cGCTableTreeNode.getCol(string).setIsPK();
            }
            this._allPKCols.add(cGCIndexColArray);
        }
    }

    public void startOver() {
        CGCColInfo cGCColInfo;
        int n;
        this._rawdata = this._node.getCols();
        if (this._rawdata == null) {
            return;
        }
        CGCColInfo[] cGCColInfoArray = this._rawdata;
        this._map = new HashMap();
        ArrayList<CGCColInfo> arrayList = new ArrayList<CGCColInfo>();
        for (n = 0; n < cGCColInfoArray.length; ++n) {
            cGCColInfo = cGCColInfoArray[n];
            this._map.put(cGCColInfo.getColName(), cGCColInfo);
            if (cGCColInfo.getWarningType() == 2) continue;
            arrayList.add(cGCColInfo);
        }
        this._nColCached = arrayList.size();
        this._data = arrayList.toArray(new CGCColInfo[this._nColCached]);
        if (this._nColCached > 1000) {
            this._nColCached = 1000;
        }
        for (n = 1000; n < this._data.length; ++n) {
            cGCColInfo = this._data[n];
            cGCColInfo.setCached(false);
        }
    }

    private CGCColInfo getColRaw(int n) {
        return this._rawdata[n];
    }

    public CGCColInfo getCol(int n) {
        return this._data[n];
    }

    public String[] getTTTypeNames(int n) {
        return this.getCol(n).getTTTypes();
    }

    public String getTTTypeName(int n) {
        String string = this.getCol(n).getTTTypeName();
        return string;
    }

    public String getTTTypeNameDefault(int n) {
        return this.getCol(n).getTTTypeNameDefault();
    }

    public String getOraTypeName(int n) {
        return this.getCol(n).getOraTypeName();
    }

    @Override
    public int getColumnCount() {
        int n = this._colNames.length;
        return this.showDefValuesCol() ? n : n - 1;
    }

    @Override
    public int getRowCount() {
        return this._data.length;
    }

    @Override
    public String getColumnName(int n) {
        return this._colNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        CGCColInfo cGCColInfo = this.getCol(n);
        switch (n2) {
            case 5: {
                return cGCColInfo.getCached();
            }
            case 0: {
                return cGCColInfo.getColName();
            }
            case 1: {
                return cGCColInfo.getOraTypeName();
            }
            case 2: {
                return cGCColInfo.getTTTypeName();
            }
            case 3: {
                return new Boolean(cGCColInfo.getInline());
            }
            case 4: {
                return new Boolean(cGCColInfo.getNullable());
            }
            case 6: {
                return this.showDefValuesCol() ? cGCColInfo.getDefValue() : null;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        CGCColInfo cGCColInfo = this.getCol(n);
        boolean bl = true;
        switch (n2) {
            case 5: {
                boolean bl2 = (Boolean)object;
                boolean bl3 = (Boolean)this.getValueAt(n, n2);
                if (bl2 == bl3) {
                    return;
                }
                int n3 = this._nColCached + (bl2 ? 1 : -1);
                if (n3 <= 1000) {
                    this._nColCached = n3;
                    cGCColInfo.setCached((Boolean)object);
                } else {
                    bl = false;
                }
                CGCPanel cGCPanel = CGCPanel.theDialog;
                if (cGCPanel.getCurrentSelection() != cGCPanel.getRootTable()) break;
                cGCPanel.fixMenuAgingTB();
                break;
            }
            case 2: {
                cGCColInfo.setTTTypeName((String)object);
                break;
            }
            case 3: {
                cGCColInfo.setInline((Boolean)object);
                break;
            }
            case 4: {
                cGCColInfo.setNullable((Boolean)object);
                break;
            }
            case 6: {
                cGCColInfo.setDefValue((String)object);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (n2 == 5 || n2 == 4) {
            String string = DialogBase.getCaller();
            TableColumn tableColumn = this._table.getColumnModel().getColumn(n2);
            CheckBoxHeaderRenderer checkBoxHeaderRenderer = (CheckBoxHeaderRenderer)tableColumn.getHeaderRenderer();
            if (string.indexOf("CheckBoxHeader") > 0 && ((Boolean)object).booleanValue()) {
                checkBoxHeaderRenderer.setMarching(true);
            } else {
                checkBoxHeaderRenderer.setMarching(false);
            }
        }
        if (bl) {
            CGCPanel.theDialog.setThingsChanged();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        CGCColInfo cGCColInfo = this.getCol(n);
        switch (n2) {
            case 2: {
                return cGCColInfo.getTTTypes().length > 1;
            }
            case 5: {
                boolean bl = true;
                if (cGCColInfo.getMustCache()) {
                    bl = false;
                }
                if (!cGCColInfo.getCacheable()) {
                    bl = false;
                }
                return bl;
            }
            case 6: {
                return true;
            }
            case 3: {
                return cGCColInfo.getInlinable();
            }
            case 4: {
                return !cGCColInfo.getMustNotNull();
            }
        }
        return false;
    }

    public void setEditorsRenders(JTable jTable) {
        this._table = jTable;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(2);
        if (this._ttTypeEditor == null) {
            this._ttTypeEditor = new TTTypeEditor(this);
            this._ttTypeRenderer = new TTTypeRenderer(jTable);
            this._checkBoxRenderer = new CheckBoxCellRenderer(this);
            this._checkBoxEditor = new CheckBoxCellEditor(this);
            this._headerRenderer = new CheckBoxHeaderRenderer[2];
            this._headerRenderer[0] = new CheckBoxHeaderRenderer(jTable, 5);
            this._headerRenderer[1] = new CheckBoxHeaderRenderer(jTable, 4);
        }
        tableColumn.setCellEditor(this._ttTypeEditor);
        tableColumn.setCellRenderer(this._ttTypeRenderer);
        tableColumn = jTable.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(this._checkBoxRenderer);
        tableColumn.setCellEditor(this._checkBoxEditor);
        tableColumn.setHeaderRenderer(this._headerRenderer[0]);
        tableColumn = jTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(this._checkBoxRenderer);
        tableColumn.setCellEditor(this._checkBoxEditor);
        tableColumn = jTable.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(this._checkBoxRenderer);
        tableColumn.setCellEditor(this._checkBoxEditor);
        tableColumn.setHeaderRenderer(this._headerRenderer[1]);
        try {
            tableColumn = jTable.getColumnModel().getColumn(6);
            List<JComponent> list = CGCPanel.theDialog.getTextValues();
            JComponent jComponent = (JComponent)tableColumn.getCellEditor().getTableCellEditorComponent(this._table, "", true, 1, 6);
            if (!list.contains(jComponent)) {
                list.add(jComponent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void qq(String string, StringBuffer stringBuffer) {
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
    }

    public void getSql(StringBuffer stringBuffer) {
        String string;
        String string2;
        Object object;
        Object object2;
        stringBuffer.append(" (\n");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            object2 = this.getCol(i);
            if (!((CGCColInfo)object2).getCached().booleanValue()) continue;
            n = Math.max(n, ((CGCColInfo)object2).getColName().length());
            n2 = Math.max(n2, ((CGCColInfo)object2).getTTTypeName().length());
            if (!this.showDefValuesCol()) continue;
            try {
                n3 = Math.max(n3, 9 + ((CGCColInfo)object2).getDefValue().length());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string3 = "%-" + (n += 2) + "s";
        object2 = "%-" + n2 + "s";
        String string4 = "%-" + n3 + "s";
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string5;
            object = this.getCol(i);
            if (!((CGCColInfo)object).getCached().booleanValue()) continue;
            stringBuffer.append("    ");
            stringBuffer.append(String.format(string3, "\"" + ((CGCColInfo)object).getColName() + "\""));
            stringBuffer.append(" ");
            stringBuffer.append(String.format((String)object2, ((CGCColInfo)object).getTTTypeName()));
            if (((CGCColInfo)object).getInline().booleanValue()) {
                stringBuffer.append(" INLINE");
            }
            if (!((CGCColInfo)object).getNullable().booleanValue()) {
                stringBuffer.append(" NOT NULL");
            }
            if (this.showDefValuesCol() && (string5 = ((CGCColInfo)object).getDefValue()) != null && string5.length() > 0) {
                stringBuffer.append(String.format(string4, " DEFAULT " + string5));
            }
            stringBuffer.append(",\n");
        }
        stringBuffer.append("    PRIMARY KEY");
        if (this._PKCols != null) {
            object = new StringBuffer();
            ((StringBuffer)object).append("(");
            for (int i = 0; i < this._PKCols.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append(",");
                }
                this.qq(this._PKCols[i].getColName(), (StringBuffer)object);
            }
            ((StringBuffer)object).append(")");
            string2 = ((StringBuffer)object).toString();
        } else {
            string2 = " -- missing primary key";
        }
        stringBuffer.append(string2);
        if (this._FKCols != null) {
            stringBuffer.append(",\n    FOREIGN KEY(");
            for (int i = 0; i < this._FKCols.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                this.qq(this._FKCols[i].getColName(), stringBuffer);
            }
            stringBuffer.append(")\n      REFERENCES ");
            object = this._FKCols[0];
            this.qq(((CGCFKCol)object).getPOwnerName(), stringBuffer);
            stringBuffer.append(".");
            this.qq(((CGCFKCol)object).getPTableName(), stringBuffer);
            stringBuffer.append("(");
            for (int i = 0; i < this._FKCols.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                this.qq(this._FKCols[i].getPColName(), stringBuffer);
            }
            stringBuffer.append(")");
            if (this.getCascadeDelete()) {
                stringBuffer.append("\n      ON DELETE CASCADE");
            }
        }
        int n4 = CGCPanel.theDialog.getCGType();
        int n5 = this.getROPA();
        if (n4 == 4 || n5 == 0) {
            stringBuffer.append(", READONLY");
        } else if (n4 == 5 || n5 == 1) {
            stringBuffer.append(", PROPAGATE");
        }
        stringBuffer.append("\n  )");
        if (this.getKeyIdxUseHash()) {
            stringBuffer.append("\n  UNIQUE HASH ON ");
            stringBuffer.append(string2);
            int n6 = this.getKeyIdxN();
            if (!this.getKeyIdxPage()) {
                n6 = n6 / 256 + 1;
            }
            if (n6 > 0) {
                stringBuffer.append(" PAGES = ");
                stringBuffer.append(n6);
            }
        }
        if ((string = this.getWhere()).length() > 0) {
            stringBuffer.append("\n  WHERE (");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
    }

    public String toString() {
        return this._oraTblName;
    }

    private void printDebugData() {
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
            }
        }
    }
}

