/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.timesten.Feedback;
import oracle.dbtools.raptor.timesten.FeedbackHandler;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTJPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCColInfoQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCIndexesWithFloatsQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCIndexesWithoutFloatsQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsJTable;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableColsTableModel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTreeNodeSelectionListener;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public final class CGCTableColsPanel
extends DialogBase
implements CGCTreeNodeSelectionListener,
FeedbackHandler {
    CGCTableColsJTable _table;
    JLabel _errorMsgs;
    CGCColInfoQuery _qColInfo = null;
    CGCIndexesWithFloatsQuery _qIdxFloats = null;
    CGCIndexesWithoutFloatsQuery _qIdx = null;
    Hashtable _nodeSeen;

    public CGCTableColsPanel(DBObject dBObject, String string, List<JComponent> list) {
        super(dBObject, string, "CGCTableColsPanel", list);
        CGCTableColsPanel.LOUD("1 > right > left");
    }

    public void cgTypeChanged() {
        try {
            CGCTableColsTableModel cGCTableColsTableModel = (CGCTableColsTableModel)this._table.getModel();
            cGCTableColsTableModel.fireTableStructureChanged();
            cGCTableColsTableModel.setEditorsRenders(this._table);
            this.initColumnWidth();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initColumnWidth() {
        this._table.initColumnWidth();
        TableColumn tableColumn = this._table.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + 12);
    }

    @Override
    protected void initGUI() {
        this._nodeSeen = new Hashtable();
        TTJPanel tTJPanel = new TTJPanel();
        this._table = new CGCTableColsJTable(new DefaultTableModel(0, 0));
        JScrollPane jScrollPane = new JScrollPane(this._table);
        this._errorMsgs = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane(this._errorMsgs);
        TTJPanel tTJPanel2 = new TTJPanel(Messages.getString("CGCTableColsPanel.notes"));
        tTJPanel2.addFull(jScrollPane2);
        JSplitPane jSplitPane = new JSplitPane(0, true, jScrollPane, tTJPanel2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(350);
        jSplitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new BasicSplitPaneDivider(this){

                    @Override
                    public void setBorder(Border border) {
                        super.setBorder(BorderFactory.createRaisedBevelBorder());
                    }
                };
            }
        });
        tTJPanel.addFull(jSplitPane);
        this.addFull(tTJPanel);
    }

    private CGCTableColsTableModel initTableModel(CGCTableTreeNode cGCTableTreeNode) {
        CGCPanel cGCPanel = CGCPanel.theDialog;
        CGCTableColsPanel.LOUD("CGCColInfoQuery executeQuery");
        new Feedback(this, "init_qColInfo()");
        this._qColInfo.executeQuery(cGCTableTreeNode);
        CGCTableColsPanel.LOUD("..done CGCColInfoQuery executeQuery");
        CGCTableColsPanel.LOUD("new CGCTableColsTableModel");
        CGCTableColsTableModel cGCTableColsTableModel = new CGCTableColsTableModel(cGCTableTreeNode);
        CGCTableColsPanel.LOUD("..done new CGCTableColsTableModel");
        CGCTableColsPanel.LOUD("isVanillaCG");
        boolean bl = cGCPanel.isVanillaCG();
        CGCTableColsPanel.LOUD("..done isVanillaCG");
        if (bl) {
            CGCTableColsPanel.LOUD("CGCIndexesWithFloatsQuery executeQuery");
            new Feedback(this, "init_qIdxFloats()");
            this._qIdxFloats.executeQuery(cGCTableTreeNode);
            CGCTableColsPanel.LOUD("..done CGCIndexesWithFloatsQuery executeQuery");
        } else {
            CGCTableColsPanel.LOUD("CGCIndexesWithoutFloatsQuery executeQuery");
            new Feedback(this, "init_qIdx()");
            this._qIdx.executeQuery(cGCTableTreeNode);
            CGCTableColsPanel.LOUD("..done CGCIndexesWithoutFloatsQuery executeQuery");
        }
        this._nodeSeen.put(cGCTableTreeNode, cGCTableColsTableModel);
        return cGCTableColsTableModel;
    }

    public CGCTableColsTableModel getTableModel(CGCTableTreeNode cGCTableTreeNode) {
        CGCTableColsPanel.LOUD("looking up _nodeSeen");
        CGCTableColsTableModel cGCTableColsTableModel = (CGCTableColsTableModel)this._nodeSeen.get(cGCTableTreeNode);
        CGCTableColsPanel.LOUD("..done looking up _nodeSeen");
        if (cGCTableColsTableModel == null) {
            cGCTableColsTableModel = this.initTableModel(cGCTableTreeNode);
        }
        return cGCTableColsTableModel;
    }

    private synchronized void init_qIdx() {
        if (this._qIdx != null) {
            return;
        }
        this._qIdx = (CGCIndexesWithoutFloatsQuery)CGCPanel.RegistryGet(this._dbObject, "_qIdx");
        if (this._qIdx != null) {
            return;
        }
        CGCTableColsPanel.LOUD("    CGCIndexesWithoutFloatsQuery");
        this._qIdx = new CGCIndexesWithoutFloatsQuery(this._dbObject);
        CGCPanel.RegistryPut(this._dbObject, "_qIdx", this._qIdx);
        this._qIdx.executeQuery(new CGCTableTreeNode("foo.bar", false));
        CGCTableColsPanel.LOUD("    ...done CGCIndexesWithoutFloatsQuery");
    }

    private synchronized void init_qColInfo() {
        if (this._qColInfo != null) {
            return;
        }
        CGCTableColsPanel.LOUD("    CGCColInfoQuery RegistryGet");
        this._qColInfo = (CGCColInfoQuery)CGCPanel.RegistryGet(this._dbObject, "_qColInfo");
        CGCTableColsPanel.LOUD("    ...CGCColInfoQuery RegistryGet");
        if (this._qColInfo != null) {
            return;
        }
        CGCTableColsPanel.LOUD("    CGCColInfoQuery");
        this._qColInfo = new CGCColInfoQuery(this._dbObject);
        CGCTableColsPanel.LOUD("    CGCColInfoQuery created");
        this._qColInfo.executeQuery(new CGCTableTreeNode("foo.bar", false));
        CGCTableColsPanel.LOUD("    ...done CGCColInfoQuery");
    }

    private synchronized void init_qIdxFloats() {
        if (this._qIdxFloats != null) {
            return;
        }
        this._qIdxFloats = (CGCIndexesWithFloatsQuery)CGCPanel.RegistryGet(this._dbObject, "_qIdxFloats");
        if (this._qIdxFloats != null) {
            return;
        }
        CGCTableColsPanel.LOUD("    CGCIndexesWithFloatsQuery");
        this._qIdxFloats = new CGCIndexesWithFloatsQuery(this._dbObject);
        this._qIdxFloats.executeQuery(new CGCTableTreeNode("foo.bar", false));
        CGCTableColsPanel.LOUD("    ...done CGCIndexesWithFloatsQuery");
    }

    @Override
    public void idleInit() {
        CGCTableColsPanel.LOUD("CGCTableColsPanel idleInit ");
        try {
            this.checkIsCancelled();
            CGCTableColsPanel.LOUD("   init_qIdx");
            this.init_qIdx();
            CGCTableColsPanel.LOUD("   ...init_qIdx done");
            this.checkIsCancelled();
            CGCTableColsPanel.LOUD("   init_qColInfo");
            this.init_qColInfo();
            CGCTableColsPanel.LOUD("   ...init_qColInfo done");
            this.checkIsCancelled();
            CGCTableColsPanel.LOUD("   init_qIdxFloats");
            this.init_qIdxFloats();
            CGCTableColsPanel.LOUD("   ...init_qIdxFloats done");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CGCTableColsPanel.LOUD("...CGCTableColsPanel idleInit done");
    }

    public void startOver() {
        Enumeration enumeration = this._nodeSeen.elements();
        while (enumeration.hasMoreElements()) {
            CGCTableColsTableModel cGCTableColsTableModel = (CGCTableColsTableModel)enumeration.nextElement();
            cGCTableColsTableModel.startOver();
        }
        this._table.setModel(new DefaultTableModel(0, 0));
    }

    @Override
    public boolean validateValues() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (stringBuffer.length() > 0) {
            MessageDialog.error((Component)this, (Object)stringBuffer.toString(), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return true;
    }

    @Override
    public void nodeSelected(CGCTableTreeNode cGCTableTreeNode) {
        if (cGCTableTreeNode == null) {
            this._errorMsgs.setText("");
            return;
        }
        CGCTableColsPanel.LOUD("CGCTableColsPanel CGCTreeNodeSelectionListener");
        CGCTableColsPanel.LOUD("getTableModel");
        CGCTableColsTableModel cGCTableColsTableModel = this.getTableModel(cGCTableTreeNode);
        CGCTableColsPanel.LOUD("..done getTableModel");
        CGCTableColsPanel.LOUD("set table model");
        this._table.setModel(cGCTableColsTableModel);
        CGCTableColsPanel.LOUD("..done set table model");
        CGCTableColsPanel.LOUD("setEditorsRenders");
        cGCTableColsTableModel.setEditorsRenders(this._table);
        CGCTableColsPanel.LOUD("..done setEditorsRenders");
        this.initColumnWidth();
        CGCTableColsPanel.LOUD("..done CGCTableColsPanel CGCTreeNodeSelectionListener");
        this._errorMsgs.setText(cGCTableColsTableModel.getErrorMsgs());
    }

    @Override
    public void doWork(Object object) {
        String string = (String)object;
        if (string.equals("init_qColInfo()")) {
            this.init_qColInfo();
        } else if (string.equals("init_qIdxFloats()")) {
            this.init_qIdxFloats();
        } else if (string.equals("init_qIdx()")) {
            this.init_qIdx();
        }
    }
}

