/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.actions;

import java.awt.Component;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.actions.Utils;
import oracle.dbtools.raptor.timesten.dialogs.profile.TTDropProfileDialog;
import oracle.dbtools.raptor.timesten.grid.Common;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;

public class TTDropProfile
extends AbstractMenuAction {
    public void launch() {
        TTDropProfileDialog tTDropProfileDialog = new TTDropProfileDialog();
        try {
            Connection connection = this.getDBObject().getConnection();
            String string = this.getDBObject().getObjectName();
            boolean bl = Utils.isAdminPriv(connection, ((Object)((Object)this)).getClass().getClassLoader());
            if (bl) {
                if (string.equalsIgnoreCase("DEFAULT") || string.equalsIgnoreCase("SYSTEM")) {
                    Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TTDropProfile.cannotDrop"), string));
                    return;
                }
                DBObject dBObject = this.getDBObject();
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)this.getObjectAction(), (DBObject)dBObject);
                this.setBlockOACRefresh(true);
                tTDropProfileDialog.showDialog(connection, string, objectActionPostProcess);
            } else {
                Common.displayErrorMsg((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TTProfile.lackAdminPrivilege"), connection.getMetaData().getUserName()));
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void setArgs(String string) {
    }
}

