/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.connection.TableStatistics;
import oracle.javatools.dialogs.BaseMessageDialog;

public class OutdatedTableStatsAlertDialog
extends BaseMessageDialog
implements ActionListener {
    private JTable _table;
    private TableStatistics.StatsTableInfo _lastUpdated;
    private TableStatistics.StatsTableInfo _leastUpdated;
    private int tablesWithStats;
    private int tablesWithNoStats;
    private JCheckBox _skipShow;
    private static final String TITLE = Messages.getString("IndexAdvisor.tableStatisticsTitle");
    private static final String MESSAGE = Messages.getString("IndexAvdisor.statisticsMessage");
    private static final String[] TABLE_HEADER = new String[]{Messages.getString("IndexAdvisor.property"), Messages.getString("IndexAdvisor.value")};
    private static final String[] DATA = new String[]{Messages.getString("IndexAdvisor.numberOfTablesWithNoStatistics"), Messages.getString("IndexAdvisor.leastRecentlyUpdatedTable"), Messages.getString("IndexAdvisor.leastRecentUpdateAt"), Messages.getString("IndexAdvisor.mostRecentlyUpdatedTable"), Messages.getString("IndexAdvisor.mostRecentUpdateAt")};

    public OutdatedTableStatsAlertDialog(Dialog dialog, int n, int n2, TableStatistics.StatsTableInfo statsTableInfo, TableStatistics.StatsTableInfo statsTableInfo2) {
        super(dialog, TITLE, 3);
        this.tablesWithStats = n;
        this.tablesWithNoStats = n2;
        this._lastUpdated = statsTableInfo;
        this._leastUpdated = statsTableInfo2;
        this.setupmMnemonics();
        this.initGUI();
    }

    public OutdatedTableStatsAlertDialog(Frame frame, int n, int n2, TableStatistics.StatsTableInfo statsTableInfo, TableStatistics.StatsTableInfo statsTableInfo2) {
        super(frame, TITLE, 3);
        this.tablesWithStats = n;
        this.tablesWithNoStats = n2;
        this._lastUpdated = statsTableInfo;
        this._leastUpdated = statsTableInfo2;
        this.setupmMnemonics();
        this.initGUI();
    }

    private void initGUI() {
        this.setMessageType(2);
        this.setButtonMask(3);
        this.setMessageText(MESSAGE);
        this._table = new JTable(new OutdateStatsTableModel());
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setPreferredSize(new Dimension(400, 103));
        this.addMessageComponent(jScrollPane);
    }

    private void setupmMnemonics() {
        this.setCancelButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.cancelButton")));
        this.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.cancelButton")));
        this.setOKButtonText(StringUtils.stripMnemonic((String)Messages.getString("TimesTen.common.OKButton")));
        this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("TimesTen.common.OKButton")));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("button " + actionEvent.getActionCommand());
    }

    private class OutdateStatsTableModel
    extends AbstractTableModel {
        private OutdateStatsTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return TABLE_HEADER[n];
        }

        @Override
        public int getRowCount() {
            return DATA.length;
        }

        @Override
        public int getColumnCount() {
            return TABLE_HEADER.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return DATA[n];
            }
            switch (n) {
                case 0: {
                    return OutdatedTableStatsAlertDialog.this.tablesWithNoStats;
                }
                case 1: {
                    if (OutdatedTableStatsAlertDialog.this._lastUpdated.owner == null && OutdatedTableStatsAlertDialog.this._lastUpdated.name == null) {
                        return "";
                    }
                    return OutdatedTableStatsAlertDialog.this._lastUpdated.owner + "." + OutdatedTableStatsAlertDialog.this._lastUpdated.name;
                }
                case 2: {
                    return OutdatedTableStatsAlertDialog.this._lastUpdated.updatedOn;
                }
                case 3: {
                    if (OutdatedTableStatsAlertDialog.this._leastUpdated.owner == null && OutdatedTableStatsAlertDialog.this._leastUpdated.name == null) {
                        return "";
                    }
                    return OutdatedTableStatsAlertDialog.this._leastUpdated.owner + "." + OutdatedTableStatsAlertDialog.this._leastUpdated.name;
                }
                case 4: {
                    return OutdatedTableStatsAlertDialog.this._leastUpdated.updatedOn;
                }
            }
            return null;
        }
    }
}

