/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.javatools.db.DBException;

public class TTSQLExceptionListener
implements SQLExceptionListener {
    private final Connections theConnections = Connections.getInstance();
    private Logger theLogger = Logger.getLogger(TTSQLExceptionListener.class.getPackage().getName());
    private static final int TT_ERR_FAILOVERINVALIDATION = 47137;
    private static final String CONNECTION_NOT_OPEN = "08003";
    private static final String CONNECTION_NOT_ACTIVE = "Connection\\s+not\\s+active";
    private static final String ROLLBACK_REQUIRED_SQLSTATE = "08006";
    private static final int ROLLBACK_REQUIRED_ERROR_CODE = 30105;
    private static final String FAILOVER_SQLSTATE = "S1000";
    private static TTSQLExceptionListener theInstance;

    private TTSQLExceptionListener() {
    }

    public static synchronized TTSQLExceptionListener getTheInstance() {
        if (theInstance == null) {
            theInstance = new TTSQLExceptionListener();
        }
        return theInstance;
    }

    public boolean handleSQLError(Connection connection, SQLException sQLException) {
        String string = this.theConnections.getConnectionName(connection);
        return this.handleSQLError(string, sQLException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleSQLError(String string, SQLException sQLException) {
        Connection connection;
        block6: {
            connection = this.theConnections.getConnection(string);
            if (this.theConnections.isTimesTen(connection)) break block6;
            boolean bl = false;
            return bl;
        }
        try {
            this.theLogger.log(Level.WARNING, "Handle TimesTen connection failure, state: " + sQLException.getSQLState() + " error: " + sQLException.getErrorCode() + " message: " + sQLException.getLocalizedMessage(), sQLException);
            boolean bl = this.isConnectionAliveHelper(sQLException, connection);
            if (!bl) {
                this.theLogger.log(Level.WARNING, "Connection is not usable, recovery in progress ...");
                this.theConnections.closeConnection(string, true);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (DBException dBException) {
            this.theLogger.log(Level.WARNING, "Cannot get Connection for " + string + ", " + dBException.getAllMessages());
        }
        return false;
    }

    public boolean isConnectionAliveHelper(SQLException sQLException, Connection connection) {
        boolean bl = true;
        if (this.isRollbackRequiredOnFailover(sQLException)) {
            this.theLogger.log(Level.WARNING, "Rollback required, rolling back.");
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                this.theLogger.log(Level.SEVERE, "Rollback required, but rolling back failed unexpectedly", sQLException);
                return false;
            }
            return true;
        }
        if (sQLException.getSQLState().equalsIgnoreCase(CONNECTION_NOT_OPEN)) {
            this.theLogger.log(Level.WARNING, "Connection not open, client fail over may be in progress ...");
            return false;
        }
        if (sQLException.getMessage().equalsIgnoreCase(CONNECTION_NOT_ACTIVE)) {
            this.theLogger.log(Level.WARNING, "Connection not active, client fail over may be in progress ...");
            return false;
        }
        if (this.hasFailOverOccurred(sQLException)) {
            this.theLogger.log(Level.WARNING, "Fail over has occurred, please wait for reconnection to complete ...");
            return true;
        }
        return bl;
    }

    public boolean isRollbackRequiredOnFailover(SQLException sQLException) {
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (!sQLException2.getSQLState().equals(ROLLBACK_REQUIRED_SQLSTATE) || sQLException2.getErrorCode() != 30105) continue;
            return true;
        }
        return false;
    }

    public boolean hasFailOverOccurred(SQLException sQLException) {
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (!sQLException2.getSQLState().equals(FAILOVER_SQLSTATE) || sQLException2.getErrorCode() != 47137) continue;
            return true;
        }
        return false;
    }

    public boolean isTransientFailoverException(SQLException sQLException, Connection connection) {
        boolean bl = false;
        if (this.isRollbackRequiredOnFailover(sQLException)) {
            this.theLogger.log(Level.WARNING, "Rollback required, rolling back.");
            try {
                connection.rollback();
            }
            catch (SQLException sQLException2) {
                this.theLogger.log(Level.SEVERE, "Rollback required, but rolling back failed unexpectedly", sQLException);
                return false;
            }
            return true;
        }
        if (sQLException.getSQLState().equalsIgnoreCase(CONNECTION_NOT_OPEN)) {
            this.theLogger.log(Level.WARNING, "Connection not open, client fail over may be in progress ...");
            return false;
        }
        if (sQLException.getMessage().equalsIgnoreCase(CONNECTION_NOT_ACTIVE)) {
            this.theLogger.log(Level.WARNING, "Connection not active, client fail over may be in progress ...");
            return false;
        }
        if (this.hasFailOverOccurred(sQLException)) {
            this.theLogger.log(Level.WARNING, "Fail over has occurred, please wait for reconnection to complete ...");
            return true;
        }
        return bl;
    }
}

