/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.connection.TTSQLExceptionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.IdeUtil;

public class DsSize
extends CommandListener {
    private static final String DSSIZE_SQL = "SELECT PERM_ALLOCATED_SIZE, PERM_IN_USE_SIZE, PERM_IN_USE_HIGH_WATER,TEMP_ALLOCATED_SIZE,TEMP_IN_USE_SIZE,TEMP_IN_USE_HIGH_WATER FROM SYS.MONITOR";

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        Connections connections = Connections.getInstance();
        if (!connections.isTimesTen(connection)) {
            return false;
        }
        TTSQLExceptionListener tTSQLExceptionListener = TTSQLExceptionListener.getTheInstance();
        boolean bl = false;
        String string = null;
        String string2 = null;
        for (int i = 0; i < 3; ++i) {
            bl = false;
            try {
                if (iSQLCommand.getSql().toUpperCase().indexOf("DSSIZE") != 0) continue;
                DsSizeUnit dsSizeUnit = DsSizeUnit.KB;
                string2 = iSQLCommand.getSql();
                int n = iSQLCommand.getSql().indexOf(" ");
                if (n > -1 && n++ < string2.length() && (string2.charAt(n) == 'm' || string2.charAt(n) == 'M')) {
                    dsSizeUnit = DsSizeUnit.MB;
                }
                String string3 = this.executeDsSizeSql(connection, dsSizeUnit);
                scriptRunnerContext.getOutputStream().write(("\n" + string2 + "\n").getBytes(IdeUtil.getIdeEncoding()));
                scriptRunnerContext.getOutputStream().write(string3.getBytes(IdeUtil.getIdeEncoding()));
                boolean bl2 = true;
                return bl2;
            }
            catch (SQLException sQLException) {
                if (tTSQLExceptionListener.isTransientFailoverException(sQLException, connection) && i < 2) {
                    try {
                        scriptRunnerContext.getOutputStream().write((MessageFormat.format(Messages.getString("TimesTenFailover.retryAttempt"), i + 1) + "\n").getBytes("UTF-8"));
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                    }
                }
                bl = true;
                string = TTSQLExceptionScrubber.getMessage(sQLException.getLocalizedMessage(), string2);
                return (boolean)string;
            }
            catch (Exception exception) {
                bl = true;
                string = TTSQLExceptionScrubber.getMessage(exception.getLocalizedMessage(), string2);
                return (boolean)string;
            }
            finally {
                if (!bl) continue;
                try {
                    scriptRunnerContext.getOutputStream().write(("\n" + string2.trim() + " " + Messages.getString("TimesTenCommand.failed") + "\n" + string + "\n").getBytes("UTF-8"));
                }
                catch (Exception exception) {}
                return true;
            }
        }
        return false;
    }

    private String executeDsSizeSql(Connection connection, DsSizeUnit dsSizeUnit) throws Exception {
        Statement statement = null;
        Object var4_4 = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(DSSIZE_SQL);
            StringBuffer stringBuffer = new StringBuffer(512);
            while (resultSet.next()) {
                stringBuffer.append("PERM_ALLOCATED_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(1) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("PERM_IN_USE_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(2) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("PERM_IN_USE_HIGH_WATER:\t");
                stringBuffer.append((double)resultSet.getLong(3) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("TEMP_ALLOCATED_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(4) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("TEMP_IN_USE_SIZE:\t");
                stringBuffer.append((double)resultSet.getLong(5) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
                stringBuffer.append("TEMP_IN_USE_HIGH_WATER:\t");
                stringBuffer.append((double)resultSet.getLong(6) / dsSizeUnit.getFactor());
                stringBuffer.append("\n");
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static enum DsSizeUnit {
        KB(1.0),
        MB(1024.0);

        private double factor;

        private DsSizeUnit(double d) {
            this.factor = d;
        }

        private double getFactor() {
            return this.factor;
        }
    }
}

