/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransientConnectionProperties {
    private static final Logger theLogger = Logger.getLogger(TransientConnectionProperties.class.getPackage().getName());
    private static TransientConnectionProperties theInstance;
    private WeakHashMap<Connection, Properties> theProperties = new WeakHashMap();

    private TransientConnectionProperties() {
    }

    public static synchronized TransientConnectionProperties getInstance() {
        if (theInstance == null) {
            theInstance = new TransientConnectionProperties();
        }
        return theInstance;
    }

    public synchronized void setProperty(Connection connection, PropertyTag propertyTag, String string) {
        this.setProperty(connection, propertyTag.getTag(), string);
    }

    public synchronized void setProperty(Connection connection, String string, String string2) {
        Properties properties = this.getProperties(connection, true);
        properties.put(string, string2);
    }

    public synchronized String getProperty(Connection connection, String string, String string2) {
        String string3 = null;
        Properties properties = this.getProperties(connection);
        if (properties == null) {
            return string3;
        }
        return properties.getProperty(string, string2);
    }

    public synchronized boolean isServerOutputEnabled(Connection connection) {
        Properties properties = this.getProperties(connection);
        if (properties == null) {
            return false;
        }
        return Boolean.parseBoolean(properties.getProperty(PropertyTag.ServerOutPut.getTag()));
    }

    public synchronized void enableServerOutput(Connection connection) {
        Properties properties = this.getProperties(connection, true);
        properties.setProperty(PropertyTag.ServerOutPut.getTag(), Boolean.TRUE.toString());
    }

    public void disableServerOutput(Connection connection) {
        Properties properties = this.getProperties(connection, true);
        properties.setProperty(PropertyTag.ServerOutPut.getTag(), Boolean.FALSE.toString());
    }

    private Properties getProperties(Connection connection) {
        return this.getProperties(connection, false);
    }

    private Properties getProperties(Connection connection, boolean bl) {
        Properties properties = this.theProperties.get(connection);
        if (bl) {
            if (properties == null) {
                properties = new Properties();
                this.theProperties.put(connection, properties);
            }
        } else if (properties == null) {
            theLogger.log(Level.WARNING, "Connection is not cached");
        }
        return properties;
    }

    public static enum PropertyTag {
        ServerOutPut("ServerOutput"),
        UNDEFINED("UNDEFINED");

        private String _tag;

        protected String getTag() {
            return this._tag;
        }

        private PropertyTag(String string2) {
            this._tag = string2;
        }
    }
}

