/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.FunctionPrivilege;
import oracle.dbtools.raptor.timesten.IndexPrivilege;
import oracle.dbtools.raptor.timesten.MaterializedViewLogsPrivilege;
import oracle.dbtools.raptor.timesten.PackagePrivilege;
import oracle.dbtools.raptor.timesten.ProcedurePrivilege;
import oracle.dbtools.raptor.timesten.SequencePrivilege;
import oracle.dbtools.raptor.timesten.SupportedObjectType;
import oracle.dbtools.raptor.timesten.TablePrivilege;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.ViewPrivilege;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.objectpriv.IObjectCheck;

class ObjectPrivilegeCheck
implements IObjectCheck {
    private final int CREATE = 1;
    private final int DROP = 2;
    private final int ALTER = 3;
    private static final Logger _logger = Logger.getLogger(ObjectPrivilegeCheck.class.getPackage().getName());

    ObjectPrivilegeCheck() {
    }

    public boolean canAlter(DBObject dBObject) {
        boolean bl;
        if (TimesTenUtil.isSystemObject(dBObject)) {
            _logger.log(Level.WARNING, "System objects cannot be altered");
            return false;
        }
        boolean bl2 = dBObject.getObjectType().equals(SupportedObjectType.TABLE.getTag());
        boolean bl3 = bl = dBObject.getObjectType().equals("SEQUENCE");
        if (bl && this.sequenceEditionSupported(dBObject.getConnection())) {
            return this.hasDDLPrivileges(dBObject, 3);
        }
        if (!bl2) {
            return false;
        }
        return this.hasDDLPrivileges(dBObject, 3);
    }

    private boolean sequenceEditionSupported(Connection connection) {
        return DataSheet.getInstance().isCapable(connection, DataSheet.FeatureType.EditSequences);
    }

    public boolean canCreate(DBObject dBObject) {
        if (TimesTenUtil.isSystemObject(dBObject)) {
            _logger.log(Level.WARNING, "System objects cannot be created");
            return false;
        }
        String string = dBObject.getObjectType();
        if (string.equals(SupportedObjectType.REPLICATION.getTag()) || string.equals(SupportedObjectType.USER.getTag())) {
            return false;
        }
        return this.hasDDLPrivileges(dBObject, 1);
    }

    public boolean canDrop(DBObject dBObject) {
        if (TimesTenUtil.isSystemObject(dBObject)) {
            _logger.log(Level.WARNING, "System objects cannot be dropped");
            return false;
        }
        String string = dBObject.getObjectType();
        if (string.equals(SupportedObjectType.REPLICATION.getTag()) || string.equals(SupportedObjectType.USER.getTag())) {
            return false;
        }
        return this.hasDDLPrivileges(dBObject, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPrivileges(DBObject dBObject) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        Statement statement = null;
        String string = null;
        ResultSet resultSet = null;
        try {
            statement = dBObject.getConnection().createStatement();
            string = dBObject.getConnection().getMetaData().getUserName().trim();
            String string2 = "SELECT PRIVILEGE FROM SYS.USER_SYS_PRIVS WHERE USERNAME='" + string + "'";
            _logger.log(Level.INFO, string2);
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("PRIVILEGE").trim());
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "Cannot get user privileges for " + string, exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private boolean hasDDLPrivileges(DBObject dBObject, int n) {
        TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
        String string = null;
        String string2 = null;
        try {
            string = dBObject.getConnection().getMetaData().getUserName().trim();
            string2 = dBObject.getSchemaName();
            List<String> list = this.getPrivileges(dBObject);
            if (list.contains("ADMIN")) {
                return true;
            }
            if (string.equals(string2)) {
                if (this.checkInSameSchema(dBObject, list, n)) {
                    return true;
                }
                return this.checkInDiffSchema(dBObject, list, n);
            }
            return this.checkInDiffSchema(dBObject, list, n);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "Cannot get user privileges for " + string, exception);
            return false;
        }
    }

    private boolean checkInSameSchema(DBObject dBObject, List list, int n) {
        switch (n) {
            case 1: {
                return this.createPrivilegeInSameSchema(dBObject, list);
            }
            case 2: {
                return this.dropPrivilegeInSameSchema(dBObject, list);
            }
            case 3: {
                return this.alterPrivilegeInSameSchema(dBObject, list);
            }
        }
        return false;
    }

    private boolean checkInDiffSchema(DBObject dBObject, List list, int n) {
        String string = dBObject.getObjectType();
        switch (n) {
            case 1: {
                return this.createPrivilegeInDiffSchema(dBObject, list);
            }
            case 2: {
                return this.dropPrivilegeInDiffSchema(dBObject, list);
            }
            case 3: {
                return this.alterPrivilegeInDiffSchema(dBObject, list);
            }
        }
        return false;
    }

    private boolean createPrivilegeInSameSchema(DBObject dBObject, List list) {
        String string = dBObject.getObjectType();
        String string2 = null;
        if (string.startsWith(SupportedObjectType.TABLE.getTag())) {
            string2 = TablePrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.VIEW.getTag())) {
            string2 = ViewPrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.SEQUENCE.getTag())) {
            string2 = SequencePrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PACKAGE.getTag())) {
            string2 = PackagePrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PROCEDURE.getTag())) {
            string2 = ProcedurePrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.FUNCTION.getTag())) {
            string2 = FunctionPrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.MATERIALIZED_VIEW_LOGS.getTag())) {
            string2 = MaterializedViewLogsPrivilege.CREATEINSAMESCHEMA.getPrivilege();
            return list.contains(string2);
        }
        return true;
    }

    private boolean createPrivilegeInDiffSchema(DBObject dBObject, List list) {
        String string = dBObject.getObjectType();
        String string2 = null;
        if (string.startsWith(SupportedObjectType.TABLE.getTag())) {
            string2 = TablePrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.VIEW.getTag())) {
            string2 = ViewPrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            string2 = IndexPrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.SEQUENCE.getTag())) {
            string2 = SequencePrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PACKAGE.getTag())) {
            string2 = PackagePrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PROCEDURE.getTag())) {
            string2 = ProcedurePrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.FUNCTION.getTag())) {
            string2 = FunctionPrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.MATERIALIZED_VIEW_LOGS.getTag())) {
            string2 = MaterializedViewLogsPrivilege.CREATEINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        return true;
    }

    private boolean dropPrivilegeInSameSchema(DBObject dBObject, List list) {
        String string = dBObject.getObjectType();
        Object var4_4 = null;
        if (string.startsWith(SupportedObjectType.TABLE.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.VIEW.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.MATERIALIZED_VIEW_LOGS.getTag())) {
            return true;
        }
        return true;
    }

    private boolean dropPrivilegeInDiffSchema(DBObject dBObject, List list) {
        String string = dBObject.getObjectType();
        String string2 = null;
        if (string.startsWith(SupportedObjectType.TABLE.getTag())) {
            string2 = TablePrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.VIEW.getTag())) {
            string2 = ViewPrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            string2 = IndexPrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.SEQUENCE.getTag())) {
            string2 = SequencePrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PACKAGE.getTag())) {
            string2 = PackagePrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PROCEDURE.getTag())) {
            string2 = ProcedurePrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.FUNCTION.getTag())) {
            string2 = FunctionPrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.MATERIALIZED_VIEW_LOGS.getTag())) {
            string2 = MaterializedViewLogsPrivilege.DROPINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        return true;
    }

    private boolean alterPrivilegeInSameSchema(DBObject dBObject, List list) {
        String string = dBObject.getObjectType();
        Object var4_4 = null;
        if (string.startsWith(SupportedObjectType.TABLE.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.VIEW.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.SEQUENCE.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.PACKAGE.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.PROCEDURE.getTag())) {
            return true;
        }
        if (string.startsWith(SupportedObjectType.FUNCTION.getTag())) {
            return true;
        }
        return true;
    }

    private boolean alterPrivilegeInDiffSchema(DBObject dBObject, List list) {
        String string = dBObject.getObjectType();
        String string2 = null;
        if (string.startsWith(SupportedObjectType.TABLE.getTag())) {
            string2 = TablePrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.VIEW.getTag())) {
            string2 = ViewPrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.INDEX.getTag())) {
            string2 = IndexPrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.SEQUENCE.getTag())) {
            string2 = SequencePrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PROCEDURE.getTag())) {
            string2 = ProcedurePrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.PACKAGE.getTag())) {
            string2 = PackagePrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        if (string.startsWith(SupportedObjectType.FUNCTION.getTag())) {
            string2 = FunctionPrivilege.ALTERINDIFFSCHEMA.getPrivilege();
            return list.contains(string2);
        }
        return true;
    }
}

