/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.SupportedObjectType;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.objectpriv.IObjectCheck;

class BasicObjectCheck
implements IObjectCheck {
    private static final Logger _logger = Logger.getLogger(BasicObjectCheck.class.getPackage().getName());

    BasicObjectCheck() {
    }

    public boolean canAlter(DBObject dBObject) {
        if (TimesTenUtil.isSystemObject(dBObject)) {
            _logger.log(Level.WARNING, "BasicObjectCheck system objects cannot be altered");
            return false;
        }
        boolean bl = dBObject.getObjectType().equals(SupportedObjectType.TABLE.getTag());
        if (!bl) {
            return false;
        }
        return this.hasDDLPrivileges(dBObject);
    }

    public boolean canCreate(DBObject dBObject) {
        if (TimesTenUtil.isSystemObject(dBObject)) {
            _logger.log(Level.WARNING, "BasicObjectCheck system objects cannot be created");
            return false;
        }
        String string = dBObject.getObjectType();
        if (string.equals(SupportedObjectType.CACHE_GROUP.getTag()) || string.equals(SupportedObjectType.REPLICATION.getTag()) || string.equals(SupportedObjectType.USER.getTag())) {
            return false;
        }
        return this.hasDDLPrivileges(dBObject);
    }

    public boolean canDrop(DBObject dBObject) {
        if (TimesTenUtil.isSystemObject(dBObject)) {
            _logger.log(Level.WARNING, "BasicObjectCheck system objects cannot be dropped");
            return false;
        }
        String string = dBObject.getObjectType();
        if (string.equals(SupportedObjectType.CACHE_GROUP.getTag()) || string.equals(SupportedObjectType.REPLICATION.getTag()) || string.equals(SupportedObjectType.USER.getTag())) {
            return false;
        }
        return this.hasDDLPrivileges(dBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPrivileges(DBObject dBObject) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        Statement statement = null;
        String string = null;
        ResultSet resultSet = null;
        try {
            statement = dBObject.getConnection().createStatement();
            string = dBObject.getConnection().getMetaData().getUserName().trim();
            resultSet = statement.executeQuery("CALL ttUserPrivileges('" + string + "')");
            _logger.log(Level.INFO, "CALL ttUserPrivileges('" + string + "')");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(2).trim());
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "BasicObjectCheck cannot get user privileges for" + string, exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private boolean hasDDLPrivileges(DBObject dBObject) {
        TTInstanceInformation tTInstanceInformation = TTInstanceInformation.getInstance();
        if (!tTInstanceInformation.accessControlEnabled()) {
            return true;
        }
        List<String> list = this.getPrivileges(dBObject);
        if (list.contains("ALL") || list.contains("DDL")) {
            _logger.log(Level.INFO, "BasicObjectCheck connection user has ddl privilege for object" + dBObject.getObjectType());
            return true;
        }
        _logger.log(Level.INFO, "BasicObjectCheck connection user has no ddl privileges for object" + dBObject.getObjectType());
        return false;
    }
}

