/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPrintDriver;

class XMLPrinter
extends XMLPrintDriver {
    private final int _indent;
    private final boolean _useTabs;
    private final int _tabSize;
    private final Field _mixed;

    XMLPrinter(PrintWriter pw, int indent, boolean useTabs, int tabSize) {
        super(pw);
        this._indent = indent;
        this._useTabs = useTabs;
        this._tabSize = tabSize;
        this._mixed = XMLPrinter.getMixedField();
        if (this._mixed != null) {
            this.out = new XMLOut(pw);
        }
    }

    XMLPrinter(OutputStream os, int indent, boolean useTabs, int tabSize) {
        super(os);
        this._indent = indent;
        this._useTabs = useTabs;
        this._tabSize = tabSize;
        this._mixed = XMLPrinter.getMixedField();
        if (this._mixed != null) {
            this.out = new XMLOut(os);
        }
    }

    private static Field getMixedField() {
        try {
            Class<XMLOutputStream> c = XMLOutputStream.class;
            Field f = c.getDeclaredField("mixed");
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            return null;
        }
    }

    private class XMLOut
    extends XMLOutputStream {
        private int _curIndent;

        XMLOut(PrintWriter pw) {
            super((Writer)pw);
            this._curIndent = 0;
        }

        XMLOut(OutputStream os) {
            super(os);
            this._curIndent = 0;
        }

        public void addIndent(int offset) {
            this._curIndent += offset;
        }

        public void writeIndent() throws IOException {
            if (this.getOutputStyle() == 1 && XMLPrinter.this._indent > 0 && this._curIndent > 0 && this.isNotMixed()) {
                int i;
                int numSpaces = this._curIndent * XMLPrinter.this._indent;
                int numTabs = 0;
                if (XMLPrinter.this._useTabs) {
                    numTabs = numSpaces / XMLPrinter.this._tabSize;
                    numSpaces %= XMLPrinter.this._tabSize;
                }
                char[] chars = new char[numTabs + numSpaces];
                for (i = 0; i < numTabs; ++i) {
                    chars[i] = 9;
                }
                while (i < chars.length) {
                    chars[i] = 32;
                    ++i;
                }
                this.writeChars(new String(chars));
            }
        }

        private boolean isNotMixed() {
            try {
                return XMLPrinter.this._mixed != null ? !XMLPrinter.this._mixed.getBoolean((Object)this) : true;
            }
            catch (Exception e) {
                return true;
            }
        }
    }
}

