/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMStateInfo;
import oracle.ide.wizard.FSMTransitionException;
import oracle.ide.wizard.FSMWizardListener;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WizardArb;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;

public final class FSMWizard
extends Wizard
implements CommitNotifier {
    private final FSM _fsm;
    private final Namespace _data;
    private final WizardCallbacks _wc;
    private WizardDialog _dialog;
    private FSMStateInfo _curFsmStateInfo;
    private EventListenerList _commitListeners;
    private ArrayList<FSMWizardListener> _wizardListeners;
    private boolean _skipCurStep;
    private String _wizardTitle;
    private int _direction;
    private boolean _dontSelect = true;
    private Map _pagePool = new HashMap();
    private FSMStateInfo _gotoStateInfo;
    private boolean _disposed;
    private FSMStateInfo _expstateInfo = null;
    private static final Color[] WIZARD_HEADER_GRADIENT = new Color[]{new Color(254, 254, 254), new Color(206, 223, 230)};
    private static final int RANDOM_FORWARD = 0;
    private static final int RANDOM_BACKWARD = 3;

    public FSMWizard(Step[] steps, Namespace data) {
        this(FSMBuilder.newFSM(steps), data);
    }

    public FSMWizard(FSM fsm, Namespace data) {
        if (fsm == null) {
            throw new IllegalArgumentException(WizardArb.getString(28));
        }
        if (data == null) {
            throw new IllegalArgumentException("FSMWizard data cannot be null.");
        }
        fsm.reset();
        this._fsm = fsm;
        this._data = data;
        this._wc = new WC();
        this._populatePages();
        fsm.reset();
        this.selectPage(this.getPageAt(0));
        this.setRoadmapVisible(true);
        this.setHeaderGradientBackground(WIZARD_HEADER_GRADIENT);
    }

    public void setWizardTitle(String wizardTitle) {
        this._wizardTitle = wizardTitle;
        if (this._dialog != null) {
            this._dialog.setWizardTitle(wizardTitle);
        }
    }

    @Deprecated
    public void setShowStepNumber(boolean showStepNumber) {
    }

    public boolean getShowStepNumber() {
        return true;
    }

    public void setWelcomePageAdded(boolean pageAdded) {
    }

    public void setFinishPageAdded(boolean pageAdded) {
    }

    public void setLogoImage(Image image) {
        super.setLogoImage(image);
    }

    @Override
    public void addCommitListener(CommitListener commitListener) {
        if (this._commitListeners == null) {
            this._commitListeners = new EventListenerList();
        }
        this._commitListeners.add(CommitListener.class, commitListener);
    }

    @Override
    public void removeCommitListener(CommitListener commitListener) {
        if (this._commitListeners != null) {
            this._commitListeners.remove(CommitListener.class, commitListener);
        }
    }

    public void addFSMWizardListener(FSMWizardListener listener) {
        if (listener != null) {
            if (this._wizardListeners == null) {
                this._wizardListeners = new ArrayList();
            }
            this._wizardListeners.add(listener);
        }
    }

    public void removeFSMWizardListener(FSMWizardListener listener) {
        if (listener != null && this._wizardListeners != null) {
            this._wizardListeners.remove(listener);
        }
    }

    public void updateImage(Image newImage) {
    }

    public WizardDialog getDialog(Frame parent) {
        return this.getDialogImpl(parent, null);
    }

    public WizardDialog getDialog(Dialog parent) {
        return this.getDialogImpl(null, parent);
    }

    public void setDialog(WizardDialog dialog) {
        this._dialog = dialog;
    }

    public void dispose() {
        super.dispose();
        this._disposed = true;
    }

    public boolean isDisposed() {
        return this._disposed;
    }

    public void reset() {
        super.reset();
        this._fsm.reset();
        this._curFsmStateInfo = null;
    }

    protected void doPrevious() {
        WizardPage previous = this.getPreviousPage(this.getSelectedPage());
        if (previous != null) {
            this.selectPage(previous, true);
        }
    }

    protected void doNext() {
        WizardPage next = this.getNextPage(this.getSelectedPage());
        if (next != null) {
            this.selectPage(next, true);
        }
    }

    protected void doFinish() {
        this._direction = 1;
        if (this._validateFSMState(true)) {
            super.doFinish();
        }
    }

    protected void doCancel() {
        if (this._commitListeners != null) {
            ApplyEvent commitEvent = null;
            EventListener[] listeners = this._commitListeners.getListeners(CommitListener.class);
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (commitEvent == null) {
                    TraversableContext tc = new TraversableContext(this._data, 2);
                    tc.setWizardCallbacks(this._wc);
                    commitEvent = new ApplyEvent(tc);
                }
                try {
                    ((CommitListener)listeners[i]).cancel(commitEvent);
                    continue;
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                }
            }
        }
        super.doCancel();
    }

    protected void selectPage(WizardPage page, boolean doValidate) {
        if (this._dontSelect) {
            return;
        }
        if (page == null) {
            super.selectPage(page, doValidate);
            return;
        }
        WizardPage selectedPage = this.getSelectedPage();
        if (selectedPage == null || page == this.getNextPage(selectedPage)) {
            this._direction = 1;
        } else if (page == this.getPreviousPage(selectedPage)) {
            this._direction = 2;
        } else if (page.getIndex() > selectedPage.getIndex()) {
            this._direction = 0;
            this._expstateInfo = ((FSMWizardPage)page)._stateInfo;
        } else {
            this._direction = 3;
            this._expstateInfo = ((FSMWizardPage)page)._stateInfo;
        }
        this._gotoStateInfo = null;
        if (!this._validateFSMState(false)) {
            return;
        }
        if (selectedPage != null) {
            if (this._direction == 1) {
                page = this.getNextPage(selectedPage);
            } else if (this._direction == 2) {
                page = this.getPreviousPage(selectedPage);
            }
        }
        if (((FSMWizardPage)page).getStateInfo() != this._gotoStateInfo) {
            return;
        }
        super.selectPage(page, doValidate);
        this._checkSkipThisPage(this._direction);
    }

    protected void setSelectedPage(WizardPage page) {
        super.setSelectedPage(page);
        if (page != null) {
            int direction = this._direction;
            if (direction == 3) {
                direction = 2;
            } else if (direction == 0) {
                direction = 1;
            }
            TraversableContext tc = new TraversableContext(this._data, direction);
            tc.setWizardCallbacks(this._wc);
            this.gotoPanel(page, this._gotoStateInfo, tc);
        }
    }

    private void _populatePages() {
        try {
            FSMStateInfo stateInfo = null;
            Object transition = null;
            while ((stateInfo = this._fsm.nextState(transition)) != null) {
                this._addPage(stateInfo, null);
                if (!stateInfo.isFinalState()) {
                    transition = stateInfo.getStep().getExpectedTransition();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._dontSelect = false;
    }

    private WizardPage _addPage(FSMStateInfo stateInfo, WizardPage beforePage) {
        FSMWizardPage page;
        String label;
        if (this.isDisposed()) {
            return null;
        }
        Step step = stateInfo.getStep();
        String title = step.getPageTitle();
        Traversable tr = stateInfo.getTraversable(this);
        if (title == null && tr instanceof DefaultTraversablePanel) {
            title = ((DefaultTraversablePanel)tr).getDefaultTitle();
        }
        if (title == null) {
            title = stateInfo.getStateID().toString();
        }
        if ((label = step.getStepLabel()) == null || "".equals(label)) {
            label = title;
        }
        if ((page = (FSMWizardPage)((Object)this._pagePool.get(stateInfo))) == null) {
            page = new FSMWizardPage(stateInfo, tr.getComponent(), label, title);
            this._pagePool.put(stateInfo, page);
        } else {
            page.setLabel(label);
            page.setPageTitle(title);
        }
        try {
            Map transitionMap = FSM.getTransitionMap(this._fsm.getStateNode(stateInfo.getStateID()));
            page.setBranching(transitionMap.size() > 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (page.getParent() == this) {
            if (beforePage != null && beforePage.getParent() == this && beforePage.getIndex() - page.getIndex() == 1) {
                return page;
            }
            this.removePage(page);
        }
        return this.addPage(page, beforePage);
    }

    private boolean _validateFSMState(boolean isFinal) {
        boolean valid;
        FSMWizardPage fsmPage = (FSMWizardPage)this.getSelectedPage();
        TraversableContext tc = this.exitCurrentPanel(this._direction);
        boolean bl = valid = tc != null;
        if (valid) {
            valid = isFinal ? this.finishImpl(tc) : this._canTraverseFSM();
        }
        if (fsmPage != null) {
            fsmPage.setValid(valid);
        }
        return valid;
    }

    private TraversableContext exitCurrentPanel(int direction) {
        if (direction == 3) {
            direction = 2;
        } else if (direction == 0) {
            direction = 1;
        }
        TraversableContext tc = new TraversableContext(this._data, direction);
        tc.setWizardCallbacks(this._wc);
        if (this._curFsmStateInfo != null) {
            try {
                Traversable oldTraversable = this._curFsmStateInfo.getTraversable(this);
                oldTraversable.onExit(tc);
                if (this._wizardListeners != null) {
                    for (FSMWizardListener listener : this._wizardListeners) {
                        listener.wizardPanelExited(oldTraversable, tc);
                    }
                }
            }
            catch (TraversalException e) {
                e.showMessageDialog((Component)((Object)this));
                return null;
            }
        }
        return tc;
    }

    private boolean _canTraverseFSM() {
        block14: {
            try {
                if (this._direction == 1) {
                    Object transition;
                    if (this._curFsmStateInfo != null) {
                        Traversable traversable = this._curFsmStateInfo.getTraversable(this);
                        transition = traversable.getExitTransition();
                        this.updateExpectedTransition(transition);
                    } else {
                        transition = null;
                    }
                    this._gotoStateInfo = this._fsm.nextState(transition);
                    break block14;
                }
                if (this._direction == 2) {
                    this._gotoStateInfo = this._fsm.previousState();
                    break block14;
                }
                if (this._direction == 0) {
                    try {
                        if (this._curFsmStateInfo != null) {
                            FSMStateInfo stateInfo = this._curFsmStateInfo;
                            Object transition = this._curFsmStateInfo.getStep().getExpectedTransition();
                            while (stateInfo != this._expstateInfo && (stateInfo = this._fsm.nextState(transition)) != null && !stateInfo.isFinalState()) {
                                transition = stateInfo.getStep().getExpectedTransition();
                            }
                            this._gotoStateInfo = this._expstateInfo;
                        }
                        break block14;
                    }
                    catch (Exception stateInfo) {}
                    break block14;
                }
                if (this._direction == 3) {
                    FSMStateInfo stateInfo = this._curFsmStateInfo;
                    while (stateInfo != this._expstateInfo) {
                        stateInfo = this._fsm.previousState();
                    }
                    this._gotoStateInfo = this._expstateInfo;
                }
            }
            catch (FSMTransitionException e) {
                this.handleFSMTransitionException(e);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void gotoPanel(WizardPage page, FSMStateInfo newStateInfo, TraversableContext tc) {
        this.enableButtons(null, null, true);
        Traversable newTraversable = newStateInfo.getTraversable(this);
        this._skipCurStep = false;
        this._curFsmStateInfo = newStateInfo;
        this.updatePageTitle(page, newStateInfo);
        try {
            newTraversable.onEntry(tc);
            if (this._wizardListeners != null) {
                for (FSMWizardListener listener : this._wizardListeners) {
                    listener.wizardPanelEntered(newTraversable, tc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Component newComp = newTraversable.getComponent();
        if (page.getContent() != newComp) {
            page.setContent(newComp);
        }
        this.updateHelpID(page, newStateInfo.getStep(), newTraversable);
    }

    private void _checkSkipThisPage(int direction) {
        if (this._skipCurStep) {
            this._skipCurStep = false;
            WizardPage selectedPage = this.getSelectedPage();
            switch (direction) {
                case 0: 
                case 1: {
                    if (this._fsm.isHalted()) break;
                    if (this.getNextPage(selectedPage) == null) {
                        this.doPrevious();
                    } else {
                        this.doNext();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    if (this._fsm.isStarting()) break;
                    if (this.getPreviousPage(selectedPage) == null) {
                        this.doNext();
                    } else {
                        this.doPrevious();
                    }
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void enableButtons(Boolean back, Boolean next, Boolean finish) {
        WizardPage page = this.getSelectedPage();
        if (page == null) {
            return;
        }
        boolean enableback = back == null ? this._fsm.getStepNumber() > 1 : back;
        page.setCanGoBack(enableback);
        boolean enablenext = next == null ? !this._fsm.inFinalState() : next;
        boolean enablefinish = finish == null ? this._fsm.inFinalState() : finish.booleanValue();
        page.setCanAdvance(enablenext || enablefinish);
        this.setMustFinish(!enablefinish);
    }

    private boolean finishImpl(TraversableContext tc) {
        try {
            if (this._commitListeners != null) {
                int i;
                ApplyEvent commitEvent = null;
                EventListener[] listeners = this._commitListeners.getListeners(CommitListener.class);
                for (i = listeners.length - 1; i >= 0; --i) {
                    if (commitEvent == null) {
                        commitEvent = new ApplyEvent(tc);
                    }
                    try {
                        ((CommitListener)listeners[i]).checkCommit(commitEvent);
                        continue;
                    }
                    catch (RuntimeException re) {
                        ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                    }
                }
                try {
                    for (i = listeners.length - 1; i >= 0; --i) {
                        try {
                            ((CommitListener)listeners[i]).commit(commitEvent);
                            continue;
                        }
                        catch (RuntimeException re) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                        }
                    }
                }
                catch (TraversalException ex) {
                    for (int j = i + 1; j < listeners.length; ++j) {
                        try {
                            ((CommitListener)listeners[j]).rollback(commitEvent);
                            continue;
                        }
                        catch (RuntimeException re) {
                            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)re);
                        }
                    }
                    throw ex;
                }
            }
            return true;
        }
        catch (TraversalException ex) {
            ex.showMessageDialog((Component)((Object)this));
            return false;
        }
    }

    private void updateHelpID(WizardPage page, Step step, Traversable traversable) {
        JComponent helpTarget = (JComponent)page.getContent();
        HelpUtils.setHelpID((JComponent)helpTarget, null);
        String helpID = MetaTraversable.findHelpID(step, traversable);
        HelpUtils.setHelpID((JComponent)helpTarget, (String)helpID);
    }

    private void updateAccessibleDescription(String desc) {
        WizardPage page = this.getSelectedPage();
        if (page != null) {
            page.setAccessibleDescription(desc);
        }
    }

    private void updatePageTitle(WizardPage page, FSMStateInfo stateInfo) {
        Step step = stateInfo.getStep();
        String title = step.getPageTitle();
        if (!ModelUtil.hasLength((String)title)) {
            Traversable newTraversable = this._curFsmStateInfo.getTraversable(this);
            if (newTraversable instanceof DefaultTraversablePanel) {
                title = ((DefaultTraversablePanel)newTraversable).getDefaultTitle();
            }
            if (!ModelUtil.hasLength((String)title)) {
                // empty if block
            }
        }
        page.setPageTitle(title);
        String label = step.getStepLabel();
        if (label == null || "".equals(label)) {
            page.setLabel(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateExpectedTransition(Object transition) {
        if (transition == this._curFsmStateInfo.getStep().getExpectedTransition()) {
            return;
        }
        this._curFsmStateInfo.getStep().setExpectedTransition(transition);
        WizardPage currPage = this.getSelectedPage();
        try {
            Map transitionMap = FSM.getTransitionMap(this._fsm.getStateNode(this._curFsmStateInfo.getStateID()));
            currPage.setBranching(transitionMap.size() > 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int fwStepCount = 0;
        FSMStateInfo newStateInfo = null;
        this.freezeRepaints();
        try {
            while (true) {
                newStateInfo = this._fsm.nextState(transition);
                ++fwStepCount;
                WizardPage nextPage = this.getNextPage(currPage);
                boolean removeNext = false;
                if (nextPage != null) {
                    if (newStateInfo != null && ((FSMWizardPage)nextPage).getStateInfo() == newStateInfo) {
                        return;
                    }
                    removeNext = true;
                }
                if (newStateInfo != null) {
                    currPage = this._addPage(newStateInfo, nextPage);
                }
                if (removeNext) {
                    this.removePage(nextPage);
                }
                if (newStateInfo == null || newStateInfo.isFinalState()) {
                    if (currPage == null) return;
                    while ((nextPage = this.getNextPage(currPage)) != null) {
                        this.removePage(nextPage);
                    }
                    return;
                }
                transition = newStateInfo.getStep().getExpectedTransition();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                Object stateInfo = null;
                while (true) {
                    if (fwStepCount-- <= 0) {
                    }
                    newStateInfo = this._fsm.previousState();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.unfreezeRepaints();
                if (newStateInfo == this._curFsmStateInfo) return;
                throw new IllegalStateException("Invalid State");
            }
        }
    }

    private void updateInitialFocus(Component comp) {
        WizardPage page = this.getSelectedPage();
        if (page != null) {
            page.setInitialFocus(comp);
        }
    }

    private WizardDialog getDialogImpl(Frame parentFrame, Dialog parentDialog) {
        if (this._dialog == null) {
            this._dialog = parentDialog != null ? new WizardDialog((BaseWizard)this, parentDialog) : (parentFrame != null ? new WizardDialog((BaseWizard)this, parentFrame) : new WizardDialog((BaseWizard)this));
        }
        this._dialog.setWizardTitle(this._wizardTitle);
        return this._dialog;
    }

    private void handleFSMTransitionException(FSMTransitionException e) {
        TraversalException ex = new TraversalException("Internal error in FSM: " + e.getLocalizedMessage());
        FSMWizard parent = this._dialog != null ? this._dialog : this;
        ExceptionDialog.showExceptionDialog((Component)((Object)parent), (Throwable)ex);
        ex.printStackTrace();
    }

    private final class WC
    extends WizardCallbacks {
        private WC() {
        }

        @Override
        public void addCommitListener(CommitListener commitListener) {
            FSMWizard.this.addCommitListener(commitListener);
        }

        @Override
        public void removeCommitListener(CommitListener commitListener) {
            FSMWizard.this.removeCommitListener(commitListener);
        }

        @Override
        public void wizardEnableButtons(Boolean back, Boolean next, Boolean finish) {
            FSMWizard.this.enableButtons(back, next, finish);
        }

        @Override
        public void wizardSkipCurrentStep() {
            FSMWizard.this._skipCurStep = true;
        }

        @Override
        public void wizardUpdateAccessibleDescription(String desc) {
            FSMWizard.this.updateAccessibleDescription(desc);
        }

        @Override
        public void wizardUpdateImage(Image image) {
            FSMWizard.this.updateImage(image);
        }

        @Override
        public void wizardUpdateTitle(String title, Boolean showStepNumber) {
            FSMWizardPage page = (FSMWizardPage)FSMWizard.this.getSelectedPage();
            if (page != null) {
                page.setPageTitle(title);
                page.setLabel(title);
            }
        }

        @Override
        public void wizardUpdateExpectedTransition(Object transition) {
            FSMWizard.this.updateExpectedTransition(transition);
        }

        @Override
        public void wizardSetInitialFocus(Component comp) {
            FSMWizard.this.updateInitialFocus(comp);
        }

        @Override
        public void nextPage() {
            FSMWizard.this.doNext();
        }

        @Override
        public void previousPage() {
            FSMWizard.this.doPrevious();
        }
    }

    private class FSMWizardPage
    extends WizardPage {
        private FSMStateInfo _stateInfo;

        public FSMWizardPage(FSMStateInfo stateInfo, Component content, String label, String pageTitle) {
            super(content, label, pageTitle);
            this._stateInfo = stateInfo;
        }

        public FSMStateInfo getStateInfo() {
            return this._stateInfo;
        }
    }
}

