/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.scriptparser.sqlplus;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.worksheet.scriptparser.api.IScriptParser;
import oracle.dbtools.worksheet.utils.TextBufferReader;

public class SQLPlusScriptParser
implements IScriptParser {
    private ScriptParser m_parser = null;
    private ISQLCommand m_nextCmd = null;
    private Logger m_logger = Logger.getLogger(this.getClass().getName());
    private int m_startPos = 0;
    private int m_endPos = 0;
    private int m_startLine = 0;
    private int m_curLinePos = 0;
    private boolean m_onlyExecutable = false;
    private Reader m_reader = null;

    public SQLPlusScriptParser(Reader reader) {
        this.m_reader = reader;
        this.m_parser = new ScriptParser(reader);
    }

    public void setReader(Reader reader) {
        this.m_reader = reader;
    }

    private void readStatementsToCursor() {
        try {
            ISQLCommand iSQLCommand = this.m_parser.next();
            if (iSQLCommand.getEndLine() >= this.m_curLinePos) {
                this.m_nextCmd = iSQLCommand;
                return;
            }
            while (iSQLCommand != null) {
                iSQLCommand = this.m_parser.next();
                if (iSQLCommand.getEndLine() < this.m_curLinePos) continue;
                this.m_nextCmd = iSQLCommand;
                return;
            }
        }
        catch (IOException iOException) {
            this.m_logger.log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    @Override
    public boolean hasNext() {
        ISQLCommand iSQLCommand = null;
        try {
            if (this.m_nextCmd != null) {
                return true;
            }
            this.m_nextCmd = iSQLCommand = this.getNextValidCmd();
        }
        catch (Exception exception) {
            return false;
        }
        return iSQLCommand != null;
    }

    private ISQLCommand getNextValidCmd() {
        ISQLCommand iSQLCommand = null;
        try {
            iSQLCommand = this.m_parser.next();
        }
        catch (IOException iOException) {
            this.m_logger.log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
        }
        while (iSQLCommand != null && !this.isValidCommand(iSQLCommand) && this.isCommandWithinBounds(iSQLCommand)) {
            try {
                iSQLCommand = this.m_parser.next();
            }
            catch (IOException iOException) {
                this.m_logger.log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        if (iSQLCommand != null && this.isValidCommand(iSQLCommand)) {
            this.updatePostionBasedOnSelection(iSQLCommand);
            return iSQLCommand;
        }
        return null;
    }

    private void updatePostionBasedOnSelection(ISQLCommand iSQLCommand) {
        if (this.m_startLine != 0) {
            iSQLCommand.setStartLine(iSQLCommand.getStartLine() + this.m_startLine);
            iSQLCommand.setEndLine(iSQLCommand.getEndLine() + this.m_startLine);
        }
    }

    private boolean isCommandWithinBounds(ISQLCommand iSQLCommand) {
        if (this.m_endPos == 0) {
            return true;
        }
        return iSQLCommand.getStartLine() < this.m_endPos;
    }

    private boolean isValidCommand(ISQLCommand iSQLCommand) {
        if (this.isOnlyExecutable()) {
            if (this.isExecutable(iSQLCommand)) {
                return this.isCommandWithinBounds(iSQLCommand);
            }
            return false;
        }
        return this.isCommandWithinBounds(iSQLCommand);
    }

    private boolean isExecutable(ISQLCommand iSQLCommand) {
        return iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_INSERT) || iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_UPDATE) || iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_DELETE) || iSQLCommand.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_SELECT);
    }

    private boolean isOnlyExecutable() {
        return this.m_onlyExecutable;
    }

    @Override
    public ISQLCommand next() {
        ISQLCommand iSQLCommand = null;
        try {
            if (this.m_nextCmd != null) {
                iSQLCommand = this.m_nextCmd;
                this.m_nextCmd = null;
            } else {
                iSQLCommand = this.getNextValidCmd();
            }
        }
        catch (Exception exception) {
            this.m_logger.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        return iSQLCommand;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedPos(int n, int n2, int n3) {
        this.m_startPos = n;
        this.m_endPos = n2;
        this.m_startLine = n3;
        ((TextBufferReader)this.m_reader).setSelection(this.m_startPos, this.m_endPos);
    }

    @Override
    public void setOnlyExecutable(boolean bl) {
        this.m_onlyExecutable = bl;
    }

    @Override
    public ISQLCommand getCommandAtCursorPos(int n) {
        this.m_curLinePos = n;
        this.readStatementsToCursor();
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }
}

