/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.extension;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.net.IdeURLFileSystemHelper;
import oracle.ide.net.URLFactory;

public class WorksheetURLFileSystemHelper
extends IdeURLFileSystemHelper {
    public static final String PROTOCOL = "ide.worksheet";
    private static Map<String, String> s_names = new HashMap<String, String>();

    public static URL createWorksheetURL(String string) throws IOException {
        URL uRL = null;
        try {
            File file = File.createTempFile("worksheet", ".sql");
            file.deleteOnExit();
            URL uRL2 = URLFactory.newFileURL((File)file);
            uRL = URLFactory.newIdeURL((String)PROTOCOL, (URL)uRL2);
            WorksheetURLFileSystemHelper.updateDisplayName(uRL, string);
        }
        catch (IOException iOException) {
            Logger.getLogger(WorksheetURLFileSystemHelper.class.getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            throw iOException;
        }
        return uRL;
    }

    static void clearDisplayName(URL uRL) {
        s_names.remove(uRL.getPath());
    }

    public static void updateDisplayName(URL uRL, String string) {
        String string2 = s_names.get(uRL.getPath());
        String string3 = Connections.getDisplayName((String)string);
        Collection<String> collection = s_names.values();
        Object object = string3;
        int n = 1;
        while (collection.contains(object) && !((String)object).equals(string2)) {
            object = string3 + "~" + n++;
        }
        string3 = object;
        s_names.put(uRL.getPath(), string3);
    }

    public static boolean isWorksheetURL(URL uRL) {
        return uRL != null && uRL.getProtocol().startsWith(PROTOCOL);
    }

    private String getDisplayName(URL uRL) {
        return s_names.get(uRL.getPath());
    }

    public String getPlatformPathName(URL uRL) {
        String string = this.getDisplayName(uRL);
        return string != null ? string : super.getPlatformPathName(uRL);
    }

    public String getFileName(URL uRL) {
        String string = this.getDisplayName(uRL);
        return string != null ? string : super.getFileName(uRL);
    }

    public void delete(URL uRL) throws IOException {
        super.delete(uRL);
        s_names.remove(uRL.getPath());
    }

    public long lastModified(URL uRL) {
        return -1L;
    }
}

