/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import oracle.dbtools.util.Logger;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPrompts;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetGUI;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.WordLocator;
import oracle.javatools.editor.plugins.EditorPlugin;

public class ClickableScriptErrorPlugin
implements EditorPlugin {
    private int _lastSqlEditorPaneOffset;
    private int _lastResultPaneOffset;
    private HashMap<Integer, Position> _defaultLinePosCache;
    private HashMap<String, HashMap<Integer, Position>> _fileCache;
    public final String TOP_SQL_EDITOR = "worksheet.topcomponent";
    private BasicEditorPane _topEditor;
    private BasicEditorPane _scriptResultPane;
    private PLSQLDocRendererWithClickableErrorSupport _plsqlDocRenderWithClickSupport;
    private BaseStyle _clickableComponentStyle;
    private LanguageSupport _clickableErrorLangSupport;
    private final String COMP_STYLE_INT_NAME = this.getClass() + "-COMP_STYLE";
    private final String COMP_STYLE_EXT_NAME = "Clickable Component Style";
    private static String ERROR_LINE_MARKER;
    private static String ERROR_LINE_COL_MARKER;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.createStyles();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        DocumentRenderer documentRenderer = basicDocument.getDocumentRenderer();
        LanguageSupport languageSupport = basicDocument.getLanguageSupport();
        this._plsqlDocRenderWithClickSupport = new PLSQLDocRendererWithClickableErrorSupport(documentRenderer, basicDocument);
        this._clickableErrorLangSupport = new LanguageSupportWithClickAction(languageSupport, this._plsqlDocRenderWithClickSupport);
        this._scriptResultPane = basicEditorPane;
        this._lastResultPaneOffset = 0;
        this._lastSqlEditorPaneOffset = 0;
        this._scriptResultPane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ClickableScriptErrorPlugin.this._scriptResultPane.viewToModel(point);
                int n2 = ClickableScriptErrorPlugin.this._scriptResultPane.getLineFromOffset(n);
                int n3 = ClickableScriptErrorPlugin.this._scriptResultPane.getLineStartOffset(n2);
                int n4 = ClickableScriptErrorPlugin.this._scriptResultPane.getLineEndOffset(n2);
                try {
                    String string = ClickableScriptErrorPlugin.this._scriptResultPane.getDocument().getText(n3, n4 - n3);
                    ClickableScriptErrorPlugin.this.processErrorLineClick(string);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        basicDocument.setLanguageSupport(this._clickableErrorLangSupport);
        this._topEditor = (BasicEditorPane)basicEditorPane.getProperty("worksheet.topcomponent");
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void markResultPaneEndOffset() {
        this._lastResultPaneOffset = this._scriptResultPane.getDocument().getLength();
        if (this._lastSqlEditorPaneOffset != this._topEditor.getDocument().getLength()) {
            this._defaultLinePosCache.clear();
            this._fileCache.clear();
            this._lastSqlEditorPaneOffset = this._topEditor.getDocument().getLength();
        }
    }

    private void createStyles() {
        EditorProperties editorProperties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
        this._clickableComponentStyle = styleRegistry.lookupStyle(this.COMP_STYLE_INT_NAME);
        if (this._clickableComponentStyle == null) {
            this._clickableComponentStyle = styleRegistry.createStyle(this.COMP_STYLE_INT_NAME, "Clickable Component Style", "base-plain-style", Color.blue, Color.white, 0);
        }
    }

    private void processErrorLineClick(String string) {
        ErrorDescriptor errorDescriptor = new ErrorDescriptor(string);
        if (!errorDescriptor.hasError()) {
            return;
        }
        int n = 0;
        BasicEditorPane basicEditorPane = this._topEditor;
        File file = null;
        Editor editor = null;
        URL uRL = null;
        int n2 = errorDescriptor.getLine();
        int n3 = errorDescriptor.getColNo();
        Position position = null;
        String string2 = errorDescriptor.getFileName();
        if (string2 == null) {
            basicEditorPane.grabFocus();
            if (this._defaultLinePosCache != null) {
                position = this._defaultLinePosCache.get(n2);
                n = position.getOffset();
                basicEditorPane.setCaretPosition(n);
            }
        } else {
            if (string2 != null) {
                if ((string2 = string2.replaceAll("\"", "")).startsWith("http://") || string2.startsWith("ftp://")) {
                    try {
                        uRL = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                } else {
                    file = new File(string2);
                    if (file.exists()) {
                        try {
                            uRL = new URL("file://" + string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                        }
                    }
                }
            }
            if ((editor = EditorManager.getEditorManager().openDefaultEditorInFrame(uRL)) instanceof Worksheet && (basicEditorPane = ((WorksheetGUI)editor.getGUI()).getEditorPane()) instanceof BasicEditorPane) {
                HashMap<Integer, Position> hashMap = this._fileCache.get(string2);
                position = hashMap.get(n2);
                if (position == null) {
                    n = basicEditorPane.getLineStartOffset(n2);
                    basicEditorPane.setCaretPosition(n += n3);
                    try {
                        Position position2 = basicEditorPane.getDocument().createPosition(n);
                        HashMap<Integer, Position> hashMap2 = null;
                        hashMap2 = this._fileCache.get(string2);
                        hashMap2.put(n2, position2);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                } else {
                    n = position.getOffset();
                    basicEditorPane.setCaretPosition(n);
                }
            }
        }
    }

    static {
        String string = GuiPrompts.getString((String)"LINE_COMMAND_ERR");
        ERROR_LINE_MARKER = string.substring(0, string.indexOf("{"));
        ERROR_LINE_MARKER = ERROR_LINE_MARKER.indexOf(":") == -1 ? ERROR_LINE_MARKER.trim() : ERROR_LINE_MARKER.substring(0, ERROR_LINE_MARKER.indexOf(":")).trim();
        String string2 = GuiPrompts.getString((String)"LINE_COL_COMMAND_ERR");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        for (int i = 0; i < 2; ++i) {
            stringTokenizer.nextToken();
        }
        ERROR_LINE_COL_MARKER = stringTokenizer.nextToken();
        ERROR_LINE_COL_MARKER = ERROR_LINE_COL_MARKER.indexOf(":") == -1 ? ERROR_LINE_COL_MARKER.trim() : ERROR_LINE_COL_MARKER.substring(0, ERROR_LINE_COL_MARKER.indexOf(":")).trim();
    }

    private class LanguageSupportWithClickAction
    implements LanguageSupport {
        private LanguageSupport _origLangSupport;
        private DocumentRenderer _clickableErrRenderer;

        LanguageSupportWithClickAction(LanguageSupport languageSupport, DocumentRenderer documentRenderer) {
            this._origLangSupport = languageSupport;
            this._clickableErrRenderer = documentRenderer;
        }

        public BasicDocument getDocument() {
            return this._origLangSupport.getDocument();
        }

        public Object getProperty(String string) {
            return this._origLangSupport.getProperty(string);
        }

        public void install(BasicDocument basicDocument) {
            this._origLangSupport.install(basicDocument);
        }

        public void deinstall() {
            this._origLangSupport.deinstall();
        }

        public DocumentRenderer getDocumentRenderer() {
            return this._clickableErrRenderer;
        }

        public BraceProvider getBraceProvider() {
            return this._origLangSupport.getBraceProvider();
        }

        public WordLocator getWordLocator() {
            return this._origLangSupport.getWordLocator();
        }

        public SmartIndentProvider getSmartIndentProvider() {
            return this._origLangSupport.getSmartIndentProvider();
        }
    }

    private class PLSQLDocRendererWithClickableErrorSupport
    implements DocumentRenderer {
        private DocumentRenderer _plsqlDocRenderer;
        private BasicDocument _doc;
        private HighlightLayer _highlightTopLayer;
        private HighlightLayer _highlightBottomLayer;
        private String clickableComponentStyle = null;

        PLSQLDocRendererWithClickableErrorSupport(DocumentRenderer documentRenderer, BasicDocument basicDocument) {
            this._doc = basicDocument;
            this._plsqlDocRenderer = documentRenderer;
        }

        public StyledFragmentsList renderLines(int n, int n2) {
            int n3;
            StyledFragmentsList styledFragmentsList = this._plsqlDocRenderer.renderLines(n, n2);
            StyledFragmentsList styledFragmentsList2 = new StyledFragmentsList();
            int n4 = 0;
            int n5 = 0;
            int n6 = Math.max(ERROR_LINE_MARKER.length(), ERROR_LINE_COL_MARKER.length());
            for (n3 = n; n3 <= n2; ++n3) {
                n4 = ClickableScriptErrorPlugin.this._scriptResultPane.getLineStartOffset(n3);
                n5 = ClickableScriptErrorPlugin.this._scriptResultPane.getLineEndOffset(n3);
                try {
                    BasicDocument basicDocument = (BasicDocument)ClickableScriptErrorPlugin.this._scriptResultPane.getDocument();
                    assert (basicDocument.getLength() >= n4);
                    int n7 = Math.min(n6, basicDocument.getLength() - n4);
                    String string = basicDocument.getText(n4, n7);
                    if (string.startsWith(ERROR_LINE_MARKER) || string.startsWith(ERROR_LINE_COL_MARKER)) {
                        if (n4 > ClickableScriptErrorPlugin.this._lastResultPaneOffset) {
                            styledFragmentsList2.add(ClickableScriptErrorPlugin.this.COMP_STYLE_INT_NAME, n4, n5);
                            String string2 = basicDocument.getText(n4, n5 - n4);
                            this.updatePositionCache(string2);
                            continue;
                        }
                        styledFragmentsList2.add("base-plain-style", n4, n5);
                        continue;
                    }
                    styledFragmentsList2.add("base-plain-style", n4, n5);
                    continue;
                }
                catch (Exception exception) {
                    Logger.warn(this.getClass(), (Throwable)exception);
                }
            }
            n3 = styledFragmentsList2.size();
            if (n3 > 0) {
                this.recycleFragmentsList(styledFragmentsList);
                return styledFragmentsList2;
            }
            Logger.warn(this.getClass(), (String)"Internal error: renderLines created an empty style list - returning _plsqlDocRenderer delegate's list");
            return styledFragmentsList;
        }

        private void updatePositionCache(String string) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string2 = null;
            Position position = null;
            Object var7_7 = null;
            if (string != null && string.length() > 0) {
                ErrorDescriptor errorDescriptor = new ErrorDescriptor(string);
                n = errorDescriptor.getLine();
                n2 = errorDescriptor.getColNo();
                string2 = errorDescriptor.getFileName();
                try {
                    if (string2 == null) {
                        if (ClickableScriptErrorPlugin.this._defaultLinePosCache == null) {
                            ClickableScriptErrorPlugin.this._defaultLinePosCache = new HashMap();
                        }
                        if ((position = ClickableScriptErrorPlugin.this._defaultLinePosCache.get(n)) == null) {
                            n3 = ClickableScriptErrorPlugin.this._topEditor.getLineStartOffset(n);
                            position = ClickableScriptErrorPlugin.this._topEditor.getDocument().createPosition(n3 += n2);
                            ClickableScriptErrorPlugin.this._defaultLinePosCache.put(n, position);
                        }
                    } else {
                        HashMap<Integer, Position> hashMap;
                        if (ClickableScriptErrorPlugin.this._fileCache == null) {
                            ClickableScriptErrorPlugin.this._fileCache = new HashMap();
                        }
                        if ((hashMap = ClickableScriptErrorPlugin.this._fileCache.get(string2)) == null) {
                            hashMap = new HashMap();
                            ClickableScriptErrorPlugin.this._fileCache.put(string2, hashMap);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public void calculateDamage(DocumentEvent documentEvent, NumberRange numberRange) {
            this._plsqlDocRenderer.calculateDamage(documentEvent, numberRange);
        }

        public void notifyUpdate(DocumentEvent documentEvent) {
            this._plsqlDocRenderer.notifyUpdate(documentEvent);
        }

        public void recycleFragmentsList(StyledFragmentsList styledFragmentsList) {
            this._plsqlDocRenderer.recycleFragmentsList(styledFragmentsList);
        }
    }

    private class ErrorDescriptor {
        private int _lineNo = 0;
        private int _colNo = 0;
        private String _fileName = null;
        private boolean _hasError;

        ErrorDescriptor(String string) {
            StringTokenizer stringTokenizer = null;
            String string2 = null;
            int n = -1;
            int n2 = -1;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (string != null && !string.startsWith(ERROR_LINE_MARKER) && !string.startsWith(ERROR_LINE_COL_MARKER)) {
                return;
            }
            this._hasError = true;
            n2 = string.indexOf("@");
            if (n2 >= 0) {
                this._fileName = string.substring(n2 + 1).trim();
                string = string.substring(0, n2);
            }
            stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                n = string2.indexOf(":");
                if (n >= 0) {
                    string5 = string2.substring(n + 1);
                    if (string3 == null) {
                        string3 = string5 != null && string5.length() > 0 ? string5 : stringTokenizer.nextToken();
                    } else if (string4 == null && string.startsWith(ERROR_LINE_COL_MARKER)) {
                        string4 = string5 != null && string5.length() > 0 ? string5 : stringTokenizer.nextToken();
                        break;
                    }
                }
                string5 = null;
            }
            try {
                if (string3 != null) {
                    string3 = string3.replaceAll("[\\.\\,]", "");
                }
                this._lineNo = Integer.parseInt(string3) - 1;
                if (this._lineNo < 0) {
                    ++this._lineNo;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Internal Error: Bad lineNum is : " + string3);
            }
            if (string4 != null && string4.length() > 0) {
                try {
                    this._colNo = Integer.parseInt(string4) - 1;
                    if (this._colNo < 0) {
                        ++this._colNo;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal Error: Bad colNum is : " + string4);
                }
            }
        }

        public boolean hasError() {
            return this._hasError;
        }

        int getLine() {
            return this._lineNo;
        }

        int getColNo() {
            return this._colNo;
        }

        String getFileName() {
            return this._fileName;
        }
    }
}

