/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.sql.Connection;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorPanel;
import oracle.dbtools.worksheet.utils.CursorUI;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

abstract class SqlTuningAnalyzeAction
extends RaptorTask<Boolean> {
    protected WorksheetContext ctx;
    private String id = null;
    int cursorPosition = 0;
    int cursorStart = 0;
    int cursorEnd = 0;
    protected Connection conn;
    public static String connectionName = null;
    protected SqlTuningAdvisorPanel sqlTuningAdvisorPanel = null;

    public SqlTuningAnalyzeAction(String string, String string2, WorksheetContext worksheetContext) {
        super(string, true, IRaptorTaskRunMode.TASKVIEWER);
        this.id = string2;
        this.ctx = worksheetContext;
        this.setPausable(false);
        this.setCancellable(true);
        this.getConnectionName();
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public String getConnectionName() {
        connectionName = this.ctx.getConnectionName();
        return connectionName;
    }

    public SqlTuningAdvisorPanel getSqlTuningAdvisorPanel() {
        return this.sqlTuningAdvisorPanel;
    }

    public void setSqlTuningAdvisorPanel(SqlTuningAdvisorPanel sqlTuningAdvisorPanel) {
        this.sqlTuningAdvisorPanel = sqlTuningAdvisorPanel;
    }

    public final String[] extractSql(String string) {
        String string2 = this.getSqlStatement();
        this.cursorPosition = this.ctx.getEditor().getCaretPosition();
        this.cursorStart = this.ctx.getEditor().getSelectionStart();
        this.cursorEnd = this.ctx.getEditor().getSelectionEnd();
        BasicDocument basicDocument = (BasicDocument)this.ctx.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n = lineMap.getLineFromOffset(this.cursorPosition);
        ScriptParser scriptParser = new ScriptParser(string2, this.conn);
        scriptParser.parse();
        ISQLCommand[] iSQLCommandArray = scriptParser.getSqlStatements();
        String[] stringArray = new String[iSQLCommandArray.length];
        for (int i = 0; i < iSQLCommandArray.length; ++i) {
            stringArray[i] = iSQLCommandArray[i].getSql();
        }
        return stringArray;
    }

    private String getSqlStatement() {
        String string = this.ctx.getEditor().getSelectedText();
        if (string == null) {
            string = this.ctx.getEditor().getText();
        }
        return string;
    }

    public int[] getSelectionLineColumn() {
        int n = this.ctx.getEditor().getSelectionStart();
        BasicDocument basicDocument = (BasicDocument)this.ctx.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n) + 1;
        int n3 = lineMap.getLineStartOffset(n2 - 1);
        int n4 = n - n3 + 1;
        int[] nArray = new int[]{n2, n4};
        return nArray;
    }

    public boolean checkForSingleOrMultipleSqlStatements() {
        String[] stringArray = this.extractSql(null);
        if (stringArray.length == 1) {
            return false;
        }
        return stringArray.length > 1;
    }

    protected boolean init() {
        try {
            this.conn = Connections.getInstance().getConnection(this.ctx.getConnectionName());
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Throwable)dBException);
            return false;
        }
        return true;
    }

    protected void showResultPanel() {
        if (this.ctx != null) {
            this.ctx.getCallback().showResultPanel(this.sqlTuningAdvisorPanel);
        }
    }

    void resetCursor() {
        BasicEditorPane basicEditorPane = this.ctx.getEditor();
        SwingUtilities.invokeLater(new CursorUI(this.cursorPosition, this.cursorStart != this.cursorEnd, this.cursorStart, this.cursorEnd, basicEditorPane));
    }
}

