/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.dbtools.worksheet.commands.scriptrunner.task.StatementRunnerTask;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.DetailedInfoPanel;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.OverviewPanel;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisor;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorArb;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

public class SqlTuningAdvisorPanel
extends JPanel
implements WorksheetResultPanel,
TreeSelectionListener {
    protected int PIN_CMD_ID = 68;
    protected int NULL_CMD_ID = -123456;
    DBConfig conf = null;
    protected boolean m_isPinned = false;
    protected ToggleToolButton _pinToggle;
    private Icon _ranOkIcon;
    private Icon _tabIcon;
    Map<RaptorTaskDescriptor, ITaskUI> _descUIMap;
    JPanel _statusPanel;
    private JLabel _statusLabel;
    private final Icon _waitingIcon;
    private final Icon _runningIcon;
    private final Icon _problemIcon;
    private WorksheetState m_state;
    private String m_id;
    private String m_tabName;
    public SqlTuningAdvisor m_sqlTuningAdvisor;
    private static final long serialVersionUID = 1L;
    public JTree m_jTree;
    public Property m_property;
    private Toolbar _toolbar;
    private JTabbedPane m_rootTabbedPane;
    private OverviewPanel m_overviewPanel;
    private DetailedInfoPanel m_detailedInfo;
    private String m_CurrentNodeSqlScript;
    protected int CLEAR_CMD_ID;
    private WorksheetContext m_ctx;
    static final TableCellRenderer cellRenderer = new CellRenderer();
    private Icon overlayIcon;
    public static final String ROOT_NODE = SqlTuningAdvisorArb.getString("ROOT_NODE_NAME");
    public static final String STATISTICS = SqlTuningAdvisorArb.getString("STATISTICS_NODE_NAME");
    public static final String SQL_PROFILES = SqlTuningAdvisorArb.getString("SQL_PROFILE_NODE_NAME");
    public static final String INDEX = SqlTuningAdvisorArb.getString("INDEXES_NODE_NAME");
    public static final String SQL_RESTRUCTURE = SqlTuningAdvisorArb.getString("RESTRUCTURE_SQL_NODE_NAME");
    private DefaultMutableTreeNode m_currentNode;
    private static DefaultMutableTreeNode m_rootNode = new DefaultMutableTreeNode(ROOT_NODE);

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public WorksheetState getState() {
        return this.m_state;
    }

    @Override
    public String getTabLabel() {
        return this.m_tabName;
    }

    @Override
    public void setTabLabel(String string) {
        this.m_tabName = string;
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public void setState(WorksheetState worksheetState) {
        this.m_state = worksheetState;
    }

    public void tabClosed() {
    }

    public void setSqlTuningAdvisor(SqlTuningAdvisor sqlTuningAdvisor) {
        this.m_sqlTuningAdvisor = sqlTuningAdvisor;
    }

    public SqlTuningAdvisorPanel(String string, boolean bl) {
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.m_isPinned = this.conf.getBoolean("AUTOPIN_RESULTS_TABS");
        this._ranOkIcon = null;
        this._tabIcon = null;
        this._descUIMap = new HashMap<RaptorTaskDescriptor, ITaskUI>();
        this._statusPanel = new JPanel(new BorderLayout());
        this._statusLabel = new JLabel();
        this._waitingIcon = IImageRegistry.LIGHT_YELLOW;
        this._runningIcon = OracleIcons.getIcon((String)"throbber.gif");
        this._problemIcon = OracleIcons.getIcon((String)"exception.png");
        this.m_state = WorksheetState.CLOSED;
        this.m_id = null;
        this.m_sqlTuningAdvisor = null;
        this.m_property = new Property();
        this.m_CurrentNodeSqlScript = null;
        this.CLEAR_CMD_ID = 20;
        this.overlayIcon = null;
        this.m_currentNode = null;
        this.m_id = string;
        this.m_tabName = SqlTuningAdvisorArb.getString("SqlTuningAdvisorPanel_NAME");
        this.init();
        this.conf.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    private void init() {
        this.setupIcons();
        JScrollPane jScrollPane = this.createTreeNodesPane();
        this.createTabbedPane();
        JTabbedPane jTabbedPane = this.m_rootTabbedPane;
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jTabbedPane);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jTabbedPane);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(3);
        if (SerializedData.getInstance().getDividerLocation() > 300) {
            jSplitPane.setDividerLocation(160);
        } else {
            jSplitPane.setDividerLocation(SerializedData.getInstance().getDividerLocation());
        }
        this.repaint();
        jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SerializedData serializedData;
                int n;
                JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
                int n2 = jSplitPane.getDividerLocation();
                if (Math.abs(n2 - (n = (serializedData = SerializedData.getInstance()).getDividerLocation())) > 10) {
                    serializedData.setDividerLocation(n2);
                }
                SerializedData.write();
            }
        });
        this.add((Component)jSplitPane, "Center");
        if (this.m_id != null) {
            this.initToolbar();
        }
        this.repaint();
    }

    private void setupIcons() {
        this._ranOkIcon = this.getBaseIcon();
        this._tabIcon = this.getWaitingIcon();
    }

    private JScrollPane createTreeNodesPane() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(STATISTICS);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(SQL_PROFILES);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(INDEX);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(SQL_RESTRUCTURE);
        m_rootNode.removeAllChildren();
        m_rootNode.add(defaultMutableTreeNode);
        m_rootNode.add(defaultMutableTreeNode2);
        m_rootNode.add(defaultMutableTreeNode3);
        m_rootNode.add(defaultMutableTreeNode4);
        this.m_jTree = new JTree(m_rootNode);
        this.m_jTree.setCellRenderer(new CustomCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.m_jTree);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.m_jTree.setShowsRootHandles(true);
        this.m_jTree.setRootVisible(true);
        this.m_jTree.getSelectionModel().setSelectionMode(1);
        Color color = this.m_jTree.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        this.m_jTree.addTreeSelectionListener(this);
        this.setLayout(new BorderLayout());
        return jScrollPane;
    }

    private void createTabbedPane() {
        this.m_rootTabbedPane = this.createRootTabbedPane();
    }

    private JTabbedPane createRootTabbedPane() {
        this.m_overviewPanel = new OverviewPanel(this);
        this.m_detailedInfo = new DetailedInfoPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(SqlTuningAdvisorArb.getString("TAB_NAME_OVERVIEW"), this.m_overviewPanel);
        jTabbedPane.addTab(SqlTuningAdvisorArb.getString("TAB_NAME_DETAIL"), this.m_detailedInfo);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_overviewPanel, "f1_sqltuningadvisor_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_detailedInfo, "f1_sqltuningadvisor_html");
        return jTabbedPane;
    }

    public Icon getWaitingIcon() {
        return this._waitingIcon;
    }

    public Icon getProblemIcon() {
        return this._problemIcon;
    }

    public void initializeSummaryData() {
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setOverviewRowData(this.m_sqlTuningAdvisor.getAllTableReport());
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(this.m_sqlTuningAdvisor.getSqlTuningCommon().getSelectedSQLScript());
        ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setText(this.m_sqlTuningAdvisor.getDetailedReport());
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).refresh();
        ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).refresh();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_jTree.getLastSelectedPathComponent();
        this.setCurrentNode(defaultMutableTreeNode);
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.toString().equals(ROOT_NODE)) {
            this.displayResult(ROOT_NODE);
        } else if (defaultMutableTreeNode.toString().equals(STATISTICS)) {
            this.displayResult(STATISTICS);
        } else if (defaultMutableTreeNode.toString().equals(SQL_PROFILES)) {
            this.displayResult(SQL_PROFILES);
        } else if (defaultMutableTreeNode.toString().equals(INDEX)) {
            this.displayResult(INDEX);
        } else if (defaultMutableTreeNode.toString().equals(SQL_RESTRUCTURE)) {
            this.displayResult(SQL_RESTRUCTURE);
        }
        this.m_rootTabbedPane.revalidate();
        this.m_rootTabbedPane.repaint();
    }

    private void hideDetailedTabbedPanel() {
        if (this.m_rootTabbedPane.getTabCount() == 2) {
            this.m_rootTabbedPane.remove(this.m_rootTabbedPane.getComponentAt(1));
        }
    }

    private void setCurrentNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.m_currentNode = defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getCurrentNode() {
        return this.m_currentNode;
    }

    public void displayResult(String string) {
        ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setEditable(true);
        if (string.equals(ROOT_NODE)) {
            this.displaySqlScript(ROOT_NODE);
            this.executeSqlScriptForNode(ROOT_NODE);
            ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setOverviewRowData(this.m_sqlTuningAdvisor.getAllTableReport());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setText(this.m_sqlTuningAdvisor.getDetailedReport());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).refresh();
        } else if (string.equals(STATISTICS)) {
            this.displaySqlScript(STATISTICS);
            this.executeSqlScriptForNode(STATISTICS);
            ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setOverviewRowData(this.m_sqlTuningAdvisor.getSqlTuningAdvisorStatisticsReportArray());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setText(this.m_sqlTuningAdvisor.getSqlTuningReport().getStatisticsDetailedReport());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).refresh();
        } else if (string.equals(INDEX)) {
            this.displaySqlScript(INDEX);
            this.executeSqlScriptForNode(INDEX);
            ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setOverviewRowData(this.m_sqlTuningAdvisor.getSqlTuningAdvisorIndexesReportArray());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setText(this.m_sqlTuningAdvisor.getSqlTuningReport().getIndexDetailedReport());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).refresh();
        } else if (string.equals(SQL_PROFILES)) {
            this.displaySqlScript(SQL_PROFILES);
            this.executeSqlScriptForNode(SQL_PROFILES);
            ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setOverviewRowData(this.m_sqlTuningAdvisor.getSqlTuningAdvisorProfilesReportArray());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setText(this.m_sqlTuningAdvisor.getSqlTuningReport().getSqlProfileDetailedReport());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).refresh();
        } else if (string.equals(SQL_RESTRUCTURE)) {
            this.displaySqlScript(SQL_RESTRUCTURE);
            this.executeSqlScriptForNode(SQL_RESTRUCTURE);
            ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setOverviewRowData(this.m_sqlTuningAdvisor.getSqlTuningAdvisorRestructuresSQLReportArray());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).getDetailedInfoArea().setText(this.m_sqlTuningAdvisor.getSqlTuningReport().getRestructureSqlDetailedReport());
            ((DetailedInfoPanel)this.m_rootTabbedPane.getComponentAt(1)).refresh();
        }
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).refresh();
        this.m_rootTabbedPane.revalidate();
        this.m_rootTabbedPane.repaint();
    }

    private void displaySqlScript_OLD(String string) {
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setEditable(true);
        if (string.equals(ROOT_NODE)) {
            ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(this.m_sqlTuningAdvisor.getSqlTuningCommon().getSelectedSQLScript());
        } else if (string.equals(STATISTICS)) {
            String string2 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorStatisticsSqlScript());
            if (this.checkForCorrectScript(string2)) {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(string2);
            } else {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(null);
            }
        } else if (string.equals(INDEX)) {
            String string3 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorIndexesSqlScript());
            if (this.checkForCorrectScript(string3)) {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(string3);
            } else {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(null);
            }
        } else if (string.equals(SQL_PROFILES)) {
            String string4 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorProfilesSqlScript());
            if (this.checkForCorrectScript(string4)) {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(string4);
            } else {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(null);
            }
        } else if (string.equals(SQL_RESTRUCTURE)) {
            String string5 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorRestructureSqlScript());
            if (this.checkForCorrectScript(string5)) {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(string5);
            } else {
                ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(null);
            }
        }
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).refresh();
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getOverviewSQLPanel().repaint();
        this.m_rootTabbedPane.revalidate();
        this.m_rootTabbedPane.repaint();
    }

    private void displaySqlScript(String string) {
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setEditable(true);
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea().setText(this.m_sqlTuningAdvisor.getSqlTuningCommon().getSelectedSQLScript());
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).refresh();
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getOverviewSQLPanel().repaint();
        this.m_rootTabbedPane.revalidate();
        this.m_rootTabbedPane.repaint();
    }

    private void executeSqlScriptForNode(String string) {
        if (string.equals(ROOT_NODE)) {
            String string2 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorAllSqlScripts());
            if (this.checkForCorrectScript(string2)) {
                this.setCurrentNodeSqlScript(string2);
                this.setIconsVisible(true);
            } else {
                this.setCurrentNodeSqlScript(null);
                this.setIconsVisible(false);
            }
        } else if (string.equals(STATISTICS)) {
            String string3 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorStatisticsSqlScript());
            if (this.checkForCorrectScript(string3)) {
                this.setCurrentNodeSqlScript(string3);
                this.setIconsVisible(true);
            } else {
                this.setCurrentNodeSqlScript(null);
                this.setIconsVisible(false);
            }
        } else if (string.equals(INDEX)) {
            String string4 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorIndexesSqlScript());
            if (this.checkForCorrectScript(string4)) {
                this.setCurrentNodeSqlScript(string4);
                this.setIconsVisible(true);
            } else {
                this.setCurrentNodeSqlScript(null);
                this.setIconsVisible(false);
            }
        } else if (string.equals(SQL_PROFILES)) {
            String string5 = this.convertArrayListToString(this.m_sqlTuningAdvisor.getSqlTuningAdvisorProfilesSqlScript());
            if (this.checkForCorrectScript(string5)) {
                this.setCurrentNodeSqlScript(string5);
                this.setIconsVisible(true);
            } else {
                this.setCurrentNodeSqlScript(null);
                this.setIconsVisible(false);
            }
        } else if (string.equals(SQL_RESTRUCTURE)) {
            this.setCurrentNodeSqlScript(null);
            this.setIconsVisible(false);
        }
    }

    public void setIconsVisible(boolean bl) {
        ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).setIconsVisible(bl);
    }

    public boolean checkForCorrectScript(String string) {
        if (string != null) {
            return !string.startsWith("\nThere are") && !string.equals("");
        }
        return false;
    }

    public void setCurrentNodeSqlScript(String string) {
        this.m_CurrentNodeSqlScript = string;
    }

    public String getCurrentNodeSqlScript() {
        return this.m_CurrentNodeSqlScript;
    }

    private String convertArrayListToString(ArrayList<String> arrayList) {
        Object object = "";
        if (arrayList != null) {
            Object[] objectArray = arrayList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                object = (String)object + "\n" + objectArray[i];
            }
        }
        return object;
    }

    public JTree getTree() {
        return this.m_jTree;
    }

    private void initToolbar() {
        this._toolbar = new Toolbar();
        this.add((Component)this._toolbar, "North");
        if (this.PIN_CMD_ID != this.NULL_CMD_ID && this.isCloseable()) {
            Icon icon = this.m_isPinned ? RaptorImagesArb.getIcon((String)"PINNED") : OracleIcons.getIcon((String)"pin.png");
            ToggleAction toggleAction = new ToggleAction(Messages.getString("AbstractWorksheetResultPanel.1"), icon){

                public void actionPerformed(ActionEvent actionEvent) {
                    Icon icon = SqlTuningAdvisorPanel.this.m_isPinned ? OracleIcons.getIcon((String)"pin.png") : RaptorImagesArb.getIcon((String)"PINNED");
                    SqlTuningAdvisorPanel.this._pinToggle.setIcon(icon);
                    SqlTuningAdvisorPanel.this.m_isPinned = !SqlTuningAdvisorPanel.this.m_isPinned;
                }
            };
            toggleAction.setName(toggleAction.getValue("Name").toString());
            this._pinToggle = this._toolbar.addToggleButton(toggleAction);
            toggleAction.setState(this.isPinned());
            this._pinToggle.setIcon(icon);
        }
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this._statusPanel.setOpaque(false);
        this._statusLabel.setOpaque(false);
        this._toolbar.add((Component)this._statusPanel);
    }

    public BasicEditorPane getEditor() {
        return ((OverviewPanel)this.m_rootTabbedPane.getComponentAt(0)).getSqlScriptCodeArea();
    }

    public void clear() {
    }

    private Icon getBaseIcon() {
        return StatementRunnerTask.STATEMENTSCRIPTRUNNER_TASKNAME == this.m_id ? OracleIcons.getIcon((String)"run.png") : RaptorImage.getIcon((String)WorksheetResources.get("RUN_SCRIPT_ICON"));
    }

    public static boolean showMyStat() {
        return true;
    }

    @Override
    public boolean isPinned() {
        return this.m_isPinned;
    }

    @Override
    public void setPinned(boolean bl) {
        if (this._pinToggle.isSelected() && !bl) {
            this._pinToggle.doClick();
        } else if (!this._pinToggle.isSelected() && bl) {
            this._pinToggle.doClick();
        }
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public String getTabToolTip() {
        return this.getTabLabel();
    }

    public String getLastStatusMessage() {
        return null;
    }

    public void publishStatusMessage(String string, Exception exception) {
    }

    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
    }

    public void setStatusMessage(String string, Exception exception) {
    }

    @Override
    public WorksheetContext getContext() {
        return this.m_ctx;
    }

    @Override
    public void setContext(WorksheetContext worksheetContext) {
        this.m_ctx = worksheetContext;
    }

    @Override
    public Icon getTabIcon() {
        if (this.overlayIcon != null) {
            return this.overlayIcon;
        }
        return RaptorImage.getIcon((String)RaptorImagesArb.getString((String)"SQL_TUNING_ADVISOR"));
    }

    public void setOverlayIcon(Icon icon) {
        this.overlayIcon = icon;
    }

    @Override
    public JMenuItem[] getTabDynamicCtxMenu(WorksheetResultPanel[] worksheetResultPanelArray) {
        return new JMenuItem[0];
    }

    protected void cmp(WorksheetResultPanel worksheetResultPanel) {
    }

    public class CustomCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Icon sqlProfileIcon = new ImageIcon(this.getClass().getClassLoader().getResource(SqlTuningAdvisorArb.getString("SQLPROFILE_FOLDER_ICON")));
        private Icon indexesIcon = new ImageIcon(this.getClass().getClassLoader().getResource(SqlTuningAdvisorArb.getString("INDEXES_FOLDER_ICON")));
        private Icon sqlRestructIcon = new ImageIcon(this.getClass().getClassLoader().getResource(SqlTuningAdvisorArb.getString("SQLRESTRUCT_FOLDER_ICON")));
        private Icon sqlRootFolderIcon = new ImageIcon(this.getClass().getClassLoader().getResource(SqlTuningAdvisorArb.getString("SQLROOT_FOLDER_ICON")));
        private Icon statisticsIcon = new ImageIcon(this.getClass().getClassLoader().getResource(SqlTuningAdvisorArb.getString("STATISTICS_FOLDER_ICON")));
        private boolean bSelected;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            String string = (String)defaultMutableTreeNode.getUserObject();
            this.bSelected = bl;
            if (!bl) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.white);
            }
            if (string.equals(ROOT_NODE)) {
                this.setIcon(this.sqlRootFolderIcon);
            } else if (string.equals(SQL_PROFILES)) {
                this.setIcon(this.sqlProfileIcon);
            } else if (string.equals(SQL_RESTRUCTURE)) {
                this.setIcon(this.sqlRestructIcon);
            } else if (string.equals(INDEX)) {
                this.setIcon(this.indexesIcon);
            } else if (string.equals(STATISTICS)) {
                this.setIcon(this.statisticsIcon);
            }
            this.setText(string);
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            Icon icon = this.getIcon();
            Color color = this.bSelected ? SystemColor.textHighlight : Color.white;
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            super.paint(graphics);
        }
    }

    public final class ResultsPanelTaskListener
    extends RaptorTaskAdapter {
        SqlTuningAdvisorPanel panel;

        public ResultsPanelTaskListener() {
            this.panel = this.panel;
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            SqlTuningAdvisorPanel.this.setOverlayIcon(SqlTuningAdvisorPanel.this._waitingIcon);
        }

        public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
            SqlTuningAdvisorPanel.this.setOverlayIcon(SqlTuningAdvisorPanel.this._runningIcon);
        }

        public void taskPaused(RaptorTaskEvent raptorTaskEvent) {
            SqlTuningAdvisorPanel.this.setOverlayIcon(SqlTuningAdvisorPanel.this._waitingIcon);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                this.showError(raptorTaskEvent);
            } else {
                SqlTuningAdvisorPanel.this.setOverlayIcon(null);
                this.removeTask(raptorTaskEvent);
            }
        }

        private void showError(RaptorTaskEvent raptorTaskEvent) {
            SqlTuningAdvisorPanel.this.setOverlayIcon(SqlTuningAdvisorPanel.this._problemIcon);
            this.removeTask(raptorTaskEvent);
        }

        private void removeTask(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JPanel jPanel = SqlTuningAdvisorPanel.this._statusPanel;
                    synchronized (jPanel) {
                        RaptorTaskDescriptor raptorTaskDescriptor = raptorTaskEvent.getTaskDescriptor();
                        if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTaskDescriptor.getStatus())) {
                            SqlTuningAdvisorPanel.this._descUIMap.remove(raptorTaskDescriptor);
                            SqlTuningAdvisorPanel.this._statusPanel.add(Box.createHorizontalStrut(5));
                            SqlTuningAdvisorPanel.this._statusPanel.add(SqlTuningAdvisorPanel.this._statusLabel);
                            this.updateTimer(raptorTaskEvent.getTaskDescriptor().getElapsedTime());
                            SqlTuningAdvisorPanel.this._toolbar.revalidate();
                            SqlTuningAdvisorPanel.this._toolbar.repaint();
                        }
                    }
                }

                private void updateTimer(long l) {
                    float f = 0.0f;
                    if (l > 0L) {
                        f = Float.parseFloat("" + l) / 1000.0f;
                    }
                    Object[] objectArray = new Object[]{new Float(f)};
                    String string = MessageFormat.format(Messages.getString("Worksheet.4"), objectArray);
                    SqlTuningAdvisorPanel.this._statusLabel.setText(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class CellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        CellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setMargin(new Insets(0, 5, 0, 5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            this.setSize(jTable.getColumnModel().getColumn(n2).getWidth(), this.getPreferredSize().height);
            if (jTable.getRowHeight(n) != this.getPreferredSize().height) {
                jTable.setRowHeight(n, this.getPreferredSize().height);
            }
            return this;
        }
    }

    public static final class Property
    extends AbstractTableModel {
        public Map<Integer, String> names = new HashMap<Integer, String>();
        public Map<Integer, Long> values = new HashMap<Integer, Long>();

        public void reset() {
            this.names = new HashMap<Integer, String>();
            this.values = new HashMap<Integer, Long>();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "SQL Tuning Implementation ";
            }
            return "SQL Execution Script";
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return this.values.get(n);
            }
            return this.names.get(n);
        }
    }

    private class ColumnsListener
    implements PropertyChangeListener {
        private ColumnsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
            Object object = tableColumn.getHeaderValue();
            int n = tableColumn.getWidth();
            SerializedData serializedData = SerializedData.getInstance();
            Integer n2 = serializedData.getColumnWidths().get(object);
            if (n2 == null || Math.abs(n - n2) > 10) {
                serializedData.getColumnWidths().put(object, n);
            }
            SerializedData.write();
        }
    }
}

