/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.dbmsoutput;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOwaOutputTabWindow;

public class TabbedPaneCloseComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JTabbedPane m_pane;
    private final DbmsOwaOutputTabWindow m_window;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    };

    public TabbedPaneCloseComponent(final JTabbedPane jTabbedPane, DbmsOwaOutputTabWindow dbmsOwaOutputTabWindow) {
        super(new FlowLayout(0, 0, 0));
        this.m_window = dbmsOwaOutputTabWindow;
        if (jTabbedPane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.m_pane = jTabbedPane;
        this.setOpaque(false);
        JLabel jLabel = new JLabel(){

            @Override
            public String getText() {
                int n = jTabbedPane.indexOfTabComponent(TabbedPaneCloseComponent.this);
                if (n != -1) {
                    return jTabbedPane.getTitleAt(n);
                }
                return null;
            }
        };
        this.add(jLabel);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton tabButton = new TabButton();
        this.add(tabButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public TabButton() {
            int n = 17;
            this.setPreferredSize(new Dimension(n, n));
            this.setToolTipText(Messages.getString("TabbedPaneCloseComponent.1"));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = TabbedPaneCloseComponent.this.m_pane.indexOfTabComponent(TabbedPaneCloseComponent.this);
            if (n != -1) {
                Connection connection = TabbedPaneCloseComponent.this.m_window.getKeyForTab(TabbedPaneCloseComponent.this.m_pane.getComponentAt(n));
                TabbedPaneCloseComponent.this.m_window.removeTab(connection, n);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.getModel().isPressed()) {
                graphics2D.translate(1, 1);
            }
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                graphics2D.setColor(Color.RED);
            }
            int n = 6;
            graphics2D.drawLine(n, n, this.getWidth() - n - 1, this.getHeight() - n - 1);
            graphics2D.drawLine(this.getWidth() - n - 1, n, n, this.getHeight() - n - 1);
            graphics2D.dispose();
        }
    }
}

