/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.dbmsoutput;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.ide.Ide;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;

public final class DbmsOutputPane
extends AbstractOutputPane {
    private static final long serialVersionUID = 1L;
    protected static final int TOGGLE_CMD_ID = Ide.createCmdID((String)"dbmsoutput.toggle");
    protected static final int POLL_CMD_ID = Ide.createCmdID((String)"dbmsoutput.poll");
    private JTextField bufferSize;
    private int previousValue = 20000;
    private boolean buffUnlimited = false;
    private Connection localConn;
    private static DbmsOutputPane _dbmsPaneInstance = null;

    public DbmsOutputPane(View view) {
        super(view);
    }

    public static AbstractOutputPane getInstance(View view) {
        if (_dbmsPaneInstance == null) {
            _dbmsPaneInstance = new DbmsOutputPane(view);
        }
        return _dbmsPaneInstance;
    }

    public static DbmsOutputPane getInstance() {
        return _dbmsPaneInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean enableOutput(Connection connection, boolean bl) {
        String string = this.getBufferSizeText();
        Object object = null;
        this.localConn = connection;
        try {
            Integer.parseInt(string);
            object = "BEGIN DBMS_OUTPUT.ENABLE(" + string + "); END;";
        }
        catch (NumberFormatException numberFormatException) {
            if (this.buffUnlimited) {
                object = "BEGIN \n";
                object = (String)object + " IF NOT DBMS_DB_VERSION.VER_LE_10_1 THEN\n";
                object = (String)object + "   DBMS_OUTPUT.ENABLE(NULL);\n";
                object = (String)object + " ELSE\n";
                object = (String)object + "   DBMS_OUTPUT.ENABLE(1000000);\n";
                object = (String)object + " END IF;\n";
                object = (String)object + "END;";
            }
            object = "BEGIN DBMS_OUTPUT.ENABLE(1000000); END;";
            this.bufferSize.setText("1000000");
        }
        Statement statement = null;
        try {
            String string2 = "";
            if (connection == null) {
                string2 = ConnectionSelectorUI.getConnectionForDbms((String)ControlsArb.getString((String)"TITLE_CONNECTION"), (String)ControlsArb.getString((String)"MESSAGE_CONNECTION_PROMPT"), (String)string2, (boolean)true);
                connection = Connections.getInstance().getConnection(string2);
                if (!this.isEnabled(connection)) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            if (connection.isClosed() && bl) {
                string2 = ConnectionSelectorUI.getConnectionForDbms((String)ControlsArb.getString((String)"TITLE_CONNECTION"), (String)ControlsArb.getString((String)"MESSAGE_CONNECTION_PROMPT"), (String)string2, (boolean)true);
                connection = Connections.getInstance().getConnection(string2);
                if (!this.isEnabled(connection)) {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            statement = connection.prepareCall((String)object);
            statement.execute();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.revalidate();
        this.repaint();
        m_connEnableHash.put(this.ConnectionNameOrToString(connection), true);
        return (Boolean)m_connEnableHash.get(this.ConnectionNameOrToString(connection));
    }

    @Override
    public String getBufferSizeText() {
        return this.bufferSize.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disableOutput(Connection connection) {
        if (connection == null) {
            return true;
        }
        if (this.isEnabled(connection)) {
            String string = "BEGIN DBMS_OUTPUT.DISABLE(); END;";
            Statement statement = null;
            try {
                if (connection.isClosed()) {
                    m_connEnableHash.put(this.ConnectionNameOrToString(connection), false);
                    boolean bl = true;
                    return bl;
                }
                statement = connection.prepareCall(string);
                statement.execute();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            m_connEnableHash.put(this.ConnectionNameOrToString(connection), false);
            return true;
        }
        return false;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this._toolbar.addSeparator();
        JLabel jLabel = new JLabel(Messages.getString("DbmsOutputPane.13"));
        this._toolbar.add((Component)jLabel);
        this.bufferSize = new JTextField();
        this.bufferSize.setColumns(6);
        this.bufferSize.setText("20000");
        this.bufferSize.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == 'u') {
                    DbmsOutputPane.this.bufferSize.setText(Messages.getString("DbmsOutputPane.15"));
                    DbmsOutputPane.this.buffUnlimited = true;
                    keyEvent.consume();
                } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    DbmsOutputPane.this.getToolkit().beep();
                    keyEvent.consume();
                } else {
                    DbmsOutputPane.this.buffUnlimited = false;
                }
            }
        });
        this.bufferSize.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                int n = 20000;
                try {
                    n = Integer.parseInt(DbmsOutputPane.this.bufferSize.getText());
                    if (n < 2000) {
                        n = 2000;
                    }
                    if (n > 1000000) {
                        n = 1000000;
                    }
                    DbmsOutputPane.this.bufferSize.setText(String.valueOf(n));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (DbmsOutputPane.this.localConn != null) {
                    DbmsOutputPane.this.disableOutput(DbmsOutputPane.this.localConn);
                    DbmsOutputPane.this.enableOutput(DbmsOutputPane.this.localConn, true);
                }
                try {
                    if (DbmsOutputPane.this.previousValue != n && DbmsOutputPane.this.getTextPanelArea() != null) {
                        DbmsOutputPane.this.getTextPanelArea().getDocument().insertString(DbmsOutputPane.this.getTextPanelArea().getDocument().getLength(), MessageFormat.format(Messages.getString("DbmsOutputPane.1"), DbmsOutputPane.this.bufferSize.getText()), null);
                    }
                    try {
                        DbmsOutputPane.this.previousValue = Integer.parseInt(DbmsOutputPane.this.bufferSize.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        DbmsOutputPane.this.previousValue = -1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.bufferSize.setMaximumSize(new Dimension(20, 20));
        this._toolbar.add((Component)this.bufferSize);
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalGlue());
    }

    @Override
    public String getPaneName() {
        return Messages.getString("DbmsOutputPane.64") + " " + Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this.getCurrentConnection()));
    }

    @Override
    protected String getNewLabel() {
        return Messages.getString("DbmsOutputPane.99");
    }
}

