/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.SqlLocator;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeNode;
import oracle.dbtools.worksheet.commands.autotrace.Hint;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;

public class PopupAction
extends MouseAdapter {
    public JTreeTable tbl;
    AutotraceTreeModel mdl;
    public JTreeTable tbl2 = null;
    AutotraceTreeModel md2 = null;
    Point mousePos = null;

    public PopupAction(JTreeTable jTreeTable, AutotraceTreeModel autotraceTreeModel) {
        this.tbl = jTreeTable;
        this.mdl = autotraceTreeModel;
    }

    public PopupAction(JTreeTable jTreeTable, AutotraceTreeModel autotraceTreeModel, JTreeTable jTreeTable2, AutotraceTreeModel autotraceTreeModel2) {
        this.tbl = jTreeTable;
        this.mdl = autotraceTreeModel;
        this.tbl2 = jTreeTable2;
        this.md2 = autotraceTreeModel2;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
        this.collapseExpand(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePos = this.tbl.getMousePosition();
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void collapseExpand(MouseEvent mouseEvent) {
        TreePath treePath;
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        JTree jTree = this.tbl.getTree();
        if (mouseEvent.getSource() == this.tbl2) {
            jTree = this.tbl2.getTree();
        }
        if (jTree.isCollapsed(treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()))) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
        this.tbl.revalidate();
        if (this.tbl2 != null) {
            this.tbl2.revalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.6"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SerializedData serializedData = SerializedData.getInstance();
                serializedData.collapsePredNodes = false;
                SerializedData.write();
                PopupAction.this.expandPredicates();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("Expand_All"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupAction.this.expandAll();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.7"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SerializedData serializedData = SerializedData.getInstance();
                serializedData.collapsePredNodes = true;
                SerializedData.write();
                PopupAction.this.collapsePredicates();
            }
        });
        if (this.tbl2 == null) {
            jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.8"), OracleIcons.getIcon((String)"collapseall.png"));
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PopupAction.this.mousePos != null) {
                        JTree jTree = PopupAction.this.tbl.getTree();
                        TreePath treePath = jTree.getClosestPathForLocation(PopupAction.this.mousePos.x, PopupAction.this.mousePos.y);
                        int n = jTree.getRowForPath(treePath);
                        TreePath treePath2 = treePath.getParentPath();
                        int n2 = jTree.getRowForPath(treePath2);
                        for (int i = n - 1; n2 < i; --i) {
                            TreePath treePath3 = jTree.getPathForRow(i);
                            if (treePath3.getPathCount() != treePath.getPathCount()) continue;
                            jTree.collapsePath(treePath3);
                        }
                    }
                }
            });
        }
        jMenuItem = new JMenuItem(Messages.getString("Export"), null);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupAction.this.export();
            }
        });
        if (this.mousePos != null) {
            JTree jTree = this.tbl.getTree();
            Object[] objectArray = jTree.getClosestPathForLocation(this.mousePos.x, this.mousePos.y).getPath();
            if (objectArray.length == 0) {
                return jPopupMenu;
            }
            RowSrcNode rowSrcNode = (RowSrcNode)objectArray[objectArray.length - 1];
            if (rowSrcNode instanceof AutotraceTreeNode) {
                AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)rowSrcNode;
                if (autotraceTreeNode.toString().startsWith("TABLE ACCESS")) {
                    Object object;
                    String[] stringArray;
                    final BasicEditorPane basicEditorPane = this.mdl.src.getContext().getEditor();
                    final String string = this.mdl.src.getContext().getParser().text;
                    int n = basicEditorPane.getCaretPosition();
                    final String string2 = SqlLocator.extractStmt((int)n, (String)string, null);
                    final List list = LexerToken.parse((String)string2);
                    List<String> list2 = this.indexHints(autotraceTreeNode.objectName, autotraceTreeNode.getValue("OBJECT_ALIAS"));
                    if (0 < list2.size() && (stringArray = this.suggestFull(list2.get(0))).length == 1) {
                        list2.add(stringArray[0]);
                    }
                    if ((object = this.matchingHint((String)(stringArray = autotraceTreeNode.getValue("OBJECT_ALIAS")), new String[]{"LEADING("})) != null) {
                        String[] stringArray2;
                        object = "/*+ " + (String)object + " */";
                        list2.add((String)object);
                        for (String string3 : stringArray2 = this.permuteElement((String)object, this.sugarcoatObjAlias((String)stringArray))) {
                            if (list2.contains(string3)) continue;
                            list2.add(string3);
                        }
                    }
                    for (String string4 : list2) {
                        final JMenuItem jMenuItem2 = new JMenuItem(string4, OracleIcons.getIcon((String)"lightbulb.png"));
                        jPopupMenu.add(jMenuItem2);
                        jMenuItem2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                PopupAction.this.editText(basicEditorPane, string, string2, list, jMenuItem2);
                            }
                        });
                    }
                    return jPopupMenu;
                }
                if (autotraceTreeNode.toString().startsWith("INDEX")) {
                    String[] stringArray;
                    final BasicEditorPane basicEditorPane = this.mdl.src.getContext().getEditor();
                    final String string = this.mdl.src.getContext().getParser().text;
                    int n = basicEditorPane.getCaretPosition();
                    final String string4 = SqlLocator.extractStmt((int)n, (String)string, null);
                    final List list = LexerToken.parse((String)string4);
                    String string5 = null;
                    AutotraceTreeNode autotraceTreeNode2 = (AutotraceTreeNode)autotraceTreeNode.getParent();
                    if (autotraceTreeNode2.toString().startsWith("TABLE ACCESS")) {
                        string5 = autotraceTreeNode2.objectName;
                    } else {
                        string5 = autotraceTreeNode.getValue("OBJECT_ALIAS");
                        int n2 = string5.indexOf(64);
                        string5 = string5.substring(0, n2);
                    }
                    List<String> list3 = this.indexHints(string5, autotraceTreeNode.getValue("OBJECT_ALIAS"));
                    if (0 < list3.size() && (stringArray = this.suggestFull(list3.get(0))).length == 1) {
                        list3.add(stringArray[0]);
                    }
                    for (String string6 : list3) {
                        final JMenuItem jMenuItem3 = new JMenuItem(string6, OracleIcons.getIcon((String)"lightbulb.png"));
                        jPopupMenu.add(jMenuItem3);
                        jMenuItem3.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                PopupAction.this.editText(basicEditorPane, string, string4, list, jMenuItem3);
                            }
                        });
                    }
                    return jPopupMenu;
                }
                if ("{hint}".equals(autotraceTreeNode.toString())) {
                    final BasicEditorPane basicEditorPane = this.mdl.src.getContext().getEditor();
                    final String string = this.mdl.src.getContext().getParser().text;
                    int n = basicEditorPane.getCaretPosition();
                    final String string7 = SqlLocator.extractStmt((int)n, (String)string, null);
                    final List list = LexerToken.parse((String)string7);
                    final StringBuilder stringBuilder = new StringBuilder(" /*+ ");
                    for (int i = 0; i < autotraceTreeNode.getChildCount(); ++i) {
                        AutotraceTreeNode autotraceTreeNode3 = (AutotraceTreeNode)autotraceTreeNode.getChildAt(i);
                        stringBuilder.append(autotraceTreeNode3.toString());
                        stringBuilder.append("\n       ");
                    }
                    stringBuilder.append("*/");
                    JMenuItem jMenuItem4 = new JMenuItem("/*+ copy all hints */", OracleIcons.getIcon((String)"lightbulb.png"));
                    jPopupMenu.add(jMenuItem4);
                    jMenuItem4.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            PopupAction.this.replaceText(basicEditorPane, string, string7, list, stringBuilder.toString());
                        }
                    });
                    return jPopupMenu;
                }
                if (autotraceTreeNode.isHint || autotraceTreeNode.joinMethodRgtChildAlias() != null) {
                    void var16_51;
                    String[] stringArray;
                    final BasicEditorPane basicEditorPane = this.mdl.src.getContext().getEditor();
                    final String string = this.mdl.src.getContext().getParser().text;
                    int n = basicEditorPane.getCaretPosition();
                    final String string8 = SqlLocator.extractStmt((int)n, (String)string, null);
                    final List list = LexerToken.parse((String)string8);
                    String string9 = autotraceTreeNode.operation;
                    if (!autotraceTreeNode.isHint && (stringArray = autotraceTreeNode.joinMethodRgtChildAlias()) != null) {
                        String string10 = this.matchingHint((String)stringArray, new String[]{"USE_NL(", "USE_HASH(", "USE_MERGE("});
                        if (string10 == null) {
                            System.out.println("Didn't find join for " + (String)stringArray);
                            return jPopupMenu;
                        }
                        string9 = string10;
                    }
                    stringArray = new String[]{"/*+ " + string9 + " */"};
                    if (string9.startsWith("USE_NL(") || string9.startsWith("USE_HASH(") || string9.startsWith("USE_MERGE(")) {
                        stringArray = new String[3];
                        int n3 = string9.indexOf(40);
                        stringArray[0] = "/*+ USE_NL" + string9.substring(n3) + " */";
                        stringArray[1] = "/*+ USE_HASH" + string9.substring(n3) + " */";
                        stringArray[2] = "/*+ USE_MERGE" + string9.substring(n3) + " */";
                    }
                    if (string9.startsWith("LEADING(")) {
                        stringArray = this.permuteLeading("/*+ " + string9 + " */");
                    }
                    if (string9.startsWith("INDEX")) {
                        stringArray = this.suggestFull(string9);
                    }
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray2.length;
                    boolean bl = false;
                    while (var16_51 < n2) {
                        String string7 = stringArray2[var16_51];
                        final JMenuItem jMenuItem4 = new JMenuItem(string7, OracleIcons.getIcon((String)"lightbulb.png"));
                        jPopupMenu.add(jMenuItem4);
                        jMenuItem4.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                PopupAction.this.editText(basicEditorPane, string, string8, list, jMenuItem4);
                            }
                        });
                        ++var16_51;
                    }
                    return jPopupMenu;
                }
            }
        }
        return jPopupMenu;
    }

    private String[] permuteLeading(String string) {
        return this.permuteElement(string, null);
    }

    private String[] permuteElement(String string, String string2) {
        Hint hint = Hint.parse(string);
        int n = hint.elements.indexOf(string2);
        if (n < 0) {
            n = 0;
        }
        String[] stringArray = new String[hint.elements.size()];
        stringArray[0] = string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) continue;
            String string3 = "??tmp??";
            stringArray[i] = string.replace(hint.elements.get(i), string3).replace(hint.elements.get(n), hint.elements.get(i)).replace(string3, hint.elements.get(n));
        }
        return stringArray;
    }

    private String[] suggestFull(String string) {
        String string2;
        int n;
        Hint hint = Hint.parse(string);
        Iterator<String> iterator = hint.elements.iterator();
        if (iterator.hasNext() && (n = (string2 = iterator.next()).indexOf(64)) >= 0) {
            String string3 = string2.substring(0, n);
            if (hint.queryBlock == null) {
                hint.queryBlock = string2.substring(n);
            }
            return new String[]{"/*+ FULL(" + hint.queryBlock + " " + string3 + hint.queryBlock + ")*/"};
        }
        return new String[0];
    }

    private String sugarcoatObjAlias(String string) {
        if (string.charAt(0) == '\"') {
            return string;
        }
        int n = string.indexOf(64);
        if (n < 0) {
            throw new AssertionError((Object)(string + " missing @"));
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return "\"" + string2 + "\"@\"" + string3 + "\"";
    }

    private String matchingHint(String string, String[] stringArray) {
        AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)this.mdl.getRoot();
        return this.matchingHint(autotraceTreeNode, this.sugarcoatObjAlias(string), stringArray);
    }

    private String matchingHint(AutotraceTreeNode autotraceTreeNode, String string, String[] stringArray) {
        if (autotraceTreeNode.isHint) {
            String string2 = autotraceTreeNode.operation;
            for (String string3 : stringArray) {
                if (!string2.startsWith(string3) || !string2.contains(string)) continue;
                return string2;
            }
        }
        for (int i = 0; i < autotraceTreeNode.getChildCount(); ++i) {
            AutotraceTreeNode autotraceTreeNode2 = (AutotraceTreeNode)autotraceTreeNode.getChildAt(i);
            String string4 = this.matchingHint(autotraceTreeNode2, string, stringArray);
            if (string4 == null) continue;
            return string4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> indexHints(String string, String string2) {
        LinkedList<String> linkedList;
        block19: {
            if (string == null) {
                return new LinkedList<String>();
            }
            String string3 = this.mdl.src.getContext().getConnectionName();
            linkedList = new LinkedList<String>();
            ResultSet resultSet = null;
            try {
                Connection connection = Connections.getInstance().getConnection(string3);
                if (!LockManager.lock((Connection)connection)) break block19;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    String string4 = null;
                    String string5 = string;
                    if (0 < string.indexOf(46)) {
                        string5 = string.substring(string.indexOf(46) + 1);
                        linkedList2.add(string5);
                        string4 = string.substring(0, string.indexOf(46));
                        linkedList2.add(string4);
                    } else {
                        linkedList2.add(string5);
                    }
                    String string6 = "select index_name from all_indexes \nwhere table_name=:1 and table_owner=" + (string4 == null ? "user" : ":2");
                    resultSet = dBUtil.executeQuery(string6, linkedList2);
                    while (resultSet.next()) {
                        String string7 = resultSet.getString(1);
                        String string8 = "/*+ INDEX(" + string2 + " " + string7 + ") */";
                        linkedList.add(string8);
                    }
                }
                finally {
                    LockManager.unlock((Connection)connection);
                }
            }
            catch (Exception exception) {
                LinkedList<String> linkedList3 = linkedList;
                return linkedList3;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return linkedList;
    }

    private void collapsePredicates() {
        PopupAction.collapsePredicates(this.tbl);
        if (this.tbl2 != null) {
            PopupAction.collapsePredicates(this.tbl2);
        }
    }

    private static void collapsePredicates(JTreeTable jTreeTable) {
        JTree jTree = jTreeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
            if (!rowSrcNode.toString().endsWith("Predicates") && !rowSrcNode.toString().endsWith("Projection")) continue;
            jTree.collapsePath(treePath);
        }
        jTreeTable.revalidate();
    }

    private void expandPredicates() {
        PopupAction.expandPredicates(this.tbl);
        if (this.tbl2 != null) {
            PopupAction.expandPredicates(this.tbl2);
        }
    }

    private static void expandPredicates(JTreeTable jTreeTable) {
        JTree jTree = jTreeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            boolean bl = false;
            for (Object object : treePath.getPath()) {
                RowSrcNode rowSrcNode = (RowSrcNode)object;
                if (!rowSrcNode.toString().endsWith("Predicates") && !rowSrcNode.toString().endsWith("Projection")) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            jTree.expandPath(treePath);
        }
        jTreeTable.revalidate();
    }

    private void expandAll() {
        PopupAction.expandAll(this.tbl);
        if (this.tbl2 != null) {
            PopupAction.expandAll(this.tbl2);
        }
    }

    private static void expandAll(JTreeTable jTreeTable) {
        JTree jTree = jTreeTable.getTree();
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            jTree.expandPath(treePath);
        }
        jTreeTable.revalidate();
    }

    private void export() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        WildcardURLFilter wildcardURLFilter = new WildcardURLFilter("*.html", false, "HTML File");
        uRLFileChooser.addChooseableURLFilter((URLFilter)wildcardURLFilter);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), "Export HTML");
        if (n != 0) {
            return;
        }
        URL uRL = uRLFileChooser.getSelectedURL();
        Object object = uRL.getPath();
        int n2 = Math.max(((String)object).lastIndexOf(47), ((String)object).lastIndexOf(92));
        if (((String)object).lastIndexOf(46) <= n2) {
            object = (String)object + ".html";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((String)object);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            String string = IdeUtil.getIdeEncoding();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            if (this.mdl.cmp == null) {
                outputStreamWriter.write(this.mdl.createHtmlWidget(this.tbl.getTree()).render());
            } else {
                outputStreamWriter.write("<TABLE border=0 cellpadding=0 cellspacing=0 width=100%><tr><td> \n");
                outputStreamWriter.write(this.mdl.createHtmlWidget(this.tbl.getTree()).render());
                outputStreamWriter.write("</td><td> \n");
                outputStreamWriter.write(this.mdl.cmp.createHtmlWidget(this.tbl2.getTree()).render());
                outputStreamWriter.write("</td></tr></TABLE> \n");
            }
            outputStreamWriter.close();
            File file = new File((String)object);
            String string2 = file.getParent() + File.separatorChar + "images";
            System.out.println(string2);
            new File(string2).mkdir();
            ClassLoader classLoader = this.getClass().getClassLoader();
            for (URL uRL2 : FileUtils.getFilesInPackage((String)"oracle.dbtools.worksheet.images", (ClassLoader)classLoader, (String)"png")) {
                Service.copy((URL)uRL2, (String)string2);
            }
            for (URL uRL2 : FileUtils.getFilesInPackage((String)"oracle.dbtools.worksheet.images", (ClassLoader)classLoader, (String)"gif")) {
                Service.copy((URL)uRL2, (String)string2);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private void editText(BasicEditorPane basicEditorPane, String string, String string2, List<LexerToken> list, JMenuItem jMenuItem) {
        int n;
        Object object;
        Iterator<LexerToken> iterator;
        int n2 = string2.indexOf("/*+");
        int n3 = string2.indexOf("*/", n2) + 2;
        if (n2 < 0 && (iterator = list.iterator()).hasNext()) {
            object = iterator.next();
            n3 = n2 = object.content.length();
        }
        if ((n = string.indexOf(string2)) == -1) {
            n = 0;
        }
        basicEditorPane.setSelectionStart(n + n2);
        basicEditorPane.setSelectionEnd(n + n3);
        object = string2.substring(n2, n3);
        String string3 = jMenuItem.getText();
        Object object2 = this.amendHint((String)object, string3);
        if (n2 == n3) {
            object2 = " " + (String)object2 + " ";
        }
        basicEditorPane.replaceSelection((String)object2);
    }

    private void replaceText(BasicEditorPane basicEditorPane, String string, String string2, List<LexerToken> list, String string3) {
        int n;
        Iterator<LexerToken> iterator;
        int n2 = string2.indexOf("/*+");
        int n3 = string2.indexOf("*/", n2) + 2;
        if (n2 < 0 && (iterator = list.iterator()).hasNext()) {
            LexerToken lexerToken = iterator.next();
            n3 = n2 = lexerToken.content.length();
        }
        if ((n = string.indexOf(string2)) == -1) {
            n = 0;
        }
        basicEditorPane.setSelectionStart(n + n2);
        basicEditorPane.setSelectionEnd(n + n3);
        basicEditorPane.replaceSelection(string3);
    }

    private String amendHint(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        Hint hint = Hint.parse(string2);
        String string3 = string.substring(3, string.length() - 2);
        List list = LexerToken.parse((String)string3);
        int n = -1;
        int n2 = -1;
        for (LexerToken lexerToken : list) {
            if (n < 0) {
                n = lexerToken.begin;
                continue;
            }
            if (n2 < 0) {
                if (!"(".equals(lexerToken.content)) {
                    n = lexerToken.begin;
                    continue;
                }
                n2 = lexerToken.begin;
                continue;
            }
            if (!")".equals(lexerToken.content)) continue;
            String string4 = string3.substring(n, lexerToken.end);
            Hint hint2 = Hint.parse(string4);
            if (hint.isModified(hint2)) {
                return string.replace(string4, string2.substring(3, string2.length() - 2));
            }
            n = -1;
            n2 = -1;
        }
        return "/*+" + string3 + " " + string2.substring(3, string2.length() - 2) + "*/";
    }
}

