/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.text.BadLocationException;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.SqlId;
import oracle.dbtools.util.SqlLocator;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetFeatures;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.autotrace.AbstractPanel;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.ExplainPlanAction;
import oracle.ide.controller.IdeAction;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class AutotraceActionProvider
implements ActionProvider<Void> {
    static final String oracleDriver = "oracle.jdbc.OracleDriver";
    public static final String AUTOTRACE_CMD_ID = "Worksheet.Autotrace";
    public static final String EXPLAINPLAN_CMD_ID = "Worksheet.Explainplan";
    private WorksheetAction autotraceAction = WorksheetAction.createWorksheetAction("Worksheet.Autotrace", WorksheetAction.ActionType.BOTH, 0, -10.0);
    static final String actionPrefix = "Worksheet.VSQL_Child";
    private static final String xPlanAction = "Worksheet.DBMS_XPLAN";
    private static final String[] IDs = new String[]{"Worksheet.Explainplan", "Worksheet.VSQL_Child0", "Worksheet.VSQL_Child1", "Worksheet.VSQL_Child2", "Worksheet.DBMS_XPLAN"};
    private WorksheetAction explainAction = WorksheetAction.createWorksheetAction(IDs, "Worksheet.Explainplan", WorksheetAction.ActionType.BOTH, 0, -10.0);
    private String sqlId;

    public static boolean canExplainAutotrace(String string, String string2) throws DBException, SQLException {
        if (AUTOTRACE_CMD_ID.equals(string) && !AutotraceActionProvider.isOracle(string2)) {
            return false;
        }
        return AutotraceActionProvider.isRegistered(string2);
    }

    private static boolean isRegistered(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        if (string2 != null) {
            WorksheetFeatures worksheetFeatures = WorksheetFeatures.getFeatures(string2);
            return worksheetFeatures.getAutotraceModelConstructor() != null;
        }
        return false;
    }

    private static boolean isOracle(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("driver");
        return oracleDriver.equals(string2);
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        boolean bl = false;
        try {
            bl = AutotraceActionProvider.canExplainAutotrace(string, worksheetContext.getConnectionName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return false;
        }
        BasicDocument basicDocument = (BasicDocument)worksheetContext.getEditor().getDocument();
        if (0 == basicDocument.getLength()) {
            return false;
        }
        if (xPlanAction.equals(string)) {
            this.updateChildMenuEntries(worksheetContext);
        }
        return true;
    }

    private void updateChildMenuEntries(WorksheetContext worksheetContext) {
        try {
            Connection connection;
            String string = this.getValidSqlStatementAtCursor(worksheetContext);
            if (string != null && (connection = Connections.getInstance().getConnection(worksheetContext.getConnectionName(), false)) != null) {
                this.calculateSqlId(string, connection);
            }
        }
        catch (Throwable throwable) {
            Logger.ignore(this.getClass(), (Throwable)throwable);
        }
    }

    private String getValidSqlStatementAtCursor(WorksheetContext worksheetContext) {
        String string = null;
        String string2 = worksheetContext.getConnectionName();
        if (string2 != null && Connections.getInstance().isOracle(string2)) {
            SyntaxError syntaxError;
            String string3 = worksheetContext.getParser().text;
            int n = worksheetContext.getEditor().getCaretPosition();
            string = SqlLocator.extractStmt((int)n, (String)string3, null);
            if (string != null && (syntaxError = SyntaxError.checkSQLQuerySyntax((String)string)) != null) {
                string = null;
            }
        }
        return string;
    }

    private void calculateSqlId(String string, Connection connection) throws Exception {
        OracleNLSProvider oracleNLSProvider = (OracleNLSProvider)NLSProvider.getProvider((Connection)connection);
        String string2 = oracleNLSProvider.getDBCharset();
        this.sqlId = SqlId.stmt2sqlid((String)string, (String)string2);
        for (int i = 0; i < 3; ++i) {
            this.vSQLmenus(i, this.sqlId);
        }
    }

    private void vSQLmenus(int n, String string) {
        IdeAction ideAction = IdeAction.find((String)(actionPrefix + n));
        ideAction.putValue("Name", (Object)this.menuLabel(n, string, true));
    }

    private String menuLabel(int n, String string, boolean bl) {
        if (string != null) {
            if (bl) {
                return "<html>V$SQL_PLAN.SQL_ID=<font color=blue>" + string + "</font>, V$SQL_PLAN.CHILD_NUMBER=<font color=blue>" + n + "</font>";
            }
            return "V$SQL_PLAN.SQL_ID=" + string + ", V$SQL_PLAN.CHILD_NUMBER=" + n;
        }
        return "V$SQL_PLAN.CHILD_NUMBER=" + n;
    }

    @Override
    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        boolean bl;
        if (xPlanAction.equals(string)) {
            BasicEditorPane basicEditorPane = worksheetContext.getEditor();
            String string2 = worksheetContext.getParser().text;
            int n = basicEditorPane.getCaretPosition();
            long l = SqlLocator.locate((int)n, (String)string2, (boolean)true);
            int n2 = Service.lY((long)l);
            try {
                basicEditorPane.insertString(n2, "\n\nselect * from table(dbms_xplan.display_cursor(sql_id=>'" + this.sqlId + "', format=>'ALLSTATS LAST'));\n", null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return null;
        }
        AnalyzeAction analyzeAction = null;
        boolean bl2 = bl = EXPLAINPLAN_CMD_ID.equals(string) || string.startsWith(actionPrefix);
        if (AUTOTRACE_CMD_ID.equals(string)) {
            analyzeAction = new AutotraceAction(string, worksheetContext);
        } else if (bl) {
            analyzeAction = new ExplainPlanAction(string, worksheetContext);
        } else {
            return null;
        }
        AutotracePanel autotracePanel = new AutotracePanel(string, bl, worksheetContext);
        analyzeAction.setAutoTracePanel(autotracePanel);
        ArrayList<IRaptorTaskListener> arrayList = new ArrayList<IRaptorTaskListener>();
        arrayList.add((IRaptorTaskListener)autotracePanel.new AbstractPanel.ResultsPanelTaskListener());
        for (IRaptorTaskListener iRaptorTaskListener : arrayList) {
            analyzeAction.getDescriptor().addListener(iRaptorTaskListener);
        }
        return analyzeAction != null ? new WorksheetTaskWrapper<Void>(analyzeAction, arrayList, Collections.emptyList(), worksheetContext) : null;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        if (n == 0) {
            return this.explainAction;
        }
        return this.autotraceAction;
    }

    @Override
    public int getActionsCount() {
        return 2;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }
}

