/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMSUtils;

public class OriginatorInfo
implements ASN1Object {
    private Vector certChoices;
    private Vector certLists;
    private ASN1Sequence contents = null;

    public OriginatorInfo() {
    }

    public OriginatorInfo(Vector certSet, Vector certRevocationLists) throws CertificateException {
        Vector X5092;
        this.certChoices = X5092 = CMSUtils.toX509Vector(certSet);
        this.certLists = certRevocationLists;
        this.contents = null;
    }

    public OriginatorInfo(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public void addCertificate(X509Certificate cert) throws IOException {
        try {
            if (this.certChoices == null) {
                this.certChoices = new Vector();
            }
            this.certChoices.addElement(new X509(cert.getEncoded()));
            this.contents = null;
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    public void addCertificate(Vector certs) throws CertificateException {
        if (this.certChoices == null) {
            this.certChoices = new Vector();
        }
        int j = certs.size();
        for (int i = 0; i < j; ++i) {
            this.certChoices.addElement(certs.elementAt(i));
        }
        Vector X5092 = CMSUtils.toX509Vector(this.certChoices);
        this.certChoices = null;
        this.certChoices = X5092;
        this.contents = null;
    }

    public void addCRL(CRL crl) {
        if (this.certLists == null) {
            this.certLists = new Vector();
        }
        this.certLists.addElement(crl);
        this.contents = null;
    }

    public void addCRL(Vector crls) {
        if (this.certLists == null) {
            this.certLists = new Vector();
        }
        int j = crls.size();
        for (int i = 0; i < j; ++i) {
            this.certLists.addElement(crls.elementAt(i));
        }
        this.contents = null;
    }

    public Vector getCertificateSet() throws CertificateException {
        return CMSUtils.toJCECertVector(this.certChoices);
    }

    public Vector getCertificateRevocationLists() {
        return this.certLists;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (seq.hasMoreData() && seq.getCurrentTag() == 0) {
            seq.setCurrentTag(17);
            ASN1SetInputStream certs = new ASN1SetInputStream((InputStream)seq);
            while (certs.hasMoreData()) {
                if (this.certChoices == null) {
                    this.certChoices = new Vector();
                }
                this.certChoices.addElement(new X509((InputStream)certs));
            }
            certs.terminate();
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 1) {
            seq.setCurrentTag(17);
            ASN1SetInputStream cs = new ASN1SetInputStream((InputStream)seq);
            while (cs.hasMoreData()) {
                if (this.certLists == null) {
                    this.certLists = new Vector();
                }
                this.certLists.addElement(new CRL((InputStream)cs));
            }
            cs.terminate();
        }
        seq.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence();
            if (this.certChoices != null) {
                this.contents.addElement((ASN1Object)new ASN1GenericConstructed(this.certChoices, 0));
            }
            if (this.certLists != null) {
                this.contents.addElement((ASN1Object)new ASN1GenericConstructed(this.certLists, 1));
            }
        }
        return this.contents;
    }
}

