/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

class EncryptedContentInfo
implements ASN1Object {
    private ASN1ObjectID contentType;
    private AlgorithmIdentifier contentEncryptionAlgID;
    private byte[] encryptedContent = null;
    private boolean writeEncryptedContent = true;
    private ASN1Sequence contents = null;

    EncryptedContentInfo(CMSContentInfo contentInfo, Cipher cipher) throws NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException {
        this(contentInfo, cipher, CMSUtils.getAlgoID(cipher.getAlgorithm()), true);
    }

    EncryptedContentInfo(CMSContentInfo contentInfo, Cipher cipher, AlgorithmIdentifier contentEncryptionAlgID) throws BadPaddingException, IllegalBlockSizeException {
        this(contentInfo, cipher, contentEncryptionAlgID, true);
    }

    EncryptedContentInfo(CMSContentInfo contentInfo, Cipher cipher, boolean writeEncryptedContent) throws NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException {
        this(contentInfo, cipher, CMSUtils.getAlgoID(cipher.getAlgorithm()), writeEncryptedContent);
    }

    EncryptedContentInfo(CMSContentInfo contentInfo, Cipher cipher, AlgorithmIdentifier contentEncryptionAlgID, boolean writeEncryptedContent) throws IllegalBlockSizeException, BadPaddingException {
        this.encryptedContent = cipher.doFinal(contentInfo.getExposedContent());
        String algo = cipher.getAlgorithm();
        if (cipher.getAlgorithm().indexOf("CBC") != -1) {
            byte[] iv = cipher.getIV();
            this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(contentEncryptionAlgID.getOID(), cipher.getIV());
        } else {
            this.contentEncryptionAlgID = contentEncryptionAlgID;
        }
        this.contentType = contentInfo.getContentType();
        this.writeEncryptedContent = writeEncryptedContent;
        this.contents = null;
    }

    EncryptedContentInfo(InputStream is) throws IOException {
        this.input(is);
    }

    ASN1ObjectID getContentType() {
        return this.contentType;
    }

    AlgorithmIdentifier getContentEncryptionAlgID() {
        return this.contentEncryptionAlgID;
    }

    byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    void setEncryptedContent(byte[] econtent) {
        this.encryptedContent = econtent;
        this.contents = null;
    }

    void writeDetached(boolean writeDetachedObject) {
        this.writeEncryptedContent = !writeDetachedObject;
        this.contents = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("content-type '");
        sb.append(CMSContentInfo.contentTypeName(this.contentType));
        sb.append("Algorithm: " + this.contentEncryptionAlgID);
        sb.append("' (");
        if (this.encryptedContent == null) {
            sb.append("detached");
        } else {
            sb.append(Utils.plural((int)this.encryptedContent.length, (String)"byte"));
            sb.append(" encrypted");
        }
        sb.append(")");
        return sb.toString();
    }

    CMSContentInfo getDecryptedContentInfo(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeyException, InvalidInputException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException {
        String algoName = CMSUtils.getAlgoName(this.contentEncryptionAlgID, true);
        SecretKeySpec contentEncryptionKey = new SecretKeySpec(keyBytes, algoName);
        return this.getDecryptedContentInfo(contentEncryptionKey);
    }

    CMSContentInfo getDecryptedContentInfo(SecretKey contentEncryptionKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidInputException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        String AlgoName = CMSUtils.addPadding(CMSUtils.getAlgoName(this.contentEncryptionAlgID));
        Cipher cipher = Cipher.getInstance(AlgoName);
        byte[] dc = null;
        try {
            if (this.contentEncryptionAlgID instanceof CBCAlgorithmIdentifier) {
                byte[] iv = ((CBCAlgorithmIdentifier)this.contentEncryptionAlgID).getIV();
                cipher.init(2, (Key)contentEncryptionKey, new IvParameterSpec(iv));
            } else if (this.contentEncryptionAlgID instanceof RC2AlgorithmIdentifier) {
                RC2AlgorithmIdentifier rc2AlgId = (RC2AlgorithmIdentifier)this.contentEncryptionAlgID;
                byte[] iv = rc2AlgId.getIV();
                int effectiveKeyLength = rc2AlgId.getEffectiveKeyLength();
                RC2ParameterSpec rc2Spec = new RC2ParameterSpec(effectiveKeyLength, iv);
                cipher.init(2, (Key)contentEncryptionKey, rc2Spec);
            } else {
                cipher.init(2, contentEncryptionKey);
            }
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException(ex.toString());
        }
        dc = cipher.doFinal(this.encryptedContent);
        if (this.contentType.equals((Object)CMS.id_data)) {
            return new CMSDataContentInfo(dc);
        }
        CMSContentInfo contentInfo = CMSContentInfo.makeDegenerate(this.contentType);
        if (contentInfo == null) {
            throw new IllegalStateException("Unknown content type.");
        }
        try {
            contentInfo.inputContent((InputStream)new UnsyncByteArrayInputStream(dc));
            contentInfo.setExposedContent(dc);
        }
        catch (IOException ex) {
            if (ex instanceof InvalidInputException) {
                throw (InvalidInputException)ex;
            }
            throw new StreamableInputException(ex.toString());
        }
        return contentInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream eci = new ASN1SequenceInputStream(is);
        this.contentType = new ASN1ObjectID((InputStream)eci);
        this.contentEncryptionAlgID = new AlgorithmIdentifier((InputStream)eci);
        String algoName = null;
        try {
            algoName = CMSUtils.getAlgoName(this.contentEncryptionAlgID);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex.toString());
        }
        if (algoName.indexOf("CBC") != -1) {
            try {
                ASN1Object params = this.contentEncryptionAlgID.getParameters();
                ASN1ObjectID oid = this.contentEncryptionAlgID.getOID();
                byte[] iv = null;
                if (params instanceof ASN1Sequence) {
                    this.contentEncryptionAlgID = new RC2AlgorithmIdentifier(oid, params);
                } else if (params instanceof ASN1OctetString) {
                    iv = ((ASN1OctetString)params).getValue();
                    this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(oid, iv);
                } else {
                    this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(oid, iv);
                }
            }
            catch (AlgorithmIdentifierException ex) {
                throw new IOException(ex.toString());
            }
        }
        if (eci.hasMoreData()) {
            if (eci.getCurrentTag() != 0) throw new ASN1FormatException("IMPLICIT [0] expected.");
            eci.setCurrentTag(4);
            this.encryptedContent = ASN1OctetString.inputValue((InputStream)eci);
        } else {
            this.encryptedContent = null;
        }
        eci.terminate();
        this.contents = null;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.contentType);
            s.addElement((ASN1Object)this.contentEncryptionAlgID);
            if (this.encryptedContent != null && this.writeEncryptedContent) {
                s.addElement((ASN1Object)new ASN1GenericPrimitive(this.encryptedContent, 0));
            }
            this.contents = s;
        }
        return this.contents;
    }
}

