/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.GeneralNames;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class ESSCertID
implements ASN1Object {
    private byte[] certHash;
    private GeneralNames certGeneralNames;
    private BigInteger serialNo;
    private ASN1Sequence contents;

    public ESSCertID(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(CMS.sha_1));
        this.certHash = md.digest(cert.getEncoded());
        this.certGeneralNames = null;
        this.serialNo = null;
        this.contents = null;
    }

    public ESSCertID(X509Certificate cert, X509Certificate caCert, boolean issuerSerial) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(CMS.sha_1));
        this.certHash = md.digest(cert.getEncoded());
        if (issuerSerial) {
            X509 caCertX509 = CMSUtils.convertX509(caCert);
            this.certGeneralNames = new GeneralNames(caCertX509.getIssuer());
            this.serialNo = caCert.getSerialNumber();
        }
        this.contents = null;
    }

    public ESSCertID(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public GeneralNames getGeneralNames() {
        return this.certGeneralNames;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public boolean compareTo(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        ESSCertID cmp = new ESSCertID(cert);
        return Utils.areEqual((byte[])this.certHash, (byte[])cmp.getCertHash());
    }

    public boolean compareTo(X509Certificate cert, X509Certificate caCert) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (!this.compareTo(cert)) {
            return false;
        }
        if (this.certGeneralNames != null && this.serialNo != null) {
            ESSCertID obj = new ESSCertID(cert, caCert, true);
            boolean present = false;
            GeneralNames gnames = obj.getGeneralNames();
            if (gnames == null) {
                return false;
            }
            Vector gns = gnames.getGeneralNames();
            if (gns == null) {
                return false;
            }
            int size = gns.size();
            for (int i = 0; i < size && !present; ++i) {
                if (!this.certGeneralNames.containsGeneralName((GeneralName)gns.elementAt(i))) continue;
                present = true;
            }
            if (!present) {
                return false;
            }
            if (!this.serialNo.equals(obj.getSerialNo())) {
                return false;
            }
        }
        return true;
    }

    public boolean containsIssuerSerial() {
        return this.certGeneralNames != null && this.serialNo != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ESSCertID)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((ESSCertID)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.certHash = ASN1OctetString.inputValue((InputStream)seq);
        this.certGeneralNames = null;
        this.serialNo = null;
        if (seq.hasMoreData()) {
            ASN1SequenceInputStream seq1 = new ASN1SequenceInputStream((InputStream)seq);
            if (seq1.hasMoreData()) {
                this.certGeneralNames = new GeneralNames((InputStream)seq1);
                this.serialNo = ASN1Integer.inputValue((InputStream)seq1);
            }
            seq1.terminate();
        }
        seq.terminate();
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)new ASN1OctetString(this.certHash));
            if (this.certGeneralNames != null && this.serialNo != null) {
                ASN1Sequence isn = new ASN1Sequence();
                isn.addElement((ASN1Object)this.certGeneralNames);
                isn.addElement((ASN1Object)new ASN1Integer(this.serialNo));
                seq.addElement((ASN1Object)isn);
            }
            this.contents = seq;
        }
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(" certHash = " + Utils.toHexString((byte[])this.certHash));
        if (this.certGeneralNames != null && this.serialNo != null) {
            sb.append("; Issuer General Names: " + this.certGeneralNames);
            sb.append("; serialNo = " + this.serialNo);
        } else {
            sb.append("; IssuerSerial NOT present");
        }
        return sb.toString();
    }
}

