/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.util.OutputGenerationException;

class ECIOutputStream
extends FilterOutputStream {
    private ASN1Object enclosedContentType;
    private Cipher cipher;
    private AlgorithmIdentifier encryptionAlgID;
    private static final int TARGET_BUFSIZE = 512;
    private int bufSize;
    private int blockSize;
    private byte[] cipherBuf;
    private byte[] block;
    private int inblock;
    private int count;
    private boolean writeContent = true;

    ECIOutputStream(OutputStream out, Cipher cipher, ASN1ObjectID enclosedContentType) {
        this(out, cipher, enclosedContentType, null);
    }

    ECIOutputStream(OutputStream out, Cipher cipher, ASN1ObjectID enclosedContentType, AlgorithmIdentifier encAlgID) {
        super(out);
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        this.bufSize = Math.max(512 / this.blockSize, 1) * this.blockSize;
        this.block = new byte[this.blockSize];
        this.encryptionAlgID = encAlgID;
        this.inblock = 0;
        this.enclosedContentType = enclosedContentType;
        this.count = 0;
        this.cipherBuf = new byte[this.bufSize];
    }

    void writeInitial(boolean writeEncryptedContent) throws IOException {
        ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
        this.enclosedContentType.output(this.out);
        try {
            if (this.cipher.getAlgorithm().indexOf("CBC") != -1) {
                if (this.encryptionAlgID == null) {
                    new CBCAlgorithmIdentifier(CMSUtils.getAlgoID(this.cipher.getAlgorithm()).getOID(), this.cipher.getIV()).output(this.out);
                } else {
                    new CBCAlgorithmIdentifier(this.encryptionAlgID.getOID(), this.cipher.getIV()).output(this.out);
                }
            } else {
                CMSUtils.getAlgoID(this.cipher.getAlgorithm()).output(this.out);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex.toString());
        }
        if (writeEncryptedContent) {
            ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
        } else {
            this.writeContent = false;
        }
    }

    private void flushBlock(boolean encrypt) throws IOException {
        try {
            if (encrypt) {
                this.cipher.doFinal(this.block, 0, this.blockSize, this.cipherBuf, this.count);
            } else {
                this.cipher.update(this.block, 0, this.blockSize, this.cipherBuf, this.count);
            }
        }
        catch (ShortBufferException ex) {
            throw new OutputGenerationException((Exception)ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new OutputGenerationException((Exception)ex);
        }
        catch (BadPaddingException ex) {
            throw new OutputGenerationException((Exception)ex);
        }
        this.count += this.blockSize;
        this.inblock = 0;
        if (this.count == this.cipherBuf.length) {
            this.flushCipherBuf();
        }
    }

    private void flushBlock() throws IOException {
        this.flushBlock(false);
    }

    private void flushCipherBuf() throws IOException {
        if (this.count > 0 && this.writeContent) {
            ASN1OctetString.outputValue((OutputStream)this.out, (byte[])this.cipherBuf, (int)0, (int)this.count);
        }
        this.count = 0;
    }

    void writeFinal() throws IOException {
        if (this.blockSize > 1) {
            if (this.blockSize > 255) {
                throw new IllegalStateException("Block size too large for PKCS-5 padding.");
            }
            int rem = this.blockSize - this.inblock;
            for (int i = this.inblock; i < this.blockSize; ++i) {
                this.block[i] = (byte)rem;
            }
        }
        this.flushBlock(true);
        this.flushCipherBuf();
        if (this.writeContent) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        }
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
    }

    @Override
    public void write(int ch) throws IOException {
        this.block[this.inblock++] = (byte)ch;
        if (this.inblock == this.blockSize) {
            this.flushBlock();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int blockrem = this.blockSize - this.inblock;
        System.out.println(new String(b));
        if (len <= blockrem) {
            System.arraycopy(b, off, this.block, this.inblock, len);
            this.inblock += len;
            if (this.inblock == this.blockSize) {
                this.flushBlock();
            }
        } else {
            int m;
            System.arraycopy(b, off, this.block, this.inblock, blockrem);
            this.flushBlock();
            try {
                m = blockrem;
                while (m + this.blockSize <= len) {
                    this.cipher.update(b, off + m, this.blockSize, this.cipherBuf, this.count);
                    this.count += this.blockSize;
                    if (this.count == this.bufSize) {
                        this.flushCipherBuf();
                    }
                    m += this.blockSize;
                }
            }
            catch (ShortBufferException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            this.inblock = len - m;
            System.arraycopy(b, off + m, this.block, 0, this.inblock);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        this.flushCipherBuf();
        this.out.flush();
    }
}

