/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public final class CMSSignerInfoSpec {
    private IssuerAndSerialNo iasn;
    private AlgorithmIdentifier digestAlgID;
    private AlgorithmIdentifier digestEncryptionAlgID;
    private AttributeSet authenticatedAttributes;
    private AttributeSet unauthenticatedAttributes;
    private PrivateKey signerKey;
    private boolean useSPKI;
    private byte[] spki64;
    private byte[] spki160;
    private boolean useSPKI64;

    public CMSSignerInfoSpec(AttributeSet authenticatedAttributes, PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet unauthenticatedAttributes) throws NoSuchAlgorithmException {
        this(authenticatedAttributes, signerKey, signerCert, digestAlgID, digestEncryptionAlgID, unauthenticatedAttributes, false);
    }

    public CMSSignerInfoSpec(AttributeSet authenticatedAttributes, PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet unauthenticatedAttributes, boolean useSPKI) throws NoSuchAlgorithmException {
        this.authenticatedAttributes = authenticatedAttributes;
        this.signerKey = signerKey;
        this.digestAlgID = digestAlgID;
        this.digestEncryptionAlgID = digestEncryptionAlgID;
        this.unauthenticatedAttributes = unauthenticatedAttributes;
        this.useSPKI = useSPKI;
        try {
            X509 cer = new X509(signerCert.getEncoded());
            this.iasn = new IssuerAndSerialNo(cer.getIssuer(), signerCert.getSerialNumber());
        }
        catch (CertificateEncodingException e) {
            throw new NoSuchAlgorithmException("This is a certificate encoding exception");
        }
        catch (IOException ex) {
            throw new NoSuchAlgorithmException("This is an IO exception");
        }
        this.spki160 = CMSUtils.generateSPKI160(signerCert);
        this.spki64 = CMSUtils.generateSPKI64(signerCert);
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(new String(this.iasn.getEncoded()));
        sb.append(this.digestAlgID.hashCode());
        sb.append(this.digestEncryptionAlgID.hashCode());
        if (this.authenticatedAttributes != null) {
            sb.append(new String(Utils.toBytes((Streamable)this.authenticatedAttributes)));
        }
        if (this.unauthenticatedAttributes != null) {
            sb.append(new String(Utils.toBytes((Streamable)this.unauthenticatedAttributes)));
        }
        sb.append(new String(this.signerKey.getEncoded()));
        sb.append(this.useSPKI);
        sb.append(new String(this.spki64));
        sb.append(new String(this.spki160));
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSSignerInfoSpec)) {
            return false;
        }
        CMSSignerInfoSpec o = (CMSSignerInfoSpec)obj;
        if (!(this.iasn.equals((Object)o.getIASN()) && this.digestAlgID.equals((Object)o.getDigestAlgID()) && this.digestEncryptionAlgID.equals((Object)o.getDigestEncryptionAlgID()) && this.signerKey.equals(o.getSignerKey()) && Utils.areEqual((byte[])this.spki64, (byte[])o.generate64BitSPKI()) && Utils.areEqual((byte[])this.spki160, (byte[])o.generate160BitSPKI()) && this.useSPKI64 == o.isSPKI64() && this.useSPKI == o.isSPKI())) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public byte[] generate64BitSPKI() {
        return this.spki64;
    }

    public byte[] generate160BitSPKI() {
        return this.spki160;
    }

    public void useSPKI64(boolean useSPKI64) {
        this.useSPKI64 = useSPKI64;
    }

    byte[] getSPKI() {
        if (!this.useSPKI) {
            return null;
        }
        if (this.useSPKI64) {
            return this.spki64;
        }
        return this.spki160;
    }

    public boolean isSPKI64() {
        return this.useSPKI64;
    }

    IssuerAndSerialNo getIASN() {
        return this.iasn;
    }

    public X500Name getIssuer() {
        return this.iasn.getIssuer();
    }

    public BigInteger getSerialNo() {
        return this.iasn.getSerialNo();
    }

    public AttributeSet getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AttributeSet getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.digestAlgID;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return this.digestEncryptionAlgID;
    }

    public PrivateKey getSignerKey() {
        return this.signerKey;
    }

    public boolean isSPKI() {
        return this.useSPKI;
    }
}

